/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.text.MessageFormat;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSession;
import oracle.opatch.ioc.IOC;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class EnableIOCSession
extends OPatchSession {
    protected EnableIOCSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    @Override
    public void process(String oracleHome) {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            OLogger.println("EnableIOCSession will be skipped because IOC is not supported.");
            return;
        }
        OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
        OLogger.println(MessageFormat.format("EnableIOCSession process on cas_repo \"{0}\"... ", oracleHome));
        try {
            if (!IOC.INSTANCE.isInventoryConverted()) {
                OLogger.println("Convert inventory over cas");
                IOC.INSTANCE.convertInventory();
            } else {
                OLogger.println("Inventory has been converted over cas");
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }
}

