/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class InitScriptAction
extends PatchAction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3274365384114696148L;
    private boolean realEmptyAction = true;
    private String initScriptFile = null;
    private String initOptions;
    private String topLevelOperation;
    private String topLevelPatchID;

    public InitScriptAction() {
    }

    @Override
    protected void makeNoOp() {
        this.noOp = true;
    }

    public boolean isRealEmpty() {
        return this.realEmptyAction;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public InitScriptAction(String initScriptLoc) {
        super(-1);
        if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2) {
            this.noOp = true;
            return;
        }
        try {
            this.initScriptFile = initScriptLoc;
            if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]), new LinkOption[0])) {
                this.noOp = true;
            } else {
                this.noOp = false;
                this.realEmptyAction = false;
            }
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("InitScriptAction::InitScriptAction(): IOException, set to no-op"));
            this.noOp = true;
        }
    }

    public int process(String initOptions, String topLevelOperation, String topLevelPatchID) {
        boolean cont = Rules.SystemWrite_continue();
        if (!this.noOp) {
            StringBuffer tmpB = new StringBuffer("Executing init script file: ");
            tmpB.append(this.initScriptFile.toString());
            OLogger.debug(tmpB);
            if (!cont) {
                StringBuffer buff = new StringBuffer("REPORT: skips executing InitScriptAction::process()");
                OLogger.log(OLogger.FINEST, buff.toString());
                return 0;
            }
            SystemCall.ExecReturn ret = null;
            String[] systemCommand = new String[1];
            try {
                systemCommand[0] = OPatchEnv.isWindows() ? "cmd /C \"" + WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]).toAbsolutePath().normalize().toString() + "\" " + initOptions : "sh " + WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]).toAbsolutePath().normalize().toString() + " " + initOptions;
            }
            catch (Exception e2) {
                OLogger.error("OUI-67034", new Object[]{"getCanonicalPath", e2.getMessage()});
            }
            String runDir = WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]).getParent().toString();
            String[] envp = null;
            envp = topLevelOperation != null && topLevelPatchID != null ? new String[]{"OPATCH_OPERATION=" + topLevelOperation, "OPATCH_PATCHID=" + topLevelPatchID, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : (topLevelOperation == null && topLevelPatchID != null ? new String[]{"OPATCH_PATCHID=" + topLevelPatchID, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : (topLevelOperation != null && topLevelPatchID == null ? new String[]{"OPATCH_OPERATION=" + topLevelOperation, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : new String[]{"ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")}));
            SystemCall.setConsoleOutput(true);
            StringBuffer buff = new StringBuffer("Output of init script: ");
            buff.append(this.initScriptFile.toString());
            OLogger.debug(buff);
            String headerStr = OLogger.getString("OUI-67604", new Object[]{systemCommand[0]});
            OLogger.printlnOnLog(headerStr);
            ret = SystemCall.runtimeExec(systemCommand, envp, runDir);
            Integer tmpI = new Integer(ret.getReturnCode());
            String tailStr = OLogger.getString("OUI-67605", new Object[]{tmpI.toString()});
            OLogger.printlnOnLog(tailStr);
            SystemCall.setConsoleOutput(false);
            String outputStr = OLogger.getString("OUI-67102", new Object[]{systemCommand[0], ret.getNormalMessage(), tmpI.toString()});
            String envVal = OUIReplacer.getEnv("OPATCH_LOG_PREPOST_ARGS");
            Boolean boolVal = new Boolean(envVal);
            boolean isCmdToLog = boolVal;
            if (isCmdToLog) {
                OLogger.printlnOnLog(OLogger.INFO, outputStr);
            } else {
                String logStr = OLogger.getString("OUI-67102", new Object[]{" Command and arguments of init script is restricted to be viewed in log file ", ret.getNormalMessage(), tmpI.toString()});
                OLogger.printlnOnLog(OLogger.INFO, logStr);
            }
            if (!ret.isOK()) {
                OLogger.info("OUI-67021", new Object[]{ret.getErrorMessage(), tmpI.toString()});
            }
            return ret.getReturnCode();
        }
        OLogger.debug(new StringBuffer("InitScriptAction::process() is a no-op"));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String filePath = "n/a";
        if (this.initScriptFile != null) {
            filePath = this.initScriptFile.toString();
        }
        String header = "[InitScriptAction:-------------------------------\n";
        StringBuffer sb = new StringBuffer(header);
        sb.append("no-op.=");
        sb.append(this.noOp);
        sb.append(", fileLoc=");
        sb.append(filePath);
        sb.append("\n");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]), new OpenOption[0])));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (FileNotFoundException e2) {
            sb.append("Init script not present.");
        }
        catch (Exception e3) {
            sb.append("Error reading the file ");
            sb.append(e3.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e4) {
                    sb.append("Error closing file ");
                    sb.append(e4.getMessage());
                }
            }
        }
        sb.append("-----------------------------------------------]\n");
        return sb.toString();
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        return WrapperFactory.getNioServiceWrapper().getPath(this.initScriptFile, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public String getActionName() {
        return "InitScriptAction";
    }

    @Override
    public String getActionDesc() {
        return "Run the init script of the patch.";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public InitScriptAction setScriptArguments(String opt, String op, String patchId) {
        this.initOptions = opt;
        this.topLevelOperation = op;
        this.topLevelPatchID = patchId;
        return this;
    }

    public int process() {
        if (!this.realEmptyAction) {
            this.noOp = false;
        }
        return this.process(this.initOptions, this.topLevelOperation, this.topLevelPatchID);
    }
}

