/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchObject;
import oracle.opatch.Rac;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

class RACPropagationState
extends OPatchState {
    public RACPropagationState() {
        super(14, 202, 230, "RAC propagation", OLogger.INFO, false);
    }

    public void setPresentForRac(PatchObject[] po, IIPMReadServices readServices) {
        this.present = false;
        Rac.RacType racType = null;
        Rac rac = OPatchExternalFactory.getRac(null);
        racType = rac.getInstance(readServices);
        OPatchEnv.setRacType(racType);
        if (!po[0].isNoOp() && rac.shouldPropagate(racType)) {
            this.present = true;
        }
    }

    protected String getStateAssociateMessage(String oracleHome, PatchObject[] patchObject) {
        StringBuffer buff = new StringBuffer("");
        Rac.RacType racType = OPatchEnv.getRacType();
        String[] remoteNodes = racType.getRemoteNodes();
        if (remoteNodes.length != 0) {
            buff.append("Patch the following nodes:\n");
            for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                buff.append(remoteNodes[i2] + "\n");
            }
        }
        return buff.toString();
    }
}

