/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import com.oracle.cie.gdr.external.impl.LibraryGeneratorImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.nextgen.LibraryRegenerationState;
import oracle.sysman.nextgen.NextGenPatching;
import oracle.sysman.nextgen.NextGenPatchingException;
import oracle.sysman.nextgen.NextGenPatchingFactory;

public class RegenerateLib {
    PatchObject[] patchObjects;
    String oracleHomePath;
    Set<String> fileNameSet;

    public RegenerateLib(PatchObject patchObject, String oracleHomePath) {
        this.patchObjects = new PatchObject[1];
        this.patchObjects[0] = patchObject;
        this.patchObjects = this.patchObjects;
        this.oracleHomePath = oracleHomePath;
        this.fileNameSet = new HashSet<String>();
    }

    public RegenerateLib(PatchObject[] patchObjects, String oracleHomePath) {
        this.patchObjects = patchObjects;
        this.oracleHomePath = oracleHomePath;
        this.fileNameSet = new HashSet<String>();
    }

    public void regenerate() {
        OLogger.debug("RegenerateLib::regenerate()");
        List<File> fileList = this.getFilesList();
        Path oracleHome = WrapperFactory.getNioServiceWrapper().getPath(this.oracleHomePath, new String[0]);
        boolean isRegenerationNeeded = false;
        NextGenPatching nextgenPatching = null;
        LibraryRegenerationState libraryRegenerationState = null;
        try {
            nextgenPatching = NextGenPatchingFactory.getNextGenPatching((File)oracleHome.toFile());
            libraryRegenerationState = nextgenPatching.checkRegenerateLibraries(fileList);
            isRegenerationNeeded = libraryRegenerationState.isRegenerationNeeded();
            if (isRegenerationNeeded) {
                OPatchEnv.setRegenerationNeeded();
            }
        }
        catch (NextGenPatchingException ngpEx) {
            RuntimeException re = new RuntimeException("Check if library regeneration is needed with error message: " + ngpEx.getMessage(), ngpEx);
            re.setStackTrace(ngpEx.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            OLogger.println("Library regeneration check has failed. OPatch needs to restore the system.");
            RuntimeException re = new RuntimeException("(Throwable) Check if library regeneration is needed with error message: " + t.getMessage(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        if (!isRegenerationNeeded) {
            OLogger.onlyLogInfo("OUI-68017");
        } else {
            OLogger.onlyLogInfo("OUI-68018");
            Set librariesToRegenerate = libraryRegenerationState.getLibrariesToRegenerate();
            try {
                this.backUpLibrariesForRestore(librariesToRegenerate);
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException("Backup libraries to be regenerated failed with error message \"" + t.getMessage() + "\"", t);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            if (librariesToRegenerate != null) {
                for (File file : librariesToRegenerate) {
                    OLogger.onlyLogInfo("OUI-68019", new Object[]{file.getAbsolutePath()});
                }
            }
            try {
                nextgenPatching.regenerateLibraries(oracleHome.toFile(), fileList);
            }
            catch (NextGenPatchingException ngpEx) {
                OPatchEnv.setRLibSuccess(false);
                RuntimeException re = new RuntimeException(ngpEx.getMessage(), ngpEx);
                re.setStackTrace(ngpEx.getStackTrace());
                throw re;
            }
        }
    }

    public boolean isRegenerationNeeded() throws NextGenPatchingException {
        boolean isRegenerationNeeded = false;
        List<File> fileList = this.getFilesList();
        NextGenPatching nextgenPatching = NextGenPatchingFactory.getNextGenPatching((File)new File(this.oracleHomePath));
        LibraryRegenerationState libraryRegenerationState = nextgenPatching.checkRegenerateLibraries(fileList);
        isRegenerationNeeded = libraryRegenerationState.isRegenerationNeeded();
        return isRegenerationNeeded;
    }

    private List<File> getFilesList() {
        for (PatchObject po : this.patchObjects) {
            this.addJarActionList(po.getAllJarActionForRLib());
            this.addDeleteJarActionList(po.getAllDeleteJarActionForRLib());
            this.addCopyActionList(po.getAllCopyActionForRLib());
        }
        StringBuffer ts = new StringBuffer("Files proceed for library regeneration checking are ");
        OLogger.logTime(ts);
        ArrayList<File> fileList = new ArrayList<File>();
        for (String fileName : this.fileNameSet) {
            fileList.add(WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]).toFile());
            ts = new StringBuffer(fileName + " is added at ");
            OLogger.logTime(ts);
        }
        return fileList;
    }

    private void addJarActionList(ListIterator jarActions) {
        while (jarActions.hasNext()) {
            Object p2 = jarActions.next();
            if (!(p2 instanceof JarAction)) continue;
            JarAction jarAct = (JarAction)p2;
            StringBuffer dst = new StringBuffer();
            dst.append(jarAct.getJarPath());
            dst.append(File.separator);
            dst.append(jarAct.getJarName());
            String[] splitNames = dst.toString().split(":");
            this.fileNameSet.add(splitNames[0]);
        }
    }

    private void addDeleteJarActionList(ListIterator deleteJarActions) {
        while (deleteJarActions.hasNext()) {
            Object p2 = deleteJarActions.next();
            if (!(p2 instanceof DeleteJarAction)) continue;
            DeleteJarAction deleteJarAct = (DeleteJarAction)p2;
            StringBuffer dst = new StringBuffer();
            dst.append(deleteJarAct.getJarPath());
            dst.append(File.separator);
            dst.append(deleteJarAct.getJarName());
            String[] splitNames = dst.toString().split(":");
            this.fileNameSet.add(splitNames[0]);
        }
    }

    private void addCopyActionList(ListIterator copyActions) {
        while (copyActions.hasNext()) {
            Object p2 = copyActions.next();
            if (!(p2 instanceof CopyAction)) continue;
            CopyAction cpAct = (CopyAction)p2;
            String fileName = cpAct.getPath() + File.separator + cpAct.getCopyName();
            this.fileNameSet.add(fileName);
        }
    }

    private void backUpLibrariesForRestore(Set<File> files) {
        if (files == null || !this.setupLibraryStorage()) {
            return;
        }
        String loc = OPatchEnv.getRLibBackupDir();
        for (File f2 : files) {
            StringBuilder dst = new StringBuilder(loc);
            dst.append(f2.getAbsolutePath().substring(this.oracleHomePath.length()));
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst.toString(), new String[0]);
            if (Files.exists(dstFile.getParent(), new LinkOption[0])) continue;
            try {
                Files.createDirectories(dstFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            try {
                SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(f2.getAbsolutePath(), new String[0]), dstFile);
            }
            catch (Exception e3) {
                OLogger.debug(e3.getMessage());
            }
        }
    }

    private boolean setupLibraryStorage() {
        String loc = OPatchEnv.getRLibBackupDir();
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]);
        StringBuffer buff = new StringBuffer("Try to mkdir on \"");
        buff.append(f2);
        buff.append("\"");
        OLogger.debug(buff);
        if (Files.exists(f2, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createDirectories(f2, new FileAttribute[0]);
            return true;
        }
        catch (IOException e2) {
            buff = new StringBuffer("Unable to setup backup location for library restore at ");
            buff.append(loc);
            buff.append("\".");
            buff.append("\nOPatch will skip backing up libraries.");
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            return false;
        }
    }

    public static void restoreLibraries(String oracleHomePath, String cookedPatchID) {
        Path src = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getRLibBackupDir(), new String[0]);
        if (!Files.exists(src, new LinkOption[0])) {
            OLogger.info("OUI-67209");
            return;
        }
        if (SystemCall.copyRecurse(src, WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]), true, false)) {
            OLogger.info("OUI-67209");
            throw new RuntimeException("Restore: Copying of regenerated libraries from backup area failed");
        }
        SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, src, true);
    }

    public Map<Path, String> getuRLibFiles(boolean isSnowballPatching, boolean isApply) {
        OLogger.debug("RegenerateLib::getuRLibFiles()");
        HashSet<Path> metaFileSet = new HashSet<Path>();
        HashSet<String> patchUPIs = new HashSet<String>();
        for (PatchObject po : this.patchObjects) {
            if (!isSnowballPatching) {
                this.addJarActionList(po.getAllJarActionForRLib());
                this.addDeleteJarActionList(po.getAllDeleteJarActionForRLib());
            }
            this.addCopyActionListRLib(po, metaFileSet, isApply);
            if (isApply) continue;
            patchUPIs.add(po.getPatchUniqID());
        }
        StringBuffer ts = new StringBuffer("Files proceed for library regeneration checking are ");
        OLogger.logTime(ts);
        HashSet<Path> fileSet = new HashSet<Path>();
        for (String fileName : this.fileNameSet) {
            Path filePath = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            fileSet.add(filePath);
        }
        Path oracleHome = WrapperFactory.getNioServiceWrapper().getPath(this.oracleHomePath, new String[0]);
        OLogger.onlyLogInfo("OUI-68018");
        HashMap<Path, String> copy = new HashMap<Path, String>();
        try {
            Map rLibFiles;
            LibraryGeneratorImpl libGen = new LibraryGeneratorImpl(oracleHome);
            if (isApply) {
                OLogger.justlog(OLogger.INFO, "For apply, lib regen fileSet: " + fileSet.size());
                OLogger.justlog(OLogger.INFO, "For apply, lib regen metaFileSet: " + metaFileSet.size());
                rLibFiles = libGen.queryLibrarySource(fileSet, metaFileSet);
            } else {
                OLogger.justlog(OLogger.INFO, "For rollback, lib regen fileSet: " + fileSet.size());
                OLogger.justlog(OLogger.INFO, "For rollback, lib regen patchUPIs: " + patchUPIs.size());
                rLibFiles = libGen.queryLibraryRollbackSource(fileSet, patchUPIs);
            }
            for (Map.Entry entry : rLibFiles.entrySet()) {
                Set files = (Set)entry.getValue();
                for (Path file : files) {
                    String value = file.toString();
                    copy.put(file, value);
                }
            }
            OLogger.justlog(OLogger.INFO, "RegenerateLib::Libraries to copy: " + copy.size());
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return copy;
    }

    private void addCopyActionListRLib(PatchObject po, Set<Path> metaFileSet, boolean isApply) {
        ListIterator copyActions = po.getAllCopyActionForRLib();
        while (copyActions.hasNext()) {
            String aFile;
            Object p2 = copyActions.next();
            if (!(p2 instanceof CopyAction)) continue;
            CopyAction cpAct = (CopyAction)p2;
            String fileName = cpAct.getPath() + File.separator + cpAct.getCopyName();
            this.fileNameSet.add(fileName);
            if (!isApply || !(aFile = cpAct.getCopyName()).equals("compDef.xml") && !aFile.contains(".xdiff")) continue;
            String aFileAbsolute = po.getPatchLocation() + File.separator + "files" + File.separator + cpAct.getFilename();
            Path aFileFullPath = WrapperFactory.getNioServiceWrapper().getPath(aFileAbsolute, new String[0]);
            metaFileSet.add(aFileFullPath);
        }
    }
}

