/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSession;
import oracle.opatch.cas.CASStabilityServices;
import oracle.opatch.opatchlogger.OLogger;

public class RestoreStabilitySession
extends OPatchSession {
    protected RestoreStabilitySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    @Override
    public void process(String oracleHomePath) throws RuntimeException {
        if (OPatchEnv.isHelp()) {
            this.displayHelp();
            return;
        }
        OPatchOverCAS.INSTANCE.initializeCAS(oracleHomePath);
        CASStabilityServices css = new CASStabilityServices();
        try {
            OLogger.println(MessageFormat.format("Restoring Stability for Oracle Home \"{0}\" ", oracleHomePath));
            css.restore(oracleHomePath);
        }
        catch (Throwable e2) {
            OLogger.println(MessageFormat.format("Restore Stability failed: {0} ", e2.getMessage()));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "restorestability_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

