/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.opatch.CustomizedActionResults;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class SparseCopyPreCustomizedAction
implements ICustomizedActions {
    private List<SparseCopyContext> sccs;
    private String oracleHomePath;
    private PatchObject pObject;
    private Set<String> leftAppDirs;

    public SparseCopyPreCustomizedAction(List<SparseCopyContext> sccs, String oracleHomePath, PatchObject pObject, Set<String> leftAppDirs) {
        this.sccs = sccs;
        this.oracleHomePath = oracleHomePath;
        this.pObject = pObject;
        this.leftAppDirs = leftAppDirs;
    }

    @Override
    public ICustomizedActionResults run() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: SparseCopyPreCustomizedAction::run()");
        ArrayList<String> files = new ArrayList<String>();
        ArrayList appDirs = this.pObject.getApplicationDirs();
        for (String appDir : appDirs) {
            Path oldAppVerDir;
            Path priorAppPtrFile;
            if (!this.leftAppDirs.contains(appDir)) {
                OLogger.printlnOnLog(MessageFormat.format("The application directory {0} has been prepared", appDir));
                continue;
            }
            OLogger.printlnOnLog(MessageFormat.format("prepare for the application directory {0}", appDir));
            SparseCopyContext scc = new SparseCopyContext();
            scc.setApplicationDir(appDir);
            boolean isFirstAppVerDirExist = this.checkFirstAppVerDirExist(appDir);
            scc.setFirstAppVerDirExist(isFirstAppVerDirExist);
            if (!isFirstAppVerDirExist) {
                this.sccs.add(scc);
                continue;
            }
            scc.setDeleteOldDirectory(this.pObject.isDeleteOldDirectory());
            OLogger.printlnOnLog(MessageFormat.format("The flag DELETE_OLD_DIRECTORY is set to {0}", scc.isDeleteOldDirectory()));
            Path latestAppPtrFile = this.getLatestAppPtrFile(this.oracleHomePath, appDir);
            if (latestAppPtrFile != null) {
                OLogger.printlnOnLog(MessageFormat.format("The Latest pointer file is: {0}", latestAppPtrFile.toAbsolutePath().toString()));
                scc.setLatestAppPtrFile(latestAppPtrFile);
            }
            if ((priorAppPtrFile = this.getPriorAppPtrFile(this.oracleHomePath, appDir)) != null) {
                OLogger.printlnOnLog(MessageFormat.format("The prior pointer file is: {0}", priorAppPtrFile.toAbsolutePath().toString()));
                scc.setPriorAppPtrFile(priorAppPtrFile);
            }
            if ((oldAppVerDir = this.getOldAppVerDir(appDir)) != null) {
                OLogger.printlnOnLog(MessageFormat.format("The old application version directory is: {0}", oldAppVerDir.toAbsolutePath().toString()));
                scc.setOldAppVerDir(oldAppVerDir);
            }
            Path newAppVerFromPatchDir = this.getNewAppVerFromPatchDir(appDir);
            OLogger.printlnOnLog(MessageFormat.format("The new application version directory is: {0}", newAppVerFromPatchDir.toAbsolutePath().toString()));
            try {
                if (!Files.exists(newAppVerFromPatchDir, new LinkOption[0])) {
                    Files.createDirectory(newAppVerFromPatchDir, new FileAttribute[0]);
                }
            }
            catch (NoSuchFileException e2) {
                OLogger.printlnOnLog("Create directory :" + newAppVerFromPatchDir.toString() + "failed");
            }
            catch (Exception e3) {
                RuntimeException re = new RuntimeException("OPatch failed to create new application version directory " + newAppVerFromPatchDir.toAbsolutePath().toString());
                throw re;
            }
            scc.setNewAppVerFromPatchDir(newAppVerFromPatchDir);
            Path currentAppVerDir = this.getCurrentAppVerDir(appDir);
            if (currentAppVerDir != null && Files.exists(currentAppVerDir, new LinkOption[0])) {
                OLogger.printlnOnLog(MessageFormat.format("The current application version directory is: {0}", currentAppVerDir.toAbsolutePath().toString()));
                scc.setCurrentAppVerDir(currentAppVerDir);
            } else {
                scc.setCurrentAppVerDir(newAppVerFromPatchDir);
            }
            if (scc.getCurrentAppVerDir() != scc.getNewAppVerFromPatchDir()) {
                this.copyFilesCurrentAppToNewAppVer(currentAppVerDir, newAppVerFromPatchDir, scc);
                OLogger.printlnOnLog(MessageFormat.format("copied {0} to {1}", currentAppVerDir.toAbsolutePath().toString(), newAppVerFromPatchDir.toAbsolutePath().toString()));
            }
            this.listFiles(currentAppVerDir, files);
            this.sccs.add(scc);
        }
        CustomizedActionResults actionResults = new CustomizedActionResults(files, new ArrayList<String>());
        return actionResults;
    }

    private void listFiles(Path dir, List<String> files) {
        if (dir == null) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path fileEntry : stream) {
                if (Files.isDirectory(fileEntry, new LinkOption[0])) {
                    this.listFiles(fileEntry, files);
                    continue;
                }
                files.add(fileEntry.toAbsolutePath().toString());
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    private Path getOldAppVerDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getOldAppVerDir::get the old application version directory");
        Path priorAppPtrFile = this.getPriorAppPtrFile(this.oracleHomePath, appDir);
        if (priorAppPtrFile != null) {
            String priorAppPtrFileName = this.getPriorAppPtrFile(this.oracleHomePath, appDir).getFileName().toString();
            String oldAppVerDirName = priorAppPtrFileName.substring("prior-ptr-".length());
            String oldAppVerDir = this.oracleHomePath + File.separator + appDir + File.separator + oldAppVerDirName;
            return WrapperFactory.getNioServiceWrapper().getPath(oldAppVerDir, new String[0]);
        }
        return null;
    }

    private Path getCurrentAppVerDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getCurrentAppVerDir::get the current application version directory");
        Path latestAppPtrFile = this.getLatestAppPtrFile(this.oracleHomePath, appDir);
        if (latestAppPtrFile != null) {
            String latestAppPtrFileName = latestAppPtrFile.getFileName().toString();
            String currentAppVerDirName = latestAppPtrFileName.substring("latest-ptr-".length());
            String currentAppVerDir = this.oracleHomePath + File.separator + appDir + File.separator + currentAppVerDirName;
            return WrapperFactory.getNioServiceWrapper().getPath(currentAppVerDir, new String[0]);
        }
        return null;
    }

    private Path getNewAppVerFromPatchDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getNewAppVerFromPatchDir::get the new application version directory");
        String newAppDir = this.oracleHomePath + File.separator + appDir + File.separator + this.pObject.getApplicationVersion();
        return WrapperFactory.getNioServiceWrapper().getPath(newAppDir, new String[0]);
    }

    private Path getPriorAppPtrFile(String oracleHomePath, String appDir) {
        OLogger.justlog(OLogger.INFO, "getPriorAppPtrFile::get the prior application pointer file");
        String priorAppPtrFileStartString = "prior-ptr-";
        return OPatchEnv.getLatestFileWtihStartString(oracleHomePath, appDir, priorAppPtrFileStartString);
    }

    private Path getLatestAppPtrFile(String oracleHomePath, String appDir) {
        OLogger.justlog(OLogger.INFO, "getLatestAppPtrFile::get the latest application pointer file");
        String latestAppPtrFileStartString = "latest-ptr-";
        return OPatchEnv.getLatestFileWtihStartString(oracleHomePath, appDir, latestAppPtrFileStartString);
    }

    private void copyFilesCurrentAppToNewAppVer(Path currentAppVerDir, Path newAppVerDir, SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "copyFilesCurrentAppToNewAppVer::copy files from the current application version directory to the new application version directory");
        try {
            SystemCall.copyRecurse(currentAppVerDir, newAppVerDir, true);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(MessageFormat.format("OPatch failed to copy files from {0} to {1}", scc.getCurrentAppVerDir().toAbsolutePath().toString(), scc.getNewAppVerFromPatchDir().toAbsolutePath().toString()));
            throw re;
        }
    }

    private boolean checkFirstAppVerDirExist(String appDir) {
        boolean isSparseCopyType;
        boolean bl = isSparseCopyType = this.pObject.getApplicationDirs().size() > 0;
        if (isSparseCopyType) {
            OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PatchObject::checkFirstAppVerDirExist()");
            Path appFile = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome() + File.separator + appDir, new String[0]);
            OLogger.printlnOnLog("The application location is " + appFile.toAbsolutePath().toString());
            if (Files.exists(appFile, new LinkOption[0])) {
                Path latestPointerFile = OPatchEnv.getLatestFileWtihStartString(OPatchEnv.getOracleHome(), appDir, "latest-ptr-");
                if (latestPointerFile == null || !Files.exists(latestPointerFile, new LinkOption[0])) {
                    OLogger.printlnOnLog("The latest pointer file doesn't exists.");
                    return false;
                }
                OLogger.printlnOnLog("The latest pointer file is in " + latestPointerFile.toAbsolutePath().toString());
                String fileName = latestPointerFile.getFileName().toString();
                String firstAppVerDirName = fileName.substring("latest-ptr-".length());
                Path firstAppVerFile = WrapperFactory.getNioServiceWrapper().getPath(appFile.toAbsolutePath().toString() + File.separator + firstAppVerDirName, new String[0]);
                OLogger.printlnOnLog("The location of the first version directory is " + firstAppVerFile.toAbsolutePath().toString());
                if (Files.exists(firstAppVerFile, new LinkOption[0])) {
                    OLogger.printlnOnLog("The first application version directory exists.");
                    return true;
                }
                OLogger.printlnOnLog("The first application version directory doesn't exist.");
                return false;
            }
            OLogger.printlnOnLog("The application directory doesn't exist.");
            return true;
        }
        return false;
    }
}

