/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.api.IIOCPatch;
import oracle.glcm.opatch.content.api.IOracleHome;
import oracle.glcm.opatch.content.errors.FileWriteException;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.glcm.opatch.content.sdk.OracleHomeProduct;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.ioc.IOC;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class CASFileServices {
    private String ohPath;

    public void initialize(String oh) {
        this.initialize(oh, false);
    }

    public void initialize(String oh, boolean isCasDirectlyPatching) {
        try {
            this.ohPath = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OPatchCASOracleHome coh = new OPatchCASOracleHome(this.ohPath, ".cas", customLogPath);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Loading CAS libraries");
            if (!isCasDirectlyPatching) {
                boolean isDBHome;
                boolean bl = isDBHome = IOC.INSTANCE.isInventoryConverted() ? false : OPatchEnv.isDBHome(oh);
                if (isDBHome) {
                    System.setProperty("CAS.RECORD_ROOT_OWNER", "true");
                    OLogger.justlog(OLogger.INFO, "Recording Root ownership for DB home");
                    if (OPatchEnv.isFullDBCasRepo()) {
                        CASServices.Initialize((IOracleHome)coh, (OracleHomeProduct)OracleHomeProduct.DB_FULL_CAS_REPO);
                        OLogger.justlog(OLogger.INFO, "initializing CAS File Service for DB home with Full CAS Repo option. ");
                    } else {
                        CASServices.Initialize((IOracleHome)coh, (OracleHomeProduct)OracleHomeProduct.DB);
                        OLogger.justlog(OLogger.INFO, "initializing CAS File Service for DB home.");
                    }
                } else {
                    CASServices.Initialize((IOracleHome)coh);
                }
            } else {
                CASServices.Initialize((IOracleHome)coh);
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS library loaded");
        }
        catch (Throwable t) {
            OLogger.println("Failed to initialize OPatch/CAS (.cas). OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void cleanup() {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - data store cleanup started");
            CASServices.Cleanup();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - data store cleanup completed");
        }
        catch (Throwable t) {
            OLogger.println("Failed to clean up CAS store. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() throws Throwable {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.INITIALIZE_CAS);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Initializing CAS and building data store");
            casFileServices.buildCasStore(false);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Initialized CAS and building data store completed");
        }
        catch (Throwable t) {
            if (t instanceof FileWriteException) {
                OLogger.println("OPatch init/build CAS store failed. OPatch cannot proceed.\n");
                OLogger.printStackTrace(t);
                RuntimeException re = new RuntimeException(t.getMessage());
                throw re;
            }
            OLogger.printlnOnLog("buildCasStore error: " + t.getMessage());
            OLogger.printStackTrace(t);
        }
        finally {
            trackerObj.end();
        }
    }

    public void create(String shadowDir, Map<Path, String> copy, Map<Path, String> hardlink) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_CREATING_SHADOW_BRANCH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            String tagKey = null;
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - creating shadow branch");
            casFileServices.createShadowOH(shadowDir, branchKey, tagKey, copy, null, hardlink);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - created shadow branch");
        }
        catch (Throwable t) {
            OLogger.println("Failed to create the Shadow Home (" + shadowDir + "). OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void destroy() {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_DESTROYING_SHADOW_BRANCH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - destroying shadow branch");
            casFileServices.destroyShadowOH(branchKey, false);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - shadow branch destroyed");
        }
        catch (Throwable t) {
            OLogger.println("Failed to destroy shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void begin(OPatchPatchKey opKey) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_APPLYING_PATCH_TO_SH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            ICASFileServices.PatchKey patchKey = opKey.getCASKey();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting patch transaction and applying patch to shadow home");
            casFileServices.beginPatchBranch(branchKey, patchKey);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed patch transaction and applied patch to shadow home");
        }
        catch (Throwable t) {
            OLogger.println("Failed to begin the patch transaction to shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void updateIOCMemento(OPatchPatchKey opKey, List<IIOCPatch> patches, Set<String> activePatches, Map<String, String> fileVersionMap) {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            ICASFileServices.PatchKey patchKey = opKey.getCASKey();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - updating IOC memento key in patch memento");
            casFileServices.updateIOCMemento(patchKey, patches, activePatches, fileVersionMap);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - IOC memento key updated in patch memento");
        }
        catch (Throwable t) {
            OLogger.println("Failed to update IOC memento key in patch memento. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void end(OPatchPatchKey opKey, Map<Path, String> remove, boolean endSession) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_COMMITTING_PATCH_TO_SH);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            ICASFileServices.PatchKey patchKey = opKey.getCASKey();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - committing patch to shadow home and ending transaction");
            casFileServices.endPatchBranch(patchKey, remove, endSession, OPatchEnv.isPrePostMakePresent());
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - committed patch to shadow home and ending transaction");
        }
        catch (Throwable t) {
            OLogger.println("Failed to end the patch transaction to shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void copyOh(Map<Path, String> ignore) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_HARDLINK_TO_COPY);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - changing oracle home files from hard link to a real copy");
            casFileServices.copyHardLinkOH(null, null, ignore);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - changed oracle home files from hard link to a real copy");
        }
        catch (Throwable t) {
            OLogger.println("Failed to copy hardlink in Oracle home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void cleaupShadowOH(String branchKey) {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Cleanup shadow home started.");
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.cleanupShadowOH(branchKey);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Cleanup shadow home Finished.");
        }
        catch (Throwable t) {
            OLogger.println("Failed to cleanup shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void normalizeOH(boolean copyOH, Long markedTimestampForRescan) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_NORMALIZE_OH);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            Collection newFiles = new ArrayList();
            if (copyOH) {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - started checking new files in oracle home");
                newFiles = casFileServices.checkNewFiles(null, markedTimestampForRescan);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed checking new files in oracle home");
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - started normalizing oracle home");
            casFileServices.normalizeOH(newFiles, null);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed normalization of oracle home");
        }
        catch (Throwable t) {
            OLogger.println("Failed to normalize the Oracle home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void commit(OPatchPatchKey opKey, Map<Path, String> ignore) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_COMMIT);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            String branchKey = OPatchEnv.getBranchKey();
            ICASFileServices.CasApiOpts opts = casFileServices.getCasApiOpts().setSyncDeltaOnly();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - started committing changes from shadow oh to real oh");
            if (opKey == null) {
                casFileServices.pushFromBranch(branchKey, null, ignore, opts);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed committing all patches from shadow oh to real oh");
                return;
            }
            ICASFileServices.PatchKey key = opKey.getCASKey();
            casFileServices.pushFromBranch(branchKey, key, ignore, opts);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed committing patch from shadow oh to real oh");
        }
        catch (Throwable t) {
            OLogger.println("Failed to commit changes from shadow home to Oracle home.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void verify(String branchKey) {
        try {
            Object latestKey = null;
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - verifying branch");
            casFileServices.verifyCasBranch(branchKey);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - verified branch");
        }
        catch (Throwable t) {
            OLogger.println("Failed to verify CAS branch key: " + branchKey + ". OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void synch(Map<Path, String> ignore) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_SYNC_TO_MASTER_BRANCH);
        trackerObj.start();
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - synching latest changes to master branch");
            casFileServices.syncLatestToMaster(ignore);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - synched latest changes to master branch");
        }
        catch (Throwable t) {
            OLogger.println("Failed to synch up master branch to the latest CAS record. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public boolean isCasReposPresent() {
        boolean result = false;
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - verifying if cas store exists");
            result = casFileServices.isCasReposPresent();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - verified cas store");
        }
        catch (Throwable t) {
            OLogger.println("Failed to verify cas store. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        return result;
    }

    public void attach() {
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to attach cas store");
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.attachCasStore();
        }
        catch (Throwable t) {
            OLogger.println("Failed to attach cas store. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Completed attach cas store");
    }

    public void detach() {
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to detach cas store");
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            casFileServices.detachCasStore();
        }
        catch (Throwable t) {
            OLogger.println("Failed to detach cas store. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Completed detach cas store");
    }

    public void rescan(OPatchPatchKey opKey) {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to rescan master branch and build memento");
            casFileServices.rescanBuildMemento(opKey.getCASKey());
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed rescan master branch and build memento");
        }
        catch (Throwable t) {
            OLogger.println("Failed to rescan the Oracle home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void getWarnings() {
        Set warnings = CASServices.getCASWarnings();
        if (warnings != null && warnings.size() > 0) {
            int i2 = 0;
            OLogger.println("\nThere are " + warnings.size() + " warning(s):");
            for (String warning : warnings) {
                OLogger.println(++i2 + "/ " + warning);
            }
            OLogger.println("");
        }
    }

    public void savePatchInfo(String memento, List<String> patchKeys) {
        try {
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to save memento and user defined patchkeys");
            casFileServices.saveUserDefinedPatchInfo(memento, patchKeys);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed save memento and user defined patchkeys");
        }
        catch (Throwable t) {
            OLogger.println("Failed to save user defined patchkeys.\n");
            OLogger.printStackTrace(t);
        }
    }

    public List<String> getPatchInfo(String memento) {
        try {
            ArrayList<String> patchInfo = new ArrayList();
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to get user defined patchkeys by memento");
            patchInfo = casFileServices.getUserDefinedPatchInfo(null, memento);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed get user defined patchkeys by memento");
            return patchInfo;
        }
        catch (Throwable t) {
            OLogger.println("Failed to get user defined patchkeys.\n");
            OLogger.printStackTrace(t);
            return null;
        }
    }

    public List<String> getBlacklistFiles() {
        try {
            ArrayList<String> blFiles = new ArrayList();
            ICASFileServices casFileServices = CASServices.getFileServices();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - starting to get files in blacklist");
            blFiles = casFileServices.getBlackList();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - completed get files in blacklist");
            return blFiles;
        }
        catch (Throwable t) {
            OLogger.println("Failed to get blacklist files.\n");
            OLogger.printStackTrace(t);
            return null;
        }
    }
}

