/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.SetResolution;
import oracle.opatch.opatchlogger.OLogger;

public class AggregationConflictResolution
implements IStep {
    @Override
    public void process(IConflictMap map, INPatchPlan plan) {
        OLogger.debug("Resolve conflict...");
        Collection conflictPohs = this.getConflictPatchesInOh(map);
        SetResolution setRes = SetResolution.getInstance();
        Collection allBugsInPi = this.getBigPiBugs(map, plan);
        boolean canAutoRollback = true;
        for (IPatch conflictPoh : conflictPohs) {
            if (conflictPoh.isComposite()) {
                canAutoRollback = false;
                break;
            }
            if (allBugsInPi.containsAll(conflictPoh.getBugs())) continue;
            canAutoRollback = false;
            break;
        }
        if (canAutoRollback) {
            for (IPatch conflictPoh : conflictPohs) {
                setRes.mark(conflictPoh, null);
                conflictPoh.setSubSetOfBigPi(true);
            }
        }
        setRes.resolve(map, plan);
    }

    private Collection getConflictPatchesInOh(IConflictMap map) {
        ArrayList<IPatch> conflictPohs = new ArrayList<IPatch>();
        Collection<IPatch> pohs = map.getPoh();
        for (IPatch poh : pohs) {
            NPatchRelations relations;
            if (poh.isComposite() || (relations = map.getRelations(poh)).getWholeConflicts().isEmpty()) continue;
            conflictPohs.add(poh);
            Collection<String> overlayIDs = poh.getBeingOverlaysID();
            for (String overlayID : overlayIDs) {
                Collection overlayPatches = map.getPatches(overlayID);
                for (IPatch overlayPatch : overlayPatches) {
                    if (!overlayPatch.isInOh()) continue;
                    conflictPohs.add(overlayPatch);
                }
            }
        }
        return conflictPohs;
    }

    private Collection getBigPiBugs(IConflictMap map, INPatchPlan plan) {
        Collection<IPatch> patches = map.getPi();
        ArrayList<String> bugs = new ArrayList<String>();
        for (IPatch patch : patches) {
            if (plan.getNotNeededPatches().contains(patch)) continue;
            if (patch.isComposite()) {
                for (IPatch subpatch : patch.getSubPatches()) {
                    bugs.addAll(subpatch.getBugs());
                }
            }
            bugs.addAll(patch.getBugs());
        }
        return bugs;
    }
}

