/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.OPatchValidationException;

public class SubsetOverlaySupersetException
extends OPatchValidationException {
    private IPatch subsetPatch = null;
    private IPatch supersetPatch = null;

    public SubsetOverlaySupersetException(IPatch subsetPatch, IPatch supersetPatch) {
        super(OPatchValidationException.ExceptionCode.SUBSET_OVERLAY_SUPERSET);
        this.subsetPatch = subsetPatch;
        this.supersetPatch = supersetPatch;
    }

    @Override
    public String getMessage() {
        if (this.subsetPatch == null || this.supersetPatch == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("Please rebuild patch ");
        buff.append(this.subsetPatch.getPatchId());
        buff.append(".\nSubset patch ");
        buff.append(this.subsetPatch.getPatchId());
        buff.append(" can't overlay superset patch ");
        buff.append(this.supersetPatch.getPatchId());
        buff.append(".");
        return buff.toString();
    }
}

