/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.cbcc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.opatch.PatchObject;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccResult;
import oracle.opatch.opatchlogger.OLogger;

public class CbccResultImpl
implements CbccResult {
    private Map<String, HashSet<PatchObject>> solvedFileMap = new HashMap<String, HashSet<PatchObject>>();

    @Override
    public Set<PatchObject> getCbccResolvedPatch(String filename) throws CbccException {
        String filename_real = this.convertFileFromShadowToReal(filename);
        if (this.hasResolvedSameFile(filename_real)) {
            return this.solvedFileMap.get(filename_real);
        }
        return null;
    }

    @Override
    public boolean hasResolvedSameFile(String filename) throws CbccException {
        String filename_real = this.convertFileFromShadowToReal(filename);
        return this.solvedFileMap.containsKey(filename_real);
    }

    @Override
    public void add(PatchObject p2, String filename) {
        if (this.solvedFileMap.containsKey(filename)) {
            this.update(p2, filename);
            return;
        }
        HashSet<PatchObject> patchObjects = new HashSet<PatchObject>();
        patchObjects.add(p2);
        this.solvedFileMap.put(filename, patchObjects);
    }

    @Override
    public Object[] getResolvedBackupForRollbackPaths(String filename, String selfPatchId) {
        OLogger.justlog(OLogger.INFO, "getResolvedBackupForRollbackPaths - file: " + filename);
        Object[] result = new Object[2];
        try {
            Set<PatchObject> pObjs = this.getCbccResolvedPatch(filename);
            for (PatchObject pObj : pObjs) {
                Path psBackupPath;
                if (pObj.getPatchID().compareTo(selfPatchId) == 0 || !Files.exists(psBackupPath = Paths.get(pObj.getRollbackFilesDirectoryPath(), new String[0]), new LinkOption[0]) || !Files.isDirectory(psBackupPath, new LinkOption[0])) continue;
                OLogger.justlog(OLogger.INFO, "Found backupForRollback location: " + psBackupPath.toString() + ") from patch(" + pObj.getPatchID() + ")");
                result[0] = psBackupPath.toString();
                result[1] = pObj;
                return result;
            }
        }
        catch (CbccException e2) {
            return null;
        }
        return null;
    }

    public String toString() {
        Set<Map.Entry<String, HashSet<PatchObject>>> entries = this.solvedFileMap.entrySet();
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, HashSet<PatchObject>> entry : entries) {
            buf.append("(common_file) " + entry.getKey() + " -> [");
            HashSet<PatchObject> patches = entry.getValue();
            for (PatchObject patch : patches) {
                buf.append(patch.getPatchID() + " ");
            }
            buf.append("]\n");
        }
        return buf.toString();
    }

    private void update(PatchObject p2, String filename) {
        HashSet<PatchObject> pObjs = this.solvedFileMap.get(filename);
        pObjs.add(p2);
    }

    private String convertFileFromShadowToReal(String s) {
        String removeCLI = s.replaceAll(".cas/CLI/", "");
        return removeCLI.replaceAll(".cas/SDK/", "");
    }
}

