/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ioc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.content.api.IIOCPatchComponent;
import oracle.opatch.OPatchEnv;
import oracle.opatch.ioc.IOCImpl;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.wrappers.WrapperFactory;

public enum IOC {
    INSTANCE;


    public void init() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        IOCImpl.INSTANCE.init();
    }

    public boolean isInitialized() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            return false;
        }
        return IOCImpl.INSTANCE.isInitialized();
    }

    public void cleanup() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        IOCImpl.INSTANCE.cleanup();
    }

    public boolean isInventoryConverted() {
        return false;
    }

    private boolean isCASDirExist() {
        Path casDir = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), ".cas");
        return Files.exists(casDir, new LinkOption[0]);
    }

    public void convertInventory() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        IOCImpl.INSTANCE.convertInventory();
    }

    public int getPlatformId() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getPlatformId();
    }

    public int getPatchingModel() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getPatchingModel();
    }

    public boolean isNextGenOH() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.isNextGenOH();
    }

    public InstalledComponent[] getAllInstalledComponents() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getAllInstalledComponents();
    }

    public Set<String> getActivePatchIds() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getActivePatchIds();
    }

    public Set<String> getAllBugIds() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getAllBugIds();
    }

    public Map<String, String> getFileVersionMap() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getFileVersionMap();
    }

    public Date getAppliedDate(String patchId) {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getAppliedDate(patchId);
    }

    public Set<IIOCPatchComponent> getPatchComponents(String patchId) {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.IOC)) {
            throw new UnsupportedOperationException("IOC is not supported");
        }
        return IOCImpl.INSTANCE.getPatchComponents(patchId);
    }
}

