/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ioc;

import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.content.api.IIOCPatch;
import oracle.glcm.opatch.content.ioc.IOCPatch;
import oracle.glcm.opatch.content.ioc.IOCPatchComponent;
import oracle.opatch.Bug;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchComponentCheckResultImpl;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.CommonAPIUtil;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.nextgen.NextGenPatching;
import oracle.sysman.nextgen.NextGenPatchingFactory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

public enum IOCHelper {
    INSTANCE;

    private static Map<PatchObject, PatchCheckResults> applyPatchCheckResultsMap;
    private static Map<PatchObject, PatchCheckResults> rollbackPatchCheckResultsMap;
    private static Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> applyAnalyzedPatches;
    private static Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> rollbackAnalyzedPatches;

    public Map<PatchComponent, PatchComponentCheckResult> analyzePatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> result;
        Map<PatchComponent, PatchComponentCheckResult> map = result = rollback ? rollbackAnalyzedPatches.get(patchObject) : applyAnalyzedPatches.get(patchObject);
        if (result != null) {
            return result;
        }
        result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (OPatchEnv.isNextGenUpgradePatchingSupported()) {
            PatchCheckResults pcr = this.getPatchCheckResults(patchObject, rollback);
            Map ccr = pcr.getComponentCheckResults();
            ArrayList<PatchComponent> ngProcessComps = new ArrayList<PatchComponent>();
            HashMap<String, ArrayList<PatchComponent>> lookupMap = new HashMap<String, ArrayList<PatchComponent>>();
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                ArrayList<PatchComponent> pcs = (ArrayList<PatchComponent>)lookupMap.get(pc.getName() + "_" + pc.getVersion());
                if (pcs == null) {
                    pcs = new ArrayList<PatchComponent>();
                    pcs.add(pc);
                    lookupMap.put(pc.getName() + "_" + pc.getVersion(), pcs);
                    continue;
                }
                pcs.add(pc);
            }
            for (Map.Entry entry : ccr.entrySet()) {
                PatchInventory.Component comp = (PatchInventory.Component)entry.getKey();
                List pcs = (List)lookupMap.get(comp.getName() + "_" + comp.getVersion());
                ComponentCheckResult cResult = (ComponentCheckResult)entry.getValue();
                if (pcs == null) continue;
                if (cResult.getResult().isProcessComponent()) {
                    ngProcessComps.addAll(pcs);
                    continue;
                }
                for (PatchComponent pc : pcs) {
                    result.put(pc, this.toPatchComponentCheckResult(cResult, pc));
                }
            }
            Map<PatchComponent, PatchComponentCheckResult> furtherProcessedComps = this.getPatchComponentCheckResults(ngProcessComps);
            result.putAll(furtherProcessedComps);
        } else {
            PatchComponent[] pcs = patchObject.getPatchComponents();
            if (pcs != null) {
                List<PatchComponent> pcsAsList = Arrays.asList(pcs);
                result = this.getPatchComponentCheckResults(pcsAsList);
            }
        }
        if (rollback) {
            rollbackAnalyzedPatches.put(patchObject, result);
        } else {
            applyAnalyzedPatches.put(patchObject, result);
        }
        return result;
    }

    public Map<PatchComponent, PatchComponentCheckResult> analyzeRequiredPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (!entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<PatchComponent, PatchComponentCheckResult> analyzeOptionalPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public PatchCheckResults getPatchCheckResults(PatchObject patchObject, boolean rollback) throws RuntimeException {
        if (OPatchEnv.isNextGenUpgradePatchingSupported()) {
            PatchCheckResults result = null;
            PatchCheckResults patchCheckResults = result = rollback ? rollbackPatchCheckResultsMap.get(patchObject) : applyPatchCheckResultsMap.get(patchObject);
            if (result != null) {
                return result;
            }
            try {
                NextGenPatching ngp = NextGenPatchingFactory.getNextGenPatching((File)WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome(), new String[0]).toFile());
                result = ngp.getPatchCheckResults(CommonAPIUtil.getInstance().getCommonAPIPatch(patchObject), rollback);
                for (ComponentCheckResult comp : result.getComponentCheckResults().values()) {
                    if (!comp.getResult().isNotEvaluated()) continue;
                    throw new RuntimeException("NextGen couldn't evaluate patch component check");
                }
                if (rollback) {
                    rollbackPatchCheckResultsMap.put(patchObject, result);
                } else {
                    applyPatchCheckResultsMap.put(patchObject, result);
                }
                return result;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    private PatchComponentCheckResult toPatchComponentCheckResult(ComponentCheckResult cResult, PatchComponent pc) {
        PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
        pcResult.setResult(cResult.getResult());
        if (pcResult.getResult().isNotEvaluated()) {
            pcResult.setDetails(OLogger.getString("OUI-67401", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isErrNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isIgnoreNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessComponent()) {
            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessingNotRequired()) {
            pcResult.setDetails(OLogger.getString("OUI-67406", new Object[]{pc.getID(), pc.getVersion()}));
        } else {
            pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), pc.getVersion()}));
        }
        return pcResult;
    }

    private Map<PatchComponent, PatchComponentCheckResult> getPatchComponentCheckResults(List<PatchComponent> patchComponents) {
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (patchComponents == null || patchComponents.size() == 0) {
            return result;
        }
        InstalledComponent[] allComponents = IOC.INSTANCE.getAllInstalledComponents();
        for (PatchComponent pc : patchComponents) {
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
            if (compName.equals("oracle.nextgen.metadata")) {
                pcResult.setResult(Result.PROCESS_COMPONENT);
                pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                result.put(pc, pcResult);
                continue;
            }
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            if (allComponents.length == 0) {
                throw new RuntimeException("Home has no inventory");
            }
            ArrayList<InstalledComponent> filtered = new ArrayList<InstalledComponent>();
            for (InstalledComponent ic : allComponents) {
                if (!compName.equals(ic.getID())) continue;
                filtered.add(ic);
            }
            if (filtered.size() == 0) {
                if (pc.isRequired()) {
                    pcResult.setResult(Result.ERR_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                } else {
                    pcResult.setResult(Result.IGNORE_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                }
                result.put(pc, pcResult);
                continue;
            }
            for (int j2 = 0; j2 < filtered.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiCompInstallID id = null;
                InstalledComponent cie = (InstalledComponent)filtered.get(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        comVersion = id.getVersion();
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            boolean installedIDEqualOrLater;
                            boolean bl = installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || comVersion.laterThan(oVersion))) {
                                oVersion = comVersion;
                            }
                        }
                    }
                }
                id.setVersion(comVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    boolean isSnowBall;
                    Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
                    boolean bl = isSnowBall = PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2;
                    if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                        if (oLang.containsAll(patchLangs)) {
                            pcResult.setResult(Result.PROCESS_COMPONENT);
                            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                            result.put(pc, pcResult);
                            continue;
                        }
                        if (required) {
                            pcResult.setResult(Result.ERR_NOT_FOUND);
                            pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                        } else {
                            pcResult.setResult(Result.IGNORE_NOT_FOUND);
                            pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                        }
                        pcResult.setDetails("");
                        result.put(pc, pcResult);
                        continue;
                    }
                    if (pc.hasSymbol()) {
                        boolean symbolExists = false;
                        Set<String> productDirectories = this.getProductDirectories(pc.getSymbolName());
                        if (productDirectories != null && !productDirectories.isEmpty()) {
                            symbolExists = true;
                        }
                        if (!symbolExists) {
                            if (required) {
                                pcResult.setResult(Result.ERR_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                            } else {
                                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                            }
                            pcResult.setDetails("");
                            result.put(pc, pcResult);
                            continue;
                        }
                        if (pc.getProductDirectories(OPatchEnv.getOracleHome()) == null || pc.getProductDirectories(OPatchEnv.getOracleHome()).length == 0) {
                            if (required) {
                                pcResult.setResult(Result.ERR_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                            } else {
                                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                            }
                            pcResult.setDetails("");
                            result.put(pc, pcResult);
                            continue;
                        }
                    }
                    pcResult.setResult(Result.PROCESS_COMPONENT);
                    pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                    result.put(pc, pcResult);
                    continue;
                }
                pcResult.setResult(Result.VERSION_MISMATCH);
                pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), foundVersion, searchVersion}));
                result.put(pc, pcResult);
                continue;
            }
            if (required) {
                pcResult.setResult(Result.ERR_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
            } else {
                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
            }
            result.put(pc, pcResult);
        }
        return result;
    }

    private Set<String> getProductDirectories(String symbol) throws RuntimeException {
        Collection distributions;
        StringBuffer buff = new StringBuffer("IPMReadServices::getProductDirectories()");
        HashSet<String> productDirectories = new HashSet<String>();
        OracleHomeInventory gdrInv = null;
        try {
            gdrInv = NGOUIInventoryFactory.getOracleHomeInventory(OPatchEnv.getOracleHome());
        }
        catch (Exception e2) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() can't get the GDR inventory.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e2);
        }
        try {
            distributions = gdrInv.getInstalledDistributions();
        }
        catch (Exception e3) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get installed distributions.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e3);
        }
        for (Distribution distribution : distributions) {
            List mappings;
            DirectoryMap directoryMap = distribution.getDirectoryMap();
            try {
                mappings = directoryMap.getMappings(new String[]{symbol});
            }
            catch (Exception e4) {
                buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get symbol mappings.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString(), e4);
            }
            if (mappings == null || mappings.isEmpty()) continue;
            for (Mapping mapping : mappings) {
                productDirectories.add(mapping.getDirectory());
            }
        }
        return productDirectories;
    }

    public static List<IIOCPatch> convertPatchObjectToIOCPatch(PatchObject[] patchObjectList) {
        ArrayList<IIOCPatch> iocPatchList = new ArrayList<IIOCPatch>();
        for (PatchObject patchObject : patchObjectList) {
            Bug[] bugs = patchObject.getBugsToFix();
            HashSet<String> bugIdFixedSet = new HashSet<String>();
            if (bugs != null) {
                for (Bug bug : bugs) {
                    bugIdFixedSet.add(bug.getBugID());
                }
            }
            HashSet<IOCPatchComponent> iocPatchComponentSet = new HashSet<IOCPatchComponent>();
            PatchComponent[] patchComponents = patchObject.getPatchComponents();
            if (patchComponents != null) {
                for (PatchComponent patchComp : patchComponents) {
                    IOCPatchComponent iocPatchComp = new IOCPatchComponent.Builder(patchComp.getName(), patchComp.getVersion()).build();
                    iocPatchComponentSet.add(iocPatchComp);
                }
            }
            String invokedTS = OPatchEnv.getInvokeTimeStamp();
            IOCPatch iocPatch = new IOCPatch.Builder(patchObject.getPatchID(), patchObject.getPatchInventory().getPatchDescription(), bugIdFixedSet, invokedTS).setComponents(iocPatchComponentSet).build();
            iocPatchList.add((IIOCPatch)iocPatch);
        }
        return iocPatchList;
    }

    static {
        applyPatchCheckResultsMap = new HashMap<PatchObject, PatchCheckResults>();
        rollbackPatchCheckResultsMap = new HashMap<PatchObject, PatchCheckResults>();
        applyAnalyzedPatches = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();
        rollbackAnalyzedPatches = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();
    }
}

