/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ioc;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.glcm.opatch.content.api.IIOCInventory;
import oracle.glcm.opatch.content.api.IIOCMgmt;
import oracle.glcm.opatch.content.api.IIOCOHComponent;
import oracle.glcm.opatch.content.api.IIOCPatchComponent;
import oracle.glcm.opatch.content.api.IOracleHome;
import oracle.glcm.opatch.content.ioc.IOCInventory;
import oracle.glcm.opatch.content.ioc.IOCOHComponent;
import oracle.glcm.opatch.content.ioc.IOCPatch;
import oracle.glcm.opatch.content.sdk.CasPublic;
import oracle.glcm.opatch.content.sdk.CasSDK;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchingModel;
import oracle.opatch.PrereqSession;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;

enum IOCImpl {
    INSTANCE;

    private static IIOCMgmt im;

    protected void init() throws RuntimeException {
        block10: {
            OLogger.printlnOnLog("Enter method: IOCImpl.init()");
            try {
                if (im != null) break block10;
                boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                try {
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(true);
                    }
                    String oracleHomePath = OPatchEnv.getOracleHome();
                    String ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]).toString();
                    Path customLogPath = null;
                    String customLogDir = OPatchEnv.getCustomLogDir();
                    if (customLogDir != null && !customLogDir.equals("")) {
                        customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
                    }
                    OPatchCASOracleHome coh = new OPatchCASOracleHome(ohPath, ".cas", customLogPath);
                    im = CasPublic.newIOCMgmt((IOracleHome)coh);
                }
                catch (Exception e2) {
                    throw e2;
                }
                finally {
                    if (!isConsoleOutputDisabled) {
                        OLogger.enableConsoleOutput();
                    }
                }
            }
            catch (Exception e3) {
                RuntimeException re = new RuntimeException(e3);
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
    }

    protected void cleanup() throws RuntimeException {
        OLogger.printlnOnLog("Enter method: IOCImpl.cleanup()");
        if (im != null) {
            try {
                ((CasSDK)im).cleanup();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            finally {
                im = null;
            }
        }
    }

    protected boolean isInitialized() {
        return im != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getPlatformId() throws RuntimeException {
        Integer platformID = OPatchEnv.getPlatformID();
        if (platformID != null) {
            return platformID;
        }
        OLogger.justlog(OLogger.INFO, "get aru id from cas");
        String propertyName = "aru id";
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            int id = im.getPlatformId();
            OPatchEnv.setPlatformID(id);
            OLogger.justlog(OLogger.INFO, String.format("%s: %s", propertyName, id));
            int n2 = id;
            return n2;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getPatchingModel() throws RuntimeException {
        Integer model = OPatchEnv.getPatchingModel();
        if (model != null) {
            return model;
        }
        OLogger.justlog(OLogger.INFO, "get patching model from cas");
        String propertyName = "patching model";
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            int patchingModel = im.getHomePatchingModel();
            OPatchEnv.setPatchingModel(patchingModel);
            OLogger.justlog(OLogger.INFO, String.format("%s: %s", propertyName, Integer.toString(patchingModel)));
            int n2 = patchingModel;
            return n2;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isNextGenOH() throws RuntimeException {
        OLogger.justlog(OLogger.INFO, "Check if it's a next-gen oh from cas");
        String propertyName = "isNextGenOH";
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            boolean isNextGenOH = im.isNextGenOH();
            OLogger.justlog(OLogger.INFO, String.format("%s: %s", propertyName, Boolean.toString(isNextGenOH)));
            System.setProperty("isNextGen", Boolean.toString(isNextGenOH));
            boolean bl = isNextGenOH;
            return bl;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InstalledComponent[] getAllInstalledComponents() throws RuntimeException {
        OLogger.justlog(OLogger.INFO, "get all installed components from cas");
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            OLogger.justlog(OLogger.INFO, "get all oh components from cas");
            Map components = im.getOHComponentsMap();
            if (components == null) throw new RuntimeException("Components have not been stored in CAS");
            if (components.size() == 0) {
                throw new RuntimeException("Components have not been stored in CAS");
            }
            InstalledComponent[] installedComponents = this.toInstalledComponents(components.values());
            OLogger.justlog(OLogger.INFO, "components from cas: " + components);
            InstalledComponent[] installedComponentArray = installedComponents;
            return installedComponentArray;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void convertInventory() throws RuntimeException {
        OLogger.justlog(OLogger.INFO, "store all static oh properties in cas");
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(OPatchEnv.getOracleHome());
        }
        catch (Throwable t) {
            if (!isConsoleOutputDisabled) {
                OLogger.enableConsoleOutput();
            }
            RuntimeException re = new RuntimeException(t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        int aru_id = PatchObjectUtil.getARU_ID(OPatchEnv.getOracleHome(), readServices);
        OLogger.justlog(OLogger.INFO, "get aur id from oui api: " + aru_id);
        int patchingModelCode = PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
        OLogger.justlog(OLogger.INFO, "get patching model from oui api: " + patchingModelCode);
        PrereqAPI.isNextGenOracleHome(OPatchEnv.getOracleHome());
        boolean isNextGen = OPatchEnv.isNextGen();
        OLogger.justlog(OLogger.INFO, "check if next gen oh from oui api: " + isNextGen);
        InstalledComponent[] installedComponents = readServices.getInstalledComponents();
        ArrayList<IOCOHComponent> ohComponents = new ArrayList<IOCOHComponent>();
        for (InstalledComponent installedComponent : installedComponents) {
            IOCOHComponent component = new IOCOHComponent.Builder(installedComponent.getID(), installedComponent.getName(), installedComponent.getDesc(), installedComponent.getVersion(), (List)installedComponent.getLanguages(), (List)installedComponent.getCompInstallID().getPlatforms()).build();
            OLogger.justlog(OLogger.INFO, "component from oui to be stored in cas: " + component.getName());
            ohComponents.add(component);
        }
        ArrayList<IOCPatch> allPatches = new ArrayList<IOCPatch>();
        HashSet<String> activePatchIds = new HashSet<String>();
        OneOffEntry[] activePatches = readServices.getInstalledPatches();
        OneOffEntry[] inactivePatches = readServices.getInactivePatches();
        HashMap fileVersionMap = OPatchSessionHelper.getCopyFileVer(readServices);
        for (OneOffEntry oneOff : activePatches) {
            allPatches.add(new IOCPatch.Builder(oneOff.getID(), oneOff.getPatchDesc(), new HashSet<String>(Arrays.asList(oneOff.getBugIDsFixed())), this.getDateStr(oneOff.getAppliedDate())).build());
            activePatchIds.add(oneOff.getID());
        }
        for (OneOffEntry oneOff : inactivePatches) {
            allPatches.add(new IOCPatch.Builder(oneOff.getID(), oneOff.getPatchDesc(), new HashSet<String>(Arrays.asList(oneOff.getBugIDsFixed())), this.getDateStr(oneOff.getAppliedDate())).build());
        }
        IOCInventory inventory = new IOCInventory.Builder(aru_id, patchingModelCode, isNextGen, ohComponents, allPatches, activePatchIds, (Map)fileVersionMap).build();
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            OLogger.justlog(OLogger.INFO, "Convert inventory over cas");
            im.convertInventory((IIOCInventory)inventory);
            return;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    private String getDateStr(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        return dateFormat.format(date);
    }

    private InstalledComponent[] toInstalledComponents(Collection<IIOCOHComponent> collection) {
        InstalledComponent[] installedComponents = new InstalledComponent[collection.size()];
        Iterator<IIOCOHComponent> iterator = collection.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            IIOCOHComponent component = iterator.next();
            OiiiCompInstallID compInstallID = new OiiiCompInstallID(component.getId(), new OiiiVersion(component.getVersion()), new Vector(component.getPlatforms()));
            OiiiInstallCompInvEntry installCompInv = new OiiiInstallCompInvEntry(compInstallID, null, new Vector(component.getLangs()), null);
            installCompInv.setName(component.getName());
            installCompInv.setDescription(component.getDescription());
            installedComponents[i2++] = new InstalledComponent(installCompInv);
        }
        return installedComponents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isInventoryConverted() throws RuntimeException {
        Boolean isInventoryConverted = OPatchEnv.getIsInventoryConverted();
        if (isInventoryConverted != null) {
            return isInventoryConverted;
        }
        OLogger.printlnOnLog("Enter method: IOCImpl.isInventoryConverted()");
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            boolean isConverted = im.isInventoryConverted();
            OPatchEnv.setIsInventoryConverted(isConverted);
            boolean bl = isConverted;
            return bl;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getActivePatchIds() {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            Set set = im.getActivePatchIds();
            return set;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getAllBugIds() {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            Set set = im.getAllBugIds();
            return set;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getFileVersionMap() {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            Map map = im.getFileVersionMap();
            return map;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    public Date getAppliedDate(String patchId) {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            String appliedDateStr = im.getAppliedDate(patchId);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
            try {
                Date date = dateFormatter.parse(appliedDateStr);
                return date;
            }
            catch (Exception e2) {
                try {
                    RuntimeException re = new RuntimeException(e2);
                    re.setStackTrace(e2.getStackTrace());
                    throw e2;
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3);
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
            }
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<IIOCPatchComponent> getPatchComponents(String patchId) {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (!isConsoleOutputDisabled) {
            OLogger.disableConsoleOutput();
        }
        boolean isInitialized = this.isInitialized();
        try {
            if (!isInitialized) {
                this.init();
            }
            Set set = im.getPatchComponents(patchId);
            return set;
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            try {
                if (!isInitialized) {
                    this.cleanup();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput();
                }
            }
        }
    }

    static {
        im = null;
    }
}

