/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OUSession;

public class CheckDuplicate {
    private NApplyData data;

    public CheckDuplicate(NApplyData data) {
        this.data = data;
    }

    public boolean check(String oracleHomePath, NApplyData data) {
        block15: {
            StringBuffer buff = new StringBuffer();
            ArrayList identicalPatches = new ArrayList();
            OneOffEntry[] compositeSubArray = data.getCompositeSubArray();
            OneOffEntry[] patchesToApply = data.getPatchesToApply();
            try {
                if (data.isComposite()) {
                    try {
                        int k2;
                        data.setCompositeIdenticalPatches(CompositePatchObject.GetIdenticalPatch(compositeSubArray, oracleHomePath));
                        compositeSubArray = CompositePatchObject.GetNonIdenticalPatch(compositeSubArray, oracleHomePath);
                        data.setCompositeSubArray(compositeSubArray);
                        int sizeToReduce = data.getCompositeSize() - compositeSubArray.length;
                        ArrayList<OneOffEntry> newPatchesToApply = new ArrayList<OneOffEntry>();
                        for (k2 = 0; k2 < patchesToApply.length; ++k2) {
                            if (patchesToApply[k2].getIsComposite()) continue;
                            newPatchesToApply.add(patchesToApply[k2]);
                        }
                        for (k2 = 0; k2 < compositeSubArray.length; ++k2) {
                            newPatchesToApply.add(compositeSubArray[k2]);
                        }
                        patchesToApply = new OneOffEntry[newPatchesToApply.size()];
                        newPatchesToApply.toArray(patchesToApply);
                        data.setPatchesToApply(patchesToApply);
                        data.setCompositeEndIndex(data.getCompositeEndIndex() - sizeToReduce);
                        data.setCompositeSize(compositeSubArray.length);
                        PrereqResult idPatch = PrereqAPI.checkDuplicatePatch(oracleHomePath, identicalPatches, patchesToApply);
                        if (patchesToApply.length == 0) {
                            PrereqResult result = PrereqResult.getPrereqResult(PrereqResult.ExecuteStatus.FAILED, OLogger.getString("OUI-67905"));
                            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, result);
                        } else {
                            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, idPatch);
                        }
                        if (idPatch.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                            System.out.println("if failed ?!");
                            buff = new StringBuffer("Prerequisite check \"CheckForIdenticalPatchInOracleHome\" failed.");
                            buff.append(idPatch.toString());
                            OLogger.println(buff.toString());
                            throw new PrereqFailedException(idPatch.toString());
                        }
                    }
                    catch (ExitOPatchException e2) {
                        PrereqSet p1 = new PrereqSet(patchesToApply);
                        PrereqSet p2 = new PrereqSet(identicalPatches.toArray(new OneOffEntry[identicalPatches.size()]));
                        OLogger.printlnOnLog(OLogger.INFO, "Patches to apply -> " + p1.toString());
                        OLogger.printlnOnLog(OLogger.INFO, "Duplicate patches to filter -> " + p2.toString());
                        OLogger.println("\nThe following patches are duplicate and are skipped:");
                        OLogger.println(p2.toString());
                        p1 = p1.delete(p2);
                        patchesToApply = p1.getAllElements();
                        data.setPatchesToApply(patchesToApply);
                    }
                    catch (Exception e1) {
                        String errorMsg = OLogger.getString("OUI-67904");
                        OPatchStateManagerFactory.getInstance().setErrorCode(130);
                        throw new RuntimeException(errorMsg);
                    }
                    if (patchesToApply.length == 0) {
                        OLogger.println(OLogger.getString("OUI-67905"));
                        return true;
                    }
                    if (compositeSubArray.length == 0) {
                        data.setIsComposite(false);
                    }
                    break block15;
                }
                PrereqResult idPatch = PrereqAPI.checkDuplicatePatch(oracleHomePath, identicalPatches, patchesToApply);
                if (idPatch.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("Prerequisite check \"CheckForIdenticalPatchInOracleHome\" failed.");
                    buff.append(idPatch.toString());
                    OLogger.println(buff.toString());
                    throw new PrereqFailedException(idPatch.toString());
                }
            }
            catch (ExitOPatchException e3) {
                if (identicalPatches.size() == patchesToApply.length) {
                    OLogger.println(e3.getMessage());
                    return true;
                }
                PrereqSet p1 = new PrereqSet(patchesToApply);
                PrereqSet p2 = new PrereqSet(identicalPatches.toArray(new OneOffEntry[identicalPatches.size()]));
                OLogger.printlnOnLog(OLogger.INFO, "Patches to apply -> " + p1.toString());
                OLogger.printlnOnLog(OLogger.INFO, "Duplicate patches to filter -> " + p2.toString());
                OLogger.println("\nThe following patches are duplicate and are skipped:");
                OLogger.println(p2.toString());
                p1 = p1.delete(p2);
                patchesToApply = p1.getAllElements();
                data.setPatchesToApply(patchesToApply);
            }
        }
        return false;
    }
}

