/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;

public class CreateMergedPatch {
    private NApplyData data;
    private MergedPatchObject mPo;

    public CreateMergedPatch(NApplyData data) {
        this.data = data;
    }

    public void merge(String oracleHomePath, NApplyData data) {
        this.mergeAp(oracleHomePath, data);
        this.mergeRb(oracleHomePath, data);
    }

    private void mergeAp(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: create a MergedPatchObject");
        OLogger.debug(dBuff);
        ArrayList<PatchObject> patchesMerged = new ArrayList<PatchObject>();
        this.mPo = new MergedPatchObject("NApply");
        boolean applicableProductCheck = true;
        StringBuffer patchIdBuff = new StringBuffer();
        StringBuffer excepMessage = new StringBuffer();
        PatchObject[] apPatchObjects = data.getApPatchObjects();
        for (int i2 = 0; i2 < apPatchObjects.length; ++i2) {
            PatchObject po = apPatchObjects[i2];
            if (po == null) {
                StringBuffer buff = new StringBuffer("NApply: PatchObject is Null.");
                throw new RuntimeException(buff.toString());
            }
            try {
                OPatchSessionHelper.performPatchApplicableProductPrereq(oracleHomePath, po);
            }
            catch (RuntimeException e2) {
                if (applicableProductCheck) {
                    excepMessage.append(e2.getMessage().substring(0, e2.getMessage().length() - 2));
                    excepMessage.append(" ( ");
                }
                applicableProductCheck = false;
                patchIdBuff.append(po.getPatchID());
                patchIdBuff.append(" ");
                OLogger.printStackTrace(e2);
                OLogger.debug(new StringBuffer(e2.getMessage()));
                continue;
            }
            if (!applicableProductCheck) continue;
            OLogger.log(OLogger.FINE, "Create a merged patch using patch " + po.getPatchID());
            this.mPo.merge(oracleHomePath, po, true);
            patchesMerged.add(po);
        }
        data.setMpo(this.mPo);
        data.setPatchesMerged(patchesMerged);
        if (!applicableProductCheck) {
            excepMessage.append(patchIdBuff);
            excepMessage.append(" )");
            throw new RuntimeException(excepMessage.toString());
        }
    }

    private void mergeRb(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: merge auto-rollback patches to MergedPatchObject");
        OLogger.debug(dBuff);
        PatchObject[] arbPatchObjects = OPatchUtilHelper.getAutoRollbackPatchObjects(oracleHomePath);
        arbPatchObjects = OPatchSessionHelper.sortOnOverlay(arbPatchObjects, false);
        data.setArbPatchObjects(arbPatchObjects);
        OPatchSessionHelper.groupCompositeByNeighbor(arbPatchObjects);
        OUSession.addNRollbackPatchesToReport(arbPatchObjects, true);
        ArrayList patchesMerged = data.getPatchesMerged();
        try {
            OPatchUtilHelper.validateRunSqlOption(oracleHomePath, arbPatchObjects, "auto-rollback");
        }
        catch (RuntimeException e2) {
            throw new RuntimeException("NApply[auto-rollback]: " + e2.getMessage(), e2);
        }
        for (int i2 = 0; i2 < arbPatchObjects.length; ++i2) {
            PatchObject po = arbPatchObjects[i2];
            if (po == null) {
                StringBuffer buff = new StringBuffer("NApply: PatchObject is Null.");
                throw new RuntimeException(buff.toString());
            }
            OLogger.log(OLogger.FINE, "Create a merged patch using patch " + po.getPatchID());
            this.mPo.merge(oracleHomePath, po, false);
            patchesMerged.add(po);
        }
        data.setMpo(this.mPo);
        data.setPatchesMerged(patchesMerged);
    }
}

