/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.rb.RB;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.deploy.ServerConnection;
import weblogic.management.configuration.ConfigurationMBean;

final class ApplicationLifeCycle
implements Operation {
    private final boolean start;

    ApplicationLifeCycle(boolean start) {
        this.start = start;
    }

    @Override
    public void run(FMWContext c2) {
        Set<String> applications = c2.getTargets().getTargets();
        if (Logger.debug) {
            Logger.debug("Running Application Life Cycle Operation for targets " + applications.toString());
        }
        Domain d2 = c2.getDomain();
        WebLogicDeploymentManager wdm = d2.getWebLogicDeploymentManager();
        ArrayList list = null;
        ServerConnection sc = wdm.getServerConnection();
        if (Logger.debug) {
            Logger.debug("Got Server Connection.");
        }
        for (String application : applications) {
            List tmid = sc.getModules((ConfigurationMBean)d2.getAppDeploymentMBean(application));
            if (tmid != null && tmid.size() > 0) {
                if (list == null) {
                    list = new ArrayList(5);
                }
                list.addAll(tmid);
                continue;
            }
            if (!Logger.debug) continue;
            Logger.debug("No TMID found for application [" + application + "]");
        }
        if (list == null) {
            return;
        }
        if (Logger.debug) {
            Logger.debug(((Object)list).toString());
        }
        boolean completed = false;
        try {
            completed = this.start ? this.wait(wdm.start(list.toArray(new TargetModuleID[0]))) : this.wait(wdm.stop(list.toArray(new TargetModuleID[0])));
        }
        catch (Exception e2) {
            Logger.loge(e2);
            Logger.error(RB.Entry.ERROR_IN_INVOKING_APPLICATION_LIFE_CYCLE_OPERATION, new Object[0]);
        }
        if (!completed) {
            Logger.error(RB.Entry.ERROR_IN_APPLICATION_LIFE_CYCLE_OPERATION, new Object[0]);
        }
    }

    private boolean wait(ProgressObject po) {
        if (!po.getDeploymentStatus().isRunning()) {
            return po.getDeploymentStatus().isCompleted();
        }
        final class ProgressHandler
        extends Thread
        implements ProgressListener {
            boolean done = false;

            ProgressHandler() {
            }

            @Override
            public void run() {
                while (!this.done) {
                    Thread.yield();
                }
            }

            public void handleProgressEvent(ProgressEvent event) {
                DeploymentStatus ds = event.getDeploymentStatus();
                if (ds.getState() != StateType.RUNNING) {
                    this.done = true;
                    if (ds.isFailed()) {
                        Logger.loge("Application Life Cycle Failed. Error Message \n" + ds.getMessage());
                    }
                }
            }
        }
        ProgressHandler ph = new ProgressHandler();
        po.addProgressListener((ProgressListener)ph);
        ph.start();
        while (!ph.done) {
            try {
                ph.join();
            }
            catch (Exception e2) {
                Logger.loge(e2);
                if (ph.isAlive()) continue;
                break;
            }
        }
        po.removeProgressListener((ProgressListener)ph);
        return po.getDeploymentStatus().isCompleted();
    }
}

