/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

public final class SOAComposite {
    private final String name;
    private final String path;
    private final String revision;
    private final boolean designChanges;
    private final boolean resourceBundle;
    private final boolean baseCompositeDeployment;
    private String defRevBeforeDeploy = "";
    private String defRevAfterDeploy = "";
    private String defRevBeforeUndoDeploy = "";
    private String defRevAfterUndoDeploy = "";

    SOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle) {
        this.name = name;
        this.path = path;
        this.revision = revision;
        this.designChanges = designChanges;
        this.resourceBundle = resourceBundle;
        this.baseCompositeDeployment = false;
    }

    SOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle, boolean baseCompDeploy) {
        this.name = name;
        this.path = path;
        this.revision = revision;
        this.designChanges = designChanges;
        this.resourceBundle = resourceBundle;
        this.baseCompositeDeployment = baseCompDeploy;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean designChanges() {
        return this.designChanges;
    }

    public boolean resourceBundle() {
        return this.resourceBundle;
    }

    public boolean isBaseCompositeDeployment() {
        return this.baseCompositeDeployment;
    }

    public String getDefaultRevisionBeforeDeploy() {
        return this.defRevBeforeDeploy;
    }

    void setDefaultRevisionBeforeDeploy(String revision) {
        this.defRevBeforeDeploy = revision;
    }

    public String getDefaultRevisionAfterDeploy() {
        return this.defRevAfterDeploy;
    }

    void setDefaultRevisionAfterDeploy(String rev) {
        this.defRevAfterDeploy = rev;
    }

    public String getDefaultRevisionBeforeUndeploy() {
        return this.defRevBeforeUndoDeploy;
    }

    void setDefaultRevisionBeforeUndeploy(String revision) {
        this.defRevBeforeUndoDeploy = revision;
    }

    public String getDefaultRevisionAfterUndeploy() {
        return this.defRevAfterUndoDeploy;
    }

    void setDefaultRevisionAfterUndeploy(String rev) {
        this.defRevAfterUndoDeploy = rev;
    }

    public boolean equals(Object o2) {
        if (this.name == null || o2 == null || !(o2 instanceof SOAComposite)) {
            return false;
        }
        SOAComposite s = (SOAComposite)o2;
        return this.name.equals(s.name);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SOA Composite Details\n");
        sb.append("Name            [").append(this.name).append("]\n");
        sb.append("Path            [").append(this.path).append("]\n");
        sb.append("Revision        [").append(this.revision).append("]\n");
        sb.append("Design Changes  [").append(this.designChanges).append("]\n");
        sb.append("Resource Bundle [").append(this.resourceBundle).append("]\n");
        sb.append("BaseCompositeDeployment [").append(this.baseCompositeDeployment).append("]\n");
        return sb.toString();
    }
}

