/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.opatchlogger.MyConsoleHandler;
import oracle.opatch.opatchlogger.OLoggerImpl;
import oracle.opatch.wrappers.WrapperFactory;

public class OLogger {
    private static ThreadLocal threadLocal = new ThreadLocal(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OLoggerImpl initialValue() {
            OLoggerImpl impl = new OLoggerImpl();
            Class<OLogger> clazz = OLogger.class;
            synchronized (OLogger.class) {
                Integer n2 = threadCounter;
                Integer n3 = threadCounter = threadCounter + 1;
                if (firstThread == null) {
                    if (OLogger.isOPatchCmdLineMode()) {
                        firstThread = Thread.currentThread();
                    } else if (!Thread.currentThread().getName().equals("main")) {
                        firstThread = Thread.currentThread();
                    }
                }
                impl.setExtendLogID(threadCounter);
                threadMap.put(Thread.currentThread(), impl);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return impl;
            }
        }
    };
    static Thread firstThread = null;
    private static boolean isFirstThread = false;
    static HashMap threadMap = new HashMap();
    private static Integer threadCounter = 0;
    private static boolean isCmdLineMode = true;
    public static final int SEVERE = Level.SEVERE.intValue();
    public static final String SEVERE_OPTION = "Severe";
    public static final int WARNING = Level.WARNING.intValue();
    public static final String WARNING_OPTION = "Warning";
    public static final int INFO = Level.INFO.intValue();
    public static final String INFO_OPTION = "Info";
    public static final int CONFIG = Level.CONFIG.intValue();
    public static final String CONFIG_OPTION = "Config";
    public static final int FINE = Level.FINE.intValue();
    public static final String FINE_OPTION = "Fine";
    public static final int FINER = Level.FINER.intValue();
    public static final String FINER_OPTION = "Finer";
    public static final int FINEST = Level.FINEST.intValue();
    public static final String FINEST_OPTION = "Finest";
    public static final int OFF = Level.OFF.intValue();
    public static final String OFF_OPTION = "Off";
    private static boolean consoleOutputDisabled = false;

    public static synchronized void writeLog(Thread t, int level, String str) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        OLoggerImpl specfiedOLogger = (OLoggerImpl)threadMap.get(t);
        FileHandler handlerOfSpecOLogger = null;
        if (specfiedOLogger != null && (handlerOfSpecOLogger = specfiedOLogger.getCurrentFileHandler()) != null) {
            FileHandler original = currentOLoggerImpl.getCurrentFileHandler();
            currentOLoggerImpl.rmHandler(original);
            currentOLoggerImpl.addHandler(handlerOfSpecOLogger);
            OLogger.justlog(level, str);
            currentOLoggerImpl.rmHandler(handlerOfSpecOLogger);
            currentOLoggerImpl.addHandler(original);
        }
    }

    public static void logTime(StringBuffer entry) {
        String timeStamp = OLogger.getCurrentTimeString();
        entry.append(timeStamp);
        OLogger.printlnOnLog(INFO, entry.toString());
    }

    public static void verbose(Object caller, StringBuffer buff) {
        StringBuffer indent = new StringBuffer("");
        if (caller != null && !(caller instanceof OPatchSession)) {
            if (caller instanceof PatchComponent) {
                indent.append("  ");
            } else if (caller instanceof PatchAction) {
                indent.append("    ");
            }
        }
        StringBuffer output = new StringBuffer(indent.toString());
        output.append(buff.toString());
        OLogger.log(FINE, output.toString());
    }

    public static void log(int level, String str) {
        String msgStr = str;
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        if (level > WARNING) {
            String strP = str;
            int opatchExitCode = 0;
            if (str != null && str.startsWith("OUI-67") && str.length() >= 10) {
                strP = str.substring(4, 9);
                try {
                    int i2 = Integer.parseInt(strP);
                    if (i2 > 67000) {
                        opatchExitCode = i2 - 67000;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    if (OPatchACL.getStateOrder(new OLogger(), OPatchStateManagerFactory.getInstance().getCurrentState()) == 0) {
                        OPatchACL.setOpatchExitCode(new OLogger(), opatchExitCode);
                    }
                }
                catch (IllegalAccessException e2) {
                    // empty catch block
                }
            }
        }
        if (str != null && str.startsWith("OUI-67") && str.length() >= 10) {
            msgStr = str.substring(10);
        }
        if (level == SEVERE) {
            OLogger.printlnOnError(msgStr);
        } else if (level >= currentOLoggerImpl.getLogLevel()) {
            OLogger.printlnOnConsole(msgStr);
        }
        if (level >= WARNING) {
            OLogger.justlog(level, str);
        } else {
            OLogger.justlog(level, msgStr);
        }
    }

    private static String onlylogres(int level, String key) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(key));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, key): level=");
            str.append(level);
            str.append(", key=");
            str.append(key);
        }
        OLogger.justlog(level, str.toString());
        return str.toString();
    }

    private static String onlylogres(int level, String key, Object[] objs) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(key, objs));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, key, objs): level=");
            str.append(level);
            str.append(", key=");
            str.append(key);
        }
        OLogger.justlog(level, str.toString());
        return str.toString();
    }

    private static String onlylogres(int level, String sRes, String key, Object[] objs) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(sRes, key, objs));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, sRes, key, objs): level=");
            str.append(level);
            str.append(", sRes=");
            str.append(sRes);
            str.append(", key=");
            str.append(key);
        }
        OLogger.justlog(level, str.toString());
        return str.toString();
    }

    private static String onlylogres(int level, String sRes, String key) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(sRes, key));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, sRes, key): level=");
            str.append(level);
            str.append(", sRes=");
            str.append(sRes);
            str.append(", key=");
            str.append(key);
        }
        OLogger.justlog(level, str.toString());
        return str.toString();
    }

    private static Locale getSystemLocale() {
        String localeStr = System.getProperty("OPatch.LOCALE");
        if (localeStr == null || localeStr.equals("")) {
            return Locale.getDefault();
        }
        String[] strs = localeStr.split("_");
        if (strs == null || strs.length == 0) {
            return Locale.getDefault();
        }
        if (strs.length == 1) {
            return new Locale(strs[0]);
        }
        if (strs.length == 2) {
            return new Locale(strs[0], strs[1]);
        }
        if (strs.length == 3) {
            return new Locale(strs[0], strs[1], strs[2]);
        }
        return Locale.getDefault();
    }

    protected static String getString(String sRes, String key) {
        ResourceBundle rb = ResourceBundle.getBundle(sRes, OLogger.getSystemLocale());
        return rb.getString(key);
    }

    public static String getString(String key) {
        String[] defaultBundles = new String[]{"oracle.opatch.OPatchRuntimeRes", "oracle.opatch.opatchutil.OPatchUtilRuntimeRes", "oracle.opatch.opatchactions.OPatchActionsRuntimeRes", "oracle.opatch.NonTranslatedRuntimeRes", "oracle.opatch.opatchprereq.OPatchPrereqRuntimeRes"};
        for (int i2 = 0; i2 < defaultBundles.length; ++i2) {
            try {
                return OLogger.getString(defaultBundles[i2], key);
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        throw new MissingResourceException("Resource not found in default bundles", defaultBundles[0], key);
    }

    public static String getString(String key, Object[] objs) {
        return MessageFormat.format(OLogger.getString(key), objs);
    }

    protected static String getString(String sRes, String key, Object[] objs) {
        return MessageFormat.format(OLogger.getString(sRes, key), objs);
    }

    public static void printlnres(String key) {
        StringBuffer str = null;
        try {
            str = new StringBuffer(OLogger.getString(key));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, printlnres(key): key=");
            str.append(key);
        }
        OLogger.printlnOnConsole(str.toString());
        OLogger.justlog(INFO, str.toString());
    }

    public static void printlnres(String key, Object[] objs) {
        StringBuffer str = null;
        try {
            str = new StringBuffer(OLogger.getString(key, objs));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, printlnres(key, objs): key=");
            str.append(key);
        }
        OLogger.printlnOnConsole(str.toString());
        OLogger.justlog(INFO, str.toString());
    }

    public static void println(String key, Object ... objs) {
        String str = MessageFormat.format(key, objs);
        OLogger.printlnOnConsole(str);
        OLogger.justlog(INFO, str);
        str = null;
    }

    public static void log(String key, Object ... objs) {
        String str = MessageFormat.format(key, objs);
        OLogger.justlog(INFO, str);
        str = null;
    }

    public static void println(String str) {
        OLogger.printlnOnConsole(str);
        OLogger.justlog(INFO, str);
    }

    public static void println(String str, Thread t) {
        OLogger.printlnOnConsole(str);
        OLogger.writeLog(t, INFO, str);
    }

    public static void printlnOnLogAndVerbose(String s) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        if (currentOLoggerImpl.getLogLevel() <= FINE) {
            OLogger.log(FINE, s);
        } else {
            OLogger.justlog(INFO, s);
        }
    }

    public static void printlnInNonAPIMode(String s) {
        OLogger.println(s);
    }

    public static void debug(StringBuffer str) {
        OLogger.debug(str.toString());
    }

    public static void debug(String str) {
        if (OLogger.isDebug()) {
            OLogger.log(FINEST, str);
        } else {
            OLogger.justDebugLog(str);
        }
    }

    public static void print(String str) {
        OLogger.printOnConsole(str);
        OLogger.justlog(INFO, str);
    }

    public static void print(String str, Thread t) {
        OLogger.printOnConsole(str);
        OLogger.writeLog(t, INFO, str);
    }

    public static String logError(String key) {
        return OLogger.onlylogres(SEVERE, key);
    }

    public static String logError(String key, Object[] objs) {
        return OLogger.onlylogres(SEVERE, key, objs);
    }

    public static String logError(String sRes, String key, Object[] objs) {
        return OLogger.onlylogres(SEVERE, sRes, key, objs);
    }

    public static String logError(String sRes, String key) {
        return OLogger.onlylogres(SEVERE, sRes, key);
    }

    protected static String getLogFileName() {
        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
        String logFilePrefix = isObrepo ? "obrepo" : "opatch";
        StringBuffer buff = new StringBuffer(logFilePrefix);
        String ts = OLogger.getFormatTimeStamp();
        buff.append(ts + "_" + OLogger.getThreadID());
        buff.append(".log");
        OPatchEnv.setInvokeTimeStamp(ts);
        return buff.toString();
    }

    protected static String getOutputFileNameForLsInvAllNodes(String oracleHomePath, String fileName) {
        String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String completePath = "";
        boolean dirVal = false;
        Path file = WrapperFactory.getNioServiceWrapper().getPath(patchStorageLocation, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createDirectories(file, new FileAttribute[0]);
                dirVal = true;
            }
            catch (Exception e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!dirVal) {
            return completePath;
        }
        StringBuffer buff = new StringBuffer(patchStorageLocation);
        buff.append(File.separator);
        buff.append(fileName);
        completePath = buff.toString();
        return completePath;
    }

    protected static String getOutputFileNameForLsInv(String oracleHomePath, String sessionType) {
        StringBuffer file = OLogger.getOutputFileName(oracleHomePath, sessionType);
        file.append(".txt");
        return file.toString();
    }

    protected static String getOutputFileNameForLsInvXML(String oracleHomePath, String sessionType) {
        StringBuffer file = OLogger.getOutputFileName(oracleHomePath, sessionType);
        file.append(".xml");
        return file.toString();
    }

    private static StringBuffer getOutputFileName(String oracleHomePath, String sessionType) {
        String fileLocation = "";
        try {
            fileLocation = OPatchACL.getLsInvOutputFileLocation(new OLogger(), oracleHomePath);
        }
        catch (IllegalAccessException e2) {
            OLogger.printStackTrace(e2);
        }
        StringBuffer buff = new StringBuffer(fileLocation);
        String dir = buff.toString();
        Path file = WrapperFactory.getNioServiceWrapper().getPath(dir, new String[0]);
        if (!Files.exists(file, new LinkOption[0]) && !OPatchEnv.isLogDisabled()) {
            try {
                if (Files.isDirectory(Files.createDirectories(file, new FileAttribute[0]), new LinkOption[0])) {
                    OUIReplacer.changePermission(dir, 488);
                }
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
        }
        buff.append(File.separator);
        buff.append(sessionType);
        buff.append(OLogger.getFormatTimeStamp());
        return buff;
    }

    public static String getFormatTimeStamp() {
        String s = "";
        try {
            s = OLogger.getSafeFormatTimeStamp();
        }
        catch (Throwable t) {
            s = "default_log";
        }
        return s;
    }

    protected static String getOUIInstallTime() {
        try {
            String fileName = OLogger.getTimeString();
            StringTokenizer tokenizer = new StringTokenizer(fileName, " ");
            int count = tokenizer.countTokens();
            String day = tokenizer.nextToken();
            String month = tokenizer.nextToken();
            String date = tokenizer.nextToken();
            String time = tokenizer.nextToken();
            String zone = tokenizer.nextToken();
            String year = tokenizer.nextToken();
            StringBuffer buff = new StringBuffer(year);
            buff.append(".");
            buff.append(month);
            buff.append(".");
            buff.append(date);
            buff.append(" ");
            buff.append(time);
            buff.append(" ");
            buff.append(zone);
            return buff.toString();
        }
        catch (Throwable t) {
            return "";
        }
    }

    protected static String getSpecifiedLogFileLocation(String oracleHomePath, String patchIDTimeStamp, String keyword) {
        String logFileLoc = "";
        try {
            String customLogDir = OPatchEnv.getCustomLogDir();
            logFileLoc = OPatchACL.getLogFileLocation(new OLogger(), oracleHomePath);
            if (customLogDir != null && !customLogDir.equals("")) {
                logFileLoc = OPatchACL.getLogFileLocation(new OLogger(), customLogDir);
            }
        }
        catch (IllegalAccessException e2) {
            // empty catch block
        }
        StringBuffer fileNamePath = new StringBuffer(logFileLoc);
        fileNamePath.append(File.separator);
        fileNamePath.append(patchIDTimeStamp);
        fileNamePath.append(File.separator);
        Path tmpFileLoc = WrapperFactory.getNioServiceWrapper().getPath(fileNamePath.toString(), new String[0]);
        if (!Files.exists(tmpFileLoc, new LinkOption[0])) {
            try {
                Files.createDirectories(tmpFileLoc, new FileAttribute[0]);
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
        }
        fileNamePath.append(keyword);
        fileNamePath.append(OLogger.getFormatTimeStamp() + "_" + OLogger.getThreadID());
        fileNamePath.append(".log");
        return fileNamePath.toString();
    }

    public static void printStackTrace(Throwable t) {
        String msgStr = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(out);
        t.printStackTrace(pw);
        byte[] logBytes = out.toByteArray();
        msgStr = OLogger.getString("OUI-67032", new Object[]{new String(logBytes)});
        OLogger.justlog(INFO, msgStr);
        try {
            pw.close();
            out.close();
        }
        catch (IOException e2) {
            OLogger.justlog(WARNING, "Closed failed on I/O stream.");
        }
    }

    public String toString() {
        int logLevel = OLogger.getLogFileLevel();
        boolean debug = OLogger.isDebug();
        String defLogFile = OLogger.getLogFileName();
        String ct = OLogger.getCurrentTimeString();
        String ft = OLogger.getFormatTimeStamp();
        StringBuffer buff = new StringBuffer("[OLogger:  debug= ");
        buff.append(debug);
        buff.append(", logLevel= ");
        buff.append(logLevel);
        buff.append(", logFileName= ");
        buff.append(defLogFile);
        buff.append(", current time= ");
        buff.append(ct);
        buff.append(", format time= ");
        buff.append(ft);
        buff.append("]");
        return buff.toString();
    }

    public static void flushBufferToStdOutput() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        if (currentOLoggerImpl.getConsoleHandler() != null) {
            ((MyConsoleHandler)currentOLoggerImpl.getConsoleHandler()).flushToStdOutput();
        }
    }

    public static void onlyLogInfo(String key) {
        OLogger.onlylogres(INFO, key);
    }

    public static void onlyLogInfo(String key, Object[] objs) {
        OLogger.onlylogres(INFO, key, objs);
    }

    protected static boolean isFirstThread() {
        boolean isFirst1 = firstThread != null && Thread.currentThread().equals(firstThread);
        return isFirst1 || isFirstThread;
    }

    protected static void managedByParentThread(Thread main) {
        if (threadMap.get(main) != null) {
            threadLocal.set(threadMap.get(main));
            if (firstThread != null) {
                isFirstThread = firstThread.equals(main);
            }
        }
    }

    public static void setOPatchCmdLineMode(boolean in) {
        isCmdLineMode = in;
    }

    public static boolean isOPatchCmdLineMode() {
        return isCmdLineMode;
    }

    public static void printlnOnLog(String s) {
        OLogger.printlnOnLog(INFO, s);
    }

    public static boolean isDebug() {
        return OLogger.getLogLevel() <= FINEST;
    }

    protected static void setDebug(boolean debug) {
        if (debug) {
            OLogger.setLogLevel(FINEST);
            OLogger.setLogFileLevel(FINEST);
        }
    }

    public static int getThreadID() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getExtendLogID();
    }

    public static String getLogFileLocation() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getLogFileLocation();
    }

    public static String getDebugLogFileLocation() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getDebugLogFileLocation();
    }

    protected static void setEnableConsoleLater(boolean b2) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setEnableConsoleLater(b2);
    }

    protected static String getTimeString() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getTimeString();
    }

    protected static void setTimeString() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setTimeString();
    }

    protected static String getCurrentTimeString() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getCurrentTimeString();
    }

    public static boolean isConsoleOutputDisabled() {
        return consoleOutputDisabled;
    }

    public static void disableConsoleOutput() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.disableConsoleOutput(false);
        consoleOutputDisabled = true;
    }

    public static void enableConsoleOutput() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.enableConsoleOutput(false);
        consoleOutputDisabled = false;
    }

    public static void disableConsoleOutput(boolean force) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.disableConsoleOutput(force);
        consoleOutputDisabled = true;
    }

    public static void enableConsoleOutput(boolean force) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.enableConsoleOutput(force);
        consoleOutputDisabled = false;
    }

    public static void enableConsoleOutput(int level, boolean force) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.enableConsoleOutput(level, force);
        consoleOutputDisabled = false;
    }

    public static HashMap disableLogOutput() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.disableLogOutput();
    }

    public static void enableLogOutput(HashMap handlerMap) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.enableLogOutput(handlerMap);
    }

    static void printWarningList() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printWarningList();
    }

    static void printWarningListOnLog() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printWarningListOnLog();
    }

    private OLogger() {
    }

    public static void initJavaLogger(String oracleHomePath, String javaFileName, String consoleLevelStr, String fileLevelStr, boolean plainFileFormat) throws Exception {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.initJavaLogger(oracleHomePath, javaFileName, consoleLevelStr, fileLevelStr, plainFileFormat);
    }

    protected static void initJavaLogger(String oracleHomePath, String cookedPatchID, String keyword, String consoleLevelStr, String fileLevelStr, boolean printLogFile, boolean plainFileFormat) throws Exception {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.initJavaLogger(oracleHomePath, cookedPatchID, keyword, consoleLevelStr, fileLevelStr, printLogFile, plainFileFormat);
    }

    protected static void initJavaLogger(String oracleHomePath, String consoleLevelStr, String fileLevelStr) throws Exception {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.initJavaLogger(oracleHomePath, consoleLevelStr, fileLevelStr);
    }

    protected static void initJavaLoggerIfUninitialized(String oracleHomePath, String consoleLevelStr, String fileLevelStr) throws Exception {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        if (!currentOLoggerImpl.isLoggerInitialized()) {
            currentOLoggerImpl.setTimeString();
            currentOLoggerImpl.initJavaLogger(oracleHomePath, consoleLevelStr, fileLevelStr);
        }
    }

    public static void reInitJavaLogger(String logFileLocation, String consoleLevelStr, String fileLevelStr, boolean plainFileFormat) throws Exception {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.reInitJavaLogger(logFileLocation, consoleLevelStr, fileLevelStr, plainFileFormat);
    }

    protected static void initOUICheckerLogFile(String oracleHomePath) throws IOException {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.initOUICheckerLogFile(oracleHomePath);
    }

    protected static void closeDiskLogFile() {
    }

    protected static void closeLogFile() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.closeLogFile();
    }

    protected static void resetWarningList() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.resetWarningList();
    }

    public static synchronized void justlog(int level, String str) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.justlog(level, str);
    }

    public static synchronized void justDebugLog(String str) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.justDebugLog(str);
    }

    public static void printlnOnConsole(String s) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printlnOnConsole(s);
    }

    public static void printOnConsole(String s) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printOnConsole(s);
    }

    public static void printlnOnError(String s) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printlnOnError(s);
    }

    public static void printlnOnLog(int level, String s) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.printlnOnLog(level, s);
    }

    public static String error(String key) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.logres(SEVERE, key);
    }

    public static String error(String key, Object[] objs) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.logres(SEVERE, key, objs);
    }

    public static String error(String sRes, String key, Object[] objs) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.logres(SEVERE, sRes, key, objs);
    }

    public static String error(String sRes, String key) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.logres(SEVERE, sRes, key);
    }

    public static String warn(String key) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.warn(key);
    }

    public static String warn(String key, Object[] objs) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.warn(key, objs);
    }

    public static String warn(String sRes, String key, Object[] objs) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.warn(sRes, key, objs);
    }

    public static String warn(String sRes, String key) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.warn(sRes, key);
    }

    public static void info(String key) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.logres(INFO, key);
    }

    public static void info(String key, Object[] objs) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.logres(INFO, key, objs);
    }

    private static String getSafeFormatTimeStamp() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getSafeFormatTimeStamp();
    }

    protected static void setCurrentLogLevel(int currentLogLevel) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setCurrentLogLevel(currentLogLevel);
    }

    protected static int getLogLevel() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getLogLevel();
    }

    protected static void setLogLevel(int logLevel) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setLogLevel(logLevel);
    }

    protected static int getLogFileLevel() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getLogFileLevel();
    }

    protected static void setLogFileLevel(int logFileLevel) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setLogFileLevel(logFileLevel);
    }

    protected static void setLsInventoryFileHandler(FileHandler lsInvFH) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.setLsInventoryFileHandler(lsInvFH);
    }

    public static String getOutputFileNameForConfiguration(String oracleHomePath, String fileName) {
        String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String completePath = "";
        boolean dirVal = false;
        Path file = WrapperFactory.getNioServiceWrapper().getPath(patchStorageLocation, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createDirectories(file, new FileAttribute[0]);
            }
            catch (Exception e2) {
                OLogger.debug(e2.getMessage());
            }
            dirVal = true;
        }
        if (!dirVal) {
            return completePath;
        }
        StringBuffer buff = new StringBuffer(patchStorageLocation);
        buff.append(File.separator);
        buff.append(fileName);
        completePath = buff.toString();
        return completePath;
    }

    protected static int getWarningListLength() {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        return currentOLoggerImpl.getWarningListLength();
    }

    public static void main(String[] args) {
        System.out.println("OLogger::main()");
        OLogger olog = new OLogger();
        System.out.println(olog.toString());
    }

    protected static void addHandler(Handler handler) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.addHandler(handler);
    }

    protected static void rmHandler(Handler handler) {
        OLoggerImpl currentOLoggerImpl = (OLoggerImpl)threadLocal.get();
        currentOLoggerImpl.rmHandler(handler);
    }
}

