/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResource;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OPatchChecks {
    private static boolean isDebug = false;

    public static boolean inDebugMode() {
        return isDebug;
    }

    private OPatchChecks() {
    }

    private static PrereqResult mergeResultObjs(PrereqResult res1, PrereqResult res2) {
        PrereqResult tmp = new PrereqResult();
        if (res1.getResult() != PrereqResult.ExecuteStatus.PASSED || res2.getResult() != PrereqResult.ExecuteStatus.PASSED) {
            if (res1.getResult() != PrereqResult.ExecuteStatus.PASSED) {
                tmp.setResult(res1.getResult());
                tmp.setResultDetails(res1.getResultDetails());
                Vector res2Details = res2.getResultDetails();
                for (int i2 = 0; i2 < res2Details.size(); ++i2) {
                    tmp.addDetail(res2Details.elementAt(i2));
                }
            } else {
                tmp.setResult(res2.getResult());
                tmp.setResultDetails(res2.getResultDetails());
                Vector res1Details = res1.getResultDetails();
                for (int i3 = 0; i3 < res1Details.size(); ++i3) {
                    tmp.addDetail(res1Details.elementAt(i3));
                }
            }
        } else {
            tmp.setResult(PrereqResult.ExecuteStatus.PASSED);
            Vector res1Details = res1.getResultDetails();
            for (int i4 = 0; i4 < res1Details.size(); ++i4) {
                tmp.addDetail(res1Details.elementAt(i4));
            }
            Vector res2Details = res2.getResultDetails();
            for (int i5 = 0; i5 < res2Details.size(); ++i5) {
                tmp.addDetail(res2Details.elementAt(i5));
            }
        }
        return tmp;
    }

    private static OipcrIResult parsePrereqResult(PrereqResult resObj) {
        OipcrIResult oResult = null;
        OipcrIResult oRes = null;
        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
        if (resObj.getResult() == PrereqResult.ExecuteStatus.PASSED) {
            oResult = OipcrResult.PASSED_RESULT;
        } else if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            oRes = OipcrResult.FAILED_RESULT;
            Vector details = resObj.getResultDetails();
            oResDetails.add(new OipcrResultDetails((Object)details, null, oRes));
            oResult = new OipcrResult(oResDetails);
        } else {
            Vector details = resObj.getResultDetails();
            if (details != null && details.size() > 0) {
                boolean hasCause = false;
                for (int i2 = 0; i2 < details.size(); ++i2) {
                    Object obj = details.elementAt(i2);
                    if (!(obj instanceof Throwable)) continue;
                    Throwable cause = (Throwable)obj;
                    OiixException oe = new OiixException(cause);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    hasCause = true;
                    cause.printStackTrace();
                    break;
                }
                if (!hasCause) {
                    OiixException oe = new OiixException((String)details.lastElement());
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            } else {
                oResult = OipcrResult.NOT_EXECUTED_RESULT;
            }
        }
        return oResult;
    }

    private static OipcrIResult parseConflictOutput(ConflictOutput conflictObj) {
        OipcrIResult oResult = null;
        OipcrIResult oRes = null;
        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
        if (conflictObj.getResult() == PrereqResult.ExecuteStatus.PASSED) {
            oResult = OipcrResult.PASSED_RESULT;
        } else if (conflictObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            oRes = OipcrResult.FAILED_RESULT;
            Vector<String> details = new Vector<String>();
            details.add(conflictObj.toString());
            oResDetails.add(new OipcrResultDetails(details, null, oRes));
            oResult = new OipcrResult(oResDetails);
        } else {
            Vector details = conflictObj.getResultDetails();
            if (details != null && details.size() > 0) {
                boolean hasCause = false;
                for (int i2 = 0; i2 < details.size(); ++i2) {
                    Object obj = details.elementAt(i2);
                    if (!(obj instanceof Throwable)) continue;
                    Throwable cause = (Throwable)obj;
                    OiixException oe = new OiixException(cause);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    hasCause = true;
                    cause.printStackTrace();
                    break;
                }
                if (!hasCause) {
                    OiixException oe = new OiixException((String)details.lastElement());
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            } else {
                oResult = OipcrResult.NOT_EXECUTED_RESULT;
            }
        }
        return oResult;
    }

    private static void getAndSetInvPtrLoc() {
        String oraInstLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (oraInstLoc != null && !oraInstLoc.equals("")) {
            try {
                OPatchACL.setInvPtrLocSpecified(new OPatchChecks());
                OPatchACL.setInvPtrLoc(new OPatchChecks(), oraInstLoc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setOracleHome(String oracleHomePath) {
        if (oracleHomePath != null && !oracleHomePath.equals("")) {
            try {
                OPatchACL.setOracleHome(new OPatchChecks(), oracleHomePath);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static OipcrIResult checkCentralInventoryForOH(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkCentralInventoryForOH(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkCentralInventoryForRWSession(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkCentralInventoryForRWSession(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkIfOHLockedForPatching(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkIfOHLockedForPatching(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkJDK(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                try {
                    OiisVariable customJDK = oContext.getVariable("OPATCH_CUSTOM_JAVA_DIR_LOCATION");
                    String customJDKStr = (String)customJDK.getValue();
                    if (customJDKStr != null && !customJDKStr.equals("")) {
                        System.setProperty("OPatch.JDK_HOME", customJDKStr);
                    }
                }
                catch (Exception e2) {
                    System.setProperty("OPatch.JDK_HOME", "");
                }
                PrereqResult resObj = PrereqAPI.checkJDK(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkOracleHome(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkOracleHome(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkOUILocation(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                try {
                    OiisVariable customOUI = oContext.getVariable("OPATCH_CUSTOM_OUI_LOCATION");
                    String customOUIStr = (String)customOUI.getValue();
                    if (customOUIStr != null && !customOUIStr.equals("")) {
                        System.setProperty("oracle.installer.oui_loc", customOUIStr);
                        System.setProperty("OPatch.OUI_LOCATION", customOUIStr);
                    }
                }
                catch (Exception e2) {
                    System.setProperty("oracle.installer.oui_loc", oracleHomePath + File.separator + "oui");
                    System.setProperty("OPatch.OUI_LOCATION", oracleHomePath + File.separator + "oui");
                }
                PrereqResult resObj = PrereqAPI.checkOUILocation(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkOUIVersionCompatible(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkOUIVersionCompatible(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkUserAdminPrivilege(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkUserAdminPrivilege(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkRequiredLibs(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVar.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                String[] requiredLibs = PrereqResource.reqdLibs;
                try {
                    OiisVariable customOUI = oContext.getVariable("OPATCH_CUSTOM_OUI_LOCATION");
                    String customOUIStr = (String)customOUI.getValue();
                    if (customOUIStr != null && !customOUIStr.equals("")) {
                        System.setProperty("oracle.installer.oui_loc", customOUIStr);
                        System.setProperty("OPatch.OUI_LOCATION", customOUIStr);
                    }
                }
                catch (Exception e2) {
                    System.setProperty("oracle.installer.oui_loc", oracleHomePath + File.separator + "oui");
                    System.setProperty("OPatch.OUI_LOCATION", oracleHomePath + File.separator + "oui");
                }
                PrereqResult resObj = PrereqAPI.checkRequiredLibs(oracleHomePath, requiredLibs);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkOPatchMinVersionRequirement(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            PrereqResult res2 = null;
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                PatchObject pObj = PatchObject.getInstance((String)patchLocs[i4]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkPatchsetUpdateComponents(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            PrereqResult res2 = null;
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                PatchObject pObj = PatchObject.getInstance((String)patchLocs[i4]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkPatchsetUpdateCompatible(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            PrereqResult res2 = null;
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                PatchObject pObj = PatchObject.getInstance((String)patchLocs[i4]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkComponents(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block23: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        ArrayList<String> list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        PrereqResult res2 = null;
                        try {
                            PatchObject pObj = null;
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                pObj = PatchObject.getInstance((String)patchLocs[i4]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkComponents(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkComponents(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
                catch (IOException e1) {
                    OLogger.debug(e1.getMessage());
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkApplicable(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block23: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            PrereqResult res2 = null;
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkApplicable(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PrereqResult res2 = null;
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkApplicable(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        ArrayList<String> list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        try {
                            PrereqResult res2 = null;
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                Object patchLoc = patchLocs[i4];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                PatchObject[] pArr = new PatchObject[]{pObj};
                                PrereqResult resObj = PrereqAPI.checkApplicable(oracleHomePath, pArr);
                                res2 = res2 == null ? resObj : OPatchChecks.mergeResultObjs(res2, resObj);
                            }
                            oResult = OPatchChecks.parsePrereqResult(res2);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block23;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkApplicable(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
                catch (IOException e1) {
                    OLogger.debug(e1.getMessage());
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkActiveFilesAndExecutables(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                ArrayList<String> list;
                filterFiles myFilter;
                Path patchDir;
                Vector inPatchIDs = new Vector();
                boolean inSystem = false;
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                String patchLocation = (String)oVarPatchLoc.getValue();
                OiisVariable oVarBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                String patchBaseDir = (String)oVarBaseDir.getValue();
                OiisVariable oVarList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                String patchList = (String)oVarList.getValue();
                OiisVariable oVarPatchID = oContext.getVariable("OPATCH_PATCH_ID");
                String patchID = (String)oVarPatchID.getValue();
                Object[] patchLocs = null;
                PrereqResult res1 = null;
                PrereqResult res2 = null;
                if (patchBaseDir != null && !patchBaseDir.equals("")) {
                    try {
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                        myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else if (patchList != null && !patchList.equals("")) {
                    try {
                        Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                        BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                        patchLocs = OPatchChecks.parseBaseFile(br);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e3) {
                        OiixException oe = new OiixException((Throwable)e3);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else if (patchLocation != null && !patchLocation.equals("") && PQSession.isComposite(patchLocation)) {
                    patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                    myFilter = new filterFiles();
                    DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                    list = new ArrayList();
                    for (Path stream : patchStreams) {
                        list.add(stream.toString());
                    }
                    patchLocs = new String[list.size()];
                    list.toArray(patchLocs);
                    Arrays.sort(patchLocs);
                } else if (patchLocation != null && !patchLocation.equals("") && !PQSession.isComposite(patchLocation)) {
                    patchLocs = new String[]{patchLocation};
                } else {
                    StringTokenizer st = new StringTokenizer(patchID, ",");
                    String[] patchIDs = new String[st.countTokens()];
                    int i2 = 0;
                    while (st.hasMoreTokens()) {
                        String str = st.nextToken();
                        patchIDs[i2++] = str.trim();
                    }
                    Vector installedPatchIDs = new Vector();
                    Vector notInstalledPatchIDs = new Vector();
                    PrereqResult pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
                    if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        if (installedPatchIDs.size() == 0) {
                            OiixException oe = new OiixException("None of the given patches are present in the Oracle Home.");
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                            return oResult;
                        }
                        res2 = new PrereqResult();
                        if (installedPatchIDs.size() == 0) {
                            res2.setResult(PrereqResult.ExecuteStatus.FAILED);
                        } else {
                            res2.setResult(PrereqResult.ExecuteStatus.PASSED);
                        }
                        StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                        tbuf.append(notInstalledPatchIDs.toString());
                        res2.addDetail(tbuf.toString());
                    } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                        return OPatchChecks.parsePrereqResult(pRes);
                    }
                    patchLocs = new String[installedPatchIDs.size()];
                    for (int idIter = 0; idIter < installedPatchIDs.size(); ++idIter) {
                        patchLocs[idIter] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(idIter));
                    }
                    inPatchIDs = installedPatchIDs;
                    inSystem = true;
                }
                try {
                    for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                        PatchObject pObj = null;
                        pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                        res1 = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, pObj);
                        res2 = res2 == null ? res1 : OPatchChecks.mergeResultObjs(res1, res2);
                    }
                    oResult = OPatchChecks.parsePrereqResult(res2);
                }
                catch (Exception e4) {
                    OiixException oe = new OiixException((Throwable)e4);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
            catch (OipckUnknownKnowledgeSourceException e6) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
            }
            catch (OipckUnknownBuilderException e7) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
            }
            catch (IOException e8) {
                OLogger.debug(e8.getMessage());
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkPatchApplicableOnCurrentPlatform(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            PatchObject[] pObjs = new PatchObject[patchLocs.length];
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                PatchObject pObj;
                                Object patchLoc = patchLocs[i2];
                                pObjs[i2] = pObj = PatchObject.getInstance((String)patchLoc);
                            }
                            PrereqResult resObj = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, pObjs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            PatchObject[] pObjs = new PatchObject[patchLocs.length];
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj;
                                pObjs[i3] = pObj = PatchObject.getInstance(patchLocs[i3]);
                            }
                            PrereqResult resObj = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, pObjs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            PatchObject[] pObjs = new PatchObject[patchLocs.length];
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                PatchObject pObj;
                                pObjs[i4] = pObj = PatchObject.getInstance((String)patchLocs[i4]);
                            }
                            PrereqResult resObj = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, pObjs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    try {
                        PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        PrereqResult resObj = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, pObj);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkPatchShipHome(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                Path patchDir;
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                String patchLocation = (String)oVarPatchLoc.getValue();
                OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                String patchList = (String)oVarPatchList.getValue();
                Object[] patchLocs = null;
                if (patchBaseDir != null && !patchBaseDir.equals("")) {
                    try {
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        ArrayList<String> list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else if (patchList != null && !patchList.equals("")) {
                    try {
                        Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                        BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                        patchLocs = OPatchChecks.parseBaseFile(br);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e3) {
                        OiixException oe = new OiixException((Throwable)e3);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else {
                    patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        ArrayList<String> list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                    }
                }
                PrereqResult resObj = PrereqAPI.checkPatchShipHome((String[])patchLocs);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownKnowledgeSourceException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
            catch (OipckUnknownBuilderException e6) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
            }
            catch (IOException e7) {
                OLogger.debug(e7.getMessage());
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkSystemCommandAvailable(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                ArrayList<String> list;
                filterFiles myFilter;
                Path patchDir;
                boolean inSystem = false;
                Vector inPatchIDs = new Vector();
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                String patchLocation = (String)oVarPatchLoc.getValue();
                OiisVariable oVarBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                String patchBaseDir = (String)oVarBaseDir.getValue();
                OiisVariable oVarList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                String patchList = (String)oVarList.getValue();
                OiisVariable oVarPatchID = oContext.getVariable("OPATCH_PATCH_ID");
                String patchID = (String)oVarPatchID.getValue();
                Object[] patchLocs = null;
                PrereqResult res1 = null;
                PrereqResult res2 = null;
                if (patchBaseDir != null && !patchBaseDir.equals("")) {
                    try {
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                        myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else if (patchList != null && !patchList.equals("")) {
                    try {
                        Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                        BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                        patchLocs = OPatchChecks.parseBaseFile(br);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                    }
                    catch (Exception e3) {
                        OiixException oe = new OiixException((Throwable)e3);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                } else if (patchLocation != null && !patchLocation.equals("")) {
                    patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                        myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        list = new ArrayList();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                    }
                } else {
                    StringTokenizer st = new StringTokenizer(patchID, ",");
                    String[] patchIDs = new String[st.countTokens()];
                    int i2 = 0;
                    while (st.hasMoreTokens()) {
                        String str = st.nextToken();
                        patchIDs[i2++] = str.trim();
                    }
                    Vector installedPatchIDs = new Vector();
                    Vector notInstalledPatchIDs = new Vector();
                    PrereqResult pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
                    if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        if (installedPatchIDs.size() == 0) {
                            OiixException oe = new OiixException("None of the given patches are present in the Oracle Home.");
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                            return oResult;
                        }
                        res2 = new PrereqResult();
                        if (installedPatchIDs.size() == 0) {
                            res2.setResult(PrereqResult.ExecuteStatus.FAILED);
                        } else {
                            res2.setResult(PrereqResult.ExecuteStatus.PASSED);
                        }
                        StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                        tbuf.append(notInstalledPatchIDs.toString());
                        res2.addDetail(tbuf.toString());
                    } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                        return OPatchChecks.parsePrereqResult(pRes);
                    }
                    patchLocs = new String[installedPatchIDs.size()];
                    for (int idIter = 0; idIter < installedPatchIDs.size(); ++idIter) {
                        patchLocs[idIter] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(idIter));
                    }
                    inPatchIDs = installedPatchIDs;
                    inSystem = true;
                }
                try {
                    for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                        PatchObject pObj = null;
                        pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                        OneOffEntry oneOff = pObj.toOneOffEntry(oracleHomePath);
                        String[] executables = pObj.getExecutables(oracleHomePath);
                        res1 = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, oneOff, executables);
                        res2 = res2 == null ? res1 : OPatchChecks.mergeResultObjs(res1, res2);
                    }
                    oResult = OPatchChecks.parsePrereqResult(res2);
                }
                catch (Exception e4) {
                    OiixException oe = new OiixException((Throwable)e4);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
            catch (OipckUnknownKnowledgeSourceException e6) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
            }
            catch (OipckUnknownBuilderException e7) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
            }
            catch (IOException e8) {
                OLogger.debug(e8.getMessage());
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkSystemSpace(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            OneOffEntry[] oneOffEntries = new OneOffEntry[patchLocs.length];
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                OneOffEntry oneOff;
                                PatchObject pObj = PatchObject.getInstance((String)patchLocs[i2]);
                                oneOffEntries[i2] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                            }
                            PrereqResult resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOffEntries, (String[])patchLocs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            OneOffEntry[] oneOffEntries = new OneOffEntry[patchLocs.length];
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                OneOffEntry oneOff;
                                PatchObject pObj = PatchObject.getInstance(patchLocs[i3]);
                                oneOffEntries[i3] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                            }
                            PrereqResult resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOffEntries, patchLocs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            OneOffEntry[] oneOffEntries = new OneOffEntry[patchLocs.length];
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                OneOffEntry oneOff;
                                PatchObject pObj = PatchObject.getInstance((String)patchLocs[i4]);
                                oneOffEntries[i4] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                            }
                            PrereqResult resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOffEntries, (String[])patchLocs);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block22;
                    }
                    try {
                        PatchObject pObj = PatchObject.getInstance(patchLocs[0]);
                        OneOffEntry[] oneOff = new OneOffEntry[]{pObj.toOneOffEntry(oracleHomePath)};
                        PrereqResult resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOff, (String[])patchLocs);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkIdenticalPatch(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block28: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            int i2;
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            String compositeLocation = OPatchChecks.getCompositeLocation((String[])patchLocs, patchBaseDir);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            OneOffEntry[] subPatchEntries = new OneOffEntry[]{};
                            if (!compositeLocation.equals("")) {
                                subPatchEntries = PQSession.getSubPatches(compositeLocation, oracleHomePath);
                                subPatchEntries = CompositePatchObject.GetNonIdenticalPatch(subPatchEntries, oracleHomePath);
                            }
                            ArrayList<OneOffEntry> oneOffs = new ArrayList<OneOffEntry>();
                            for (i2 = 0; patchLocs != null && i2 < patchLocs.length; ++i2) {
                                if (PQSession.isCompositeSubPatch((String)patchLocs[i2])) continue;
                                Object patchLoc = patchLocs[i2];
                                PatchObject pObj = PatchObject.getInstance((String)patchLoc);
                                OneOffEntry oneOff = pObj.toOneOffEntry(oracleHomePath);
                                oneOffs.add(oneOff);
                            }
                            for (i2 = 0; subPatchEntries != null && i2 < subPatchEntries.length; ++i2) {
                                oneOffs.add(subPatchEntries[i2]);
                            }
                            OneOffEntry[] oneOffEntries = new OneOffEntry[oneOffs.size()];
                            for (int i3 = 0; oneOffEntries != null && i3 < oneOffEntries.length; ++i3) {
                                oneOffEntries[i3] = (OneOffEntry)oneOffs.get(i3);
                            }
                            ArrayList identicalPatches = new ArrayList();
                            PrereqResult resObj = PrereqAPI.checkIdenticalPatch(oracleHomePath, identicalPatches, oneOffEntries);
                            if (identicalPatches != null && identicalPatches.size() != 0 && identicalPatches.size() < oneOffEntries.length) {
                                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                            }
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block28;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            int i4;
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            String compositeLocation = OPatchChecks.getCompositeLocation(patchLocs, patchBaseDir);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            OneOffEntry[] subPatchEntries = new OneOffEntry[]{};
                            if (!compositeLocation.equals("")) {
                                subPatchEntries = PQSession.getSubPatches(compositeLocation, oracleHomePath);
                                subPatchEntries = CompositePatchObject.GetNonIdenticalPatch(subPatchEntries, oracleHomePath);
                            }
                            ArrayList<OneOffEntry> oneOffs = new ArrayList<OneOffEntry>();
                            for (i4 = 0; patchLocs != null && i4 < patchLocs.length; ++i4) {
                                if (PQSession.isCompositeSubPatch(patchLocs[i4])) continue;
                                String patchLoc = patchLocs[i4];
                                PatchObject pObj = PatchObject.getInstance(patchLoc);
                                OneOffEntry oneOff = pObj.toOneOffEntry(oracleHomePath);
                                oneOffs.add(oneOff);
                            }
                            for (i4 = 0; subPatchEntries != null && i4 < subPatchEntries.length; ++i4) {
                                oneOffs.add(subPatchEntries[i4]);
                            }
                            OneOffEntry[] oneOffEntries = new OneOffEntry[oneOffs.size()];
                            for (int i5 = 0; oneOffEntries != null && i5 < oneOffEntries.length; ++i5) {
                                oneOffEntries[i5] = (OneOffEntry)oneOffs.get(i5);
                            }
                            ArrayList identicalPatches = new ArrayList();
                            PrereqResult resObj = PrereqAPI.checkIdenticalPatch(oracleHomePath, identicalPatches, oneOffEntries);
                            if (identicalPatches != null && identicalPatches.size() != 0 && identicalPatches.size() < oneOffEntries.length) {
                                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                            }
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block28;
                    }
                    String[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            OneOffEntry[] subPatchEntries = new OneOffEntry[]{};
                            subPatchEntries = PQSession.getSubPatches(patchLocation, oracleHomePath);
                            subPatchEntries = CompositePatchObject.GetNonIdenticalPatch(subPatchEntries, oracleHomePath);
                            PrereqResult resObj = PrereqAPI.checkIdenticalPatch(oracleHomePath, new ArrayList(), subPatchEntries);
                            oResult = OPatchChecks.parsePrereqResult(resObj);
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block28;
                    }
                    try {
                        PatchObject pObj = PatchObject.getInstance(patchLocs[0]);
                        OneOffEntry[] oneOff = new OneOffEntry[]{pObj.toOneOffEntry(oracleHomePath)};
                        PrereqResult resObj = PrereqAPI.checkIdenticalPatch(oracleHomePath, new ArrayList(), oneOff);
                        oResult = OPatchChecks.parsePrereqResult(resObj);
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkRollbackable(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchID = oContext.getVariable("OPATCH_PATCH_ID");
                String patchID = (String)oVarPatchID.getValue();
                StringTokenizer st = new StringTokenizer(patchID, ",");
                String[] patchIDs = new String[st.countTokens()];
                int i2 = 0;
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    patchIDs[i2++] = str.trim();
                }
                Vector installedPatchIDs = new Vector();
                Vector notInstalledPatchIDs = new Vector();
                PrereqResult pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
                if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    if (installedPatchIDs.size() == 0) {
                        OiixException oe = new OiixException("None of the given patches are present in the Oracle Home.");
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                    if (installedPatchIDs.size() == 0) {
                        pRes.setResult(PrereqResult.ExecuteStatus.FAILED);
                    } else {
                        pRes.setResult(PrereqResult.ExecuteStatus.PASSED);
                    }
                } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    return OPatchChecks.parsePrereqResult(pRes);
                }
                try {
                    PatchObject[] pObjs = new PatchObject[installedPatchIDs.size()];
                    for (int idIter = 0; idIter < installedPatchIDs.size(); ++idIter) {
                        pObjs[idIter] = PatchObject.getInstance(oracleHomePath, (String)installedPatchIDs.elementAt(idIter));
                    }
                    PrereqResult resObj = PrereqAPI.checkRollbackable(oracleHomePath, pObjs);
                    resObj = OPatchChecks.mergeResultObjs(pRes, resObj);
                    oResult = OPatchChecks.parsePrereqResult(resObj);
                }
                catch (Exception e2) {
                    OiixException oe = new OiixException((Throwable)e2);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkConflictAgainstOH(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block47: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    boolean skipConflict = false;
                    boolean skipDuplicate = false;
                    boolean skipSubset = false;
                    boolean forceConflict = false;
                    try {
                        OiisVariable oConflict = oContext.getVariable("OPATCH_SKIP_CONFLICT");
                        skipConflict = Boolean.valueOf((String)oConflict.getValue());
                    }
                    catch (Exception e2) {
                        skipConflict = false;
                    }
                    try {
                        OiisVariable oDuplicate = oContext.getVariable("OPATCH_SKIP_DUPLICATE");
                        skipDuplicate = Boolean.valueOf((String)oDuplicate.getValue());
                    }
                    catch (Exception e3) {
                        skipDuplicate = false;
                    }
                    try {
                        OiisVariable oSubset = oContext.getVariable("OPATCH_SKIP_SUBSET");
                        skipSubset = Boolean.valueOf((String)oSubset.getValue());
                    }
                    catch (Exception e4) {
                        skipSubset = false;
                    }
                    try {
                        OiisVariable oForceConflict = oContext.getVariable("OPATCH_FORCE_CONFLICT");
                        forceConflict = Boolean.valueOf((String)oForceConflict.getValue());
                    }
                    catch (Exception e5) {
                        forceConflict = false;
                    }
                    OPatchEnv.setSkipSubset(skipSubset);
                    OPatchEnv.setIgnoreConflict(skipConflict);
                    OPatchEnv.setForceConflict(forceConflict);
                    OPatchEnv.setSkipDuplicate(skipDuplicate);
                    try {
                        if (forceConflict && skipConflict) {
                            throw new Exception("'force_conflict' and 'skip_conflict' are mutually exclusive options. Please do not provide both options together.");
                        }
                    }
                    catch (Exception e6) {
                        OiixException oe = new OiixException((Throwable)e6);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            PatchObject pObj;
                            int i2;
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            int compositeIndex = -1;
                            Object compositeLoc = "";
                            for (int i3 = 0; patchLocs != null && i3 < patchLocs.length; ++i3) {
                                if (!PQSession.isComposite((String)patchLocs[i3])) continue;
                                compositeIndex = i3;
                                compositeLoc = patchLocs[i3];
                            }
                            if (PQSession.isComposite(patchBaseDir)) {
                                compositeIndex = 0;
                                compositeLoc = patchBaseDir;
                            }
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            OneOffEntry[] oneOffEntries = new OneOffEntry[]{};
                            OneOffEntry[] compositeOneOffEntries = new OneOffEntry[]{};
                            if (compositeIndex != -1) {
                                try {
                                    compositeOneOffEntries = PQSession.getSubPatches((String)compositeLoc, oracleHomePath);
                                }
                                catch (Exception e7) {
                                    OLogger.println("Error in combining composite. Check to make sure patch is valid.");
                                    OLogger.println(e7.getMessage());
                                }
                            }
                            ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
                            for (i2 = 0; patchLocs != null && i2 < patchLocs.length; ++i2) {
                                if (PQSession.isCompositeSubPatch((String)patchLocs[i2])) continue;
                                pObj = PatchObject.getInstance((String)patchLocs[i2]);
                                pObjsList.add(pObj);
                            }
                            if (compositeOneOffEntries.length > 0) {
                                oneOffEntries = new OneOffEntry[pObjsList.size() + compositeOneOffEntries.length];
                                for (i2 = 0; i2 < compositeOneOffEntries.length; ++i2) {
                                    oneOffEntries[pObjsList.size() + i2] = compositeOneOffEntries[i2];
                                }
                            } else {
                                oneOffEntries = new OneOffEntry[pObjsList.size()];
                            }
                            for (i2 = 0; pObjsList != null && i2 < pObjsList.size(); ++i2) {
                                OneOffEntry oneOff;
                                pObj = (PatchObject)pObjsList.get(i2);
                                oneOffEntries[i2] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                            }
                            ConflictOutput resObj = null;
                            resObj = PrereqAPI.checkConflictAgainstOH(oracleHomePath, oneOffEntries);
                            oResult = OPatchChecks.parseConflictOutput(resObj);
                        }
                        catch (Exception e8) {
                            OiixException oe = new OiixException((Throwable)e8);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block47;
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            PatchObject pObj;
                            int i4;
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            int compositeIndex = -1;
                            String compositeLoc = "";
                            for (int i5 = 0; patchLocs != null && i5 < patchLocs.length; ++i5) {
                                if (!PQSession.isComposite(patchLocs[i5])) continue;
                                compositeIndex = i5;
                                compositeLoc = patchLocs[i5];
                            }
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            OneOffEntry[] oneOffEntries = new OneOffEntry[]{};
                            OneOffEntry[] compositeOneOffEntries = new OneOffEntry[]{};
                            if (compositeIndex != -1) {
                                try {
                                    compositeOneOffEntries = PQSession.getSubPatches(compositeLoc, oracleHomePath);
                                }
                                catch (Exception e9) {
                                    OLogger.println("Error in combining composite. Check to make sure patch is valid.");
                                    OLogger.println(e9.getMessage());
                                }
                            }
                            ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
                            for (i4 = 0; patchLocs != null && i4 < patchLocs.length; ++i4) {
                                if (PQSession.isCompositeSubPatch(patchLocs[i4])) continue;
                                pObj = PatchObject.getInstance(patchLocs[i4]);
                                pObjsList.add(pObj);
                            }
                            if (compositeOneOffEntries.length > 0) {
                                oneOffEntries = new OneOffEntry[pObjsList.size() + compositeOneOffEntries.length];
                                for (i4 = 0; i4 < compositeOneOffEntries.length; ++i4) {
                                    oneOffEntries[pObjsList.size() + i4] = compositeOneOffEntries[i4];
                                }
                            } else {
                                oneOffEntries = new OneOffEntry[pObjsList.size()];
                            }
                            for (i4 = 0; pObjsList != null && i4 < pObjsList.size(); ++i4) {
                                OneOffEntry oneOff;
                                pObj = (PatchObject)pObjsList.get(i4);
                                oneOffEntries[i4] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                            }
                            ConflictOutput resObj = null;
                            resObj = PrereqAPI.checkConflictAgainstOH(oracleHomePath, oneOffEntries);
                            oResult = OPatchChecks.parseConflictOutput(resObj);
                        }
                        catch (Exception e10) {
                            OiixException oe = new OiixException((Throwable)e10);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                        break block47;
                    }
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String[] patchLoc = new String[]{(String)oVarPatchLoc.getValue()};
                    OneOffEntry[] oneOffs = new OneOffEntry[1];
                    try {
                        ConflictOutput resObj = null;
                        if (PQSession.isComposite(patchLoc[0])) {
                            OneOffEntry[] oneOffEntries = new OneOffEntry[]{};
                            oneOffEntries = PQSession.getSubPatches(patchLoc[0], oracleHomePath);
                            oneOffEntries = CompositePatchObject.GetNonIdenticalPatch(oneOffEntries, oracleHomePath);
                            oneOffEntries = PQSession.createCombinedComposite(oneOffEntries);
                            resObj = PrereqAPI.checkConflictAgainstOH(oracleHomePath, oneOffEntries);
                        } else {
                            PatchObject pObj = PatchObject.getInstance(patchLoc[0]);
                            oneOffs[0] = pObj.toOneOffEntry(oracleHomePath);
                            resObj = PrereqAPI.checkConflictAgainstOH(oracleHomePath, oneOffs);
                        }
                        oResult = OPatchChecks.parseConflictOutput(resObj);
                    }
                    catch (Exception e11) {
                        OiixException oe = new OiixException((Throwable)e11);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e12) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e12);
                }
                catch (OipckUnknownKnowledgeSourceException e13) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e13);
                }
                catch (OipckUnknownBuilderException e14) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e14);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkCentralInventoryLocation(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                Class<?> oiipgPropertyLoader = Class.forName("oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader");
                Method getLocationFileLocMethod = oiipgPropertyLoader.getMethod("getLocationFileLoc", String.class);
                String centralInvLoc = getLocationFileLocMethod.invoke(oiipgPropertyLoader.newInstance(), OiipgPropertyLoader.getUnixPtrFileLoc()).toString();
                PrereqResult resObj = PrereqAPI.checkCentralInventoryLocation(centralInvLoc);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (ClassNotFoundException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OiixException((Throwable)e5));
            }
            catch (NoSuchMethodException e6) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OiixException((Throwable)e6));
            }
            catch (InstantiationException e7) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OiixException((Throwable)e7));
            }
            catch (IllegalAccessException e8) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OiixException((Throwable)e8));
            }
            catch (InvocationTargetException e9) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OiixException((Throwable)e9));
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkOraInstLocation(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (curPlatId == -3) {
            return oResult;
        }
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                String oraInstLocation = OiipgPropertyLoader.getUnixPtrFileLoc();
                PrereqResult resObj = PrereqAPI.checkOraInstLocation(oraInstLocation);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkRACNodeList(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarRemoteNodes = oContext.getVariable("OPATCH_REMOTE_NODES");
                String remoteNodes = (String)oVarRemoteNodes.getValue();
                if (remoteNodes != null && !remoteNodes.equals("")) {
                    String[] nodes = remoteNodes.split(",");
                    try {
                        OPatchACL.setUserSuppliedRemoteNodes(new OPatchChecks(), nodes);
                    }
                    catch (IllegalAccessException e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                }
                PrereqResult resObj = PrereqAPI.checkRACNodeList(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkForCRSHomeIfRAC(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarRemoteNodes = oContext.getVariable("OPATCH_REMOTE_NODES");
                String remoteNodes = (String)oVarRemoteNodes.getValue();
                if (remoteNodes != null && !remoteNodes.equals("")) {
                    String[] nodes = remoteNodes.split(",");
                    try {
                        OPatchACL.setUserSuppliedRemoteNodes(new OPatchChecks(), nodes);
                    }
                    catch (IllegalAccessException e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                }
                PrereqResult resObj = PrereqAPI.checkForCRSHomeIfRAC(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkRemoteCommandInvocable(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarRemoteNodes = oContext.getVariable("OPATCH_REMOTE_NODES");
                String remoteNodes = (String)oVarRemoteNodes.getValue();
                if (remoteNodes != null && !remoteNodes.equals("")) {
                    String[] nodes = remoteNodes.split(",");
                    try {
                        OPatchACL.setUserSuppliedRemoteNodes(new OPatchChecks(), nodes);
                    }
                    catch (IllegalAccessException e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                }
                PrereqResult resObj = PrereqAPI.checkRemoteCommandInvocable(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkRemoteCopyAndRemove(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarRemoteNodes = oContext.getVariable("OPATCH_REMOTE_NODES");
                String remoteNodes = (String)oVarRemoteNodes.getValue();
                if (remoteNodes != null && !remoteNodes.equals("")) {
                    String[] nodes = remoteNodes.split(",");
                    try {
                        OPatchACL.setUserSuppliedRemoteNodes(new OPatchChecks(), nodes);
                    }
                    catch (IllegalAccessException e2) {
                        OiixException oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                }
                PrereqResult resObj = PrereqAPI.checkRemoteCopyAndRemove(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkInstalledOneOffs(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchIDs = oContext.getVariable("OPATCH_PATCH_ID");
                String patchID = (String)oVarPatchIDs.getValue();
                StringTokenizer st = new StringTokenizer(patchID, ",");
                String[] patchIDs = new String[st.countTokens()];
                int i2 = 0;
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    patchIDs[i2++] = str.trim();
                }
                Vector installedPatchIDs = new Vector();
                Vector notInstalledPatchIDs = new Vector();
                PrereqResult resObj = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
                oResult = OPatchChecks.parsePrereqResult(resObj);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkActiveServices(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                PrereqResult res = PrereqAPI.checkActiveServices(oracleHomePath);
                oResult = OPatchChecks.parsePrereqResult(res);
            }
            catch (OipckKnowledgeSourceException e2) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e2);
            }
            catch (OipckUnknownKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownBuilderException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkApplicableProduct(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                Object[] patchLocs;
                OiixException oe;
                ArrayList<String> list;
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                String patchLocation = (String)oVarPatchLoc.getValue();
                OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                String patchList = (String)oVarPatchList.getValue();
                PatchObject[] pObjs = null;
                if (patchBaseDir != null && !patchBaseDir.equals("")) {
                    try {
                        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        Object[] patchLocs2 = null;
                        list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs2 = new String[list.size()];
                        list.toArray(patchLocs2);
                        Arrays.sort(patchLocs2);
                        pObjs = new PatchObject[patchLocs2.length];
                        PQSession.allowOnlyOneComposite((String[])patchLocs2);
                        for (int i2 = 0; i2 < patchLocs2.length; ++i2) {
                            PatchObject pObj;
                            Object patchLoc = patchLocs2[i2];
                            pObjs[i2] = pObj = PatchObject.getInstance((String)patchLoc);
                        }
                    }
                    catch (Exception e2) {
                        oe = new OiixException((Throwable)e2);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                } else if (patchList != null && !patchList.equals("")) {
                    try {
                        patchLocs = null;
                        Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                        BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                        ArrayList<String> al = new ArrayList<String>();
                        String line = br.readLine();
                        while (line != null) {
                            al.add(line);
                            line = br.readLine();
                        }
                        patchLocs = new String[al.size()];
                        al.toArray(patchLocs);
                        PQSession.allowOnlyOneComposite((String[])patchLocs);
                        pObjs = new PatchObject[patchLocs.length];
                        for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                            PatchObject pObj;
                            pObjs[i3] = pObj = PatchObject.getInstance((String)patchLocs[i3]);
                        }
                    }
                    catch (Exception e3) {
                        oe = new OiixException((Throwable)e3);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                } else {
                    patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        list = new ArrayList();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs = new String[list.size()];
                        list.toArray(patchLocs);
                        Arrays.sort(patchLocs);
                        try {
                            pObjs = new PatchObject[patchLocs.length];
                            for (int i4 = 0; i4 < pObjs.length; ++i4) {
                                pObjs[i4] = PatchObject.getInstance((String)patchLocs[i4]);
                            }
                        }
                        catch (Exception e4) {
                            OiixException oe2 = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe2);
                        }
                    } else {
                        try {
                            pObjs = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        }
                        catch (Exception e5) {
                            OiixException oe3 = new OiixException((Throwable)e5);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe3);
                        }
                    }
                }
                try {
                    PrereqResult res1 = null;
                    PrereqResult res2 = null;
                    for (int idIter = 0; idIter < pObjs.length; ++idIter) {
                        res1 = PrereqAPI.checkApplicableProduct(oracleHomePath, pObjs[idIter]);
                        res2 = res2 == null ? res1 : OPatchChecks.mergeResultObjs(res1, res2);
                    }
                    oResult = OPatchChecks.parsePrereqResult(res2);
                }
                catch (Exception e6) {
                    oe = new OiixException((Throwable)e6);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e7) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
            }
            catch (OipckUnknownKnowledgeSourceException e8) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
            }
            catch (OipckUnknownBuilderException e9) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e9);
            }
            catch (IOException e1) {
                OLogger.debug(e1.getMessage());
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkPatchInventoryProductMatch(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
            OPatchChecks.getAndSetInvPtrLoc();
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                    String oracleHomePath = (String)oVarOracleHome.getValue();
                    OPatchChecks.setOracleHome(oracleHomePath);
                    OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                    String patchLocation = (String)oVarPatchLoc.getValue();
                    OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                    String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                    OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                    String patchList = (String)oVarPatchList.getValue();
                    PatchObject[] pObjs = null;
                    if (patchBaseDir != null && !patchBaseDir.equals("")) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            Object[] patchLocs = null;
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                            pObjs = new PatchObject[patchLocs.length];
                            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                                PatchObject pObj;
                                Object patchLoc = patchLocs[i2];
                                pObjs[i2] = pObj = PatchObject.getInstance((String)patchLoc);
                            }
                            break block22;
                        }
                        catch (Exception e2) {
                            OiixException oe = new OiixException((Throwable)e2);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                            break block22;
                        }
                    }
                    if (patchList != null && !patchList.equals("")) {
                        try {
                            String[] patchLocs = null;
                            Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                            BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                            patchLocs = OPatchChecks.parseBaseFile(br);
                            patchLocs = OPatchChecks.handleCompositeCases(patchLocs, patchBaseDir);
                            pObjs = new PatchObject[patchLocs.length];
                            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                                PatchObject pObj;
                                pObjs[i3] = pObj = PatchObject.getInstance(patchLocs[i3]);
                            }
                            break block22;
                        }
                        catch (Exception e3) {
                            OiixException oe = new OiixException((Throwable)e3);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                            break block22;
                        }
                    }
                    Object[] patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            ArrayList<String> list = new ArrayList<String>();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            pObjs = new PatchObject[patchLocs.length];
                            for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                                pObjs[i4] = PatchObject.getInstance((String)patchLocs[i4]);
                            }
                            break block22;
                        }
                        catch (Exception e4) {
                            OiixException oe = new OiixException((Throwable)e4);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                            break block22;
                        }
                    }
                    try {
                        pObjs = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                    }
                    catch (Exception e5) {
                        OiixException oe = new OiixException((Throwable)e5);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                    }
                }
                catch (OipckKnowledgeSourceException e6) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e6);
                }
                catch (OipckUnknownKnowledgeSourceException e7) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e7);
                }
                catch (OipckUnknownBuilderException e8) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkPatchApplyDependents(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiixException oe;
                Object[] patchLocs;
                OiixException oe2;
                int i2;
                ArrayList<String> list;
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchLoc = oContext.getVariable("OPATCH_PATCH_LOCATION");
                String patchLocation = (String)oVarPatchLoc.getValue();
                OiisVariable oVarPatchBaseDir = oContext.getVariable("OPATCH_PATCH_BASE_DIR");
                String patchBaseDir = (String)oVarPatchBaseDir.getValue();
                OiisVariable oVarPatchList = oContext.getVariable("OPATCH_PATCH_BASE_FILE");
                String patchList = (String)oVarPatchList.getValue();
                String patchIDs = "";
                OiisVariable oPatchIDs = null;
                try {
                    oPatchIDs = oContext.getVariable("OPATCH_PATCH_ID");
                }
                catch (Exception e2) {
                    oPatchIDs = null;
                }
                if (oPatchIDs != null) {
                    patchIDs = (String)oPatchIDs.getValue();
                    if (patchIDs == null) {
                        patchIDs = "";
                    }
                } else {
                    patchIDs = "";
                }
                PatchObject[] pObjs = null;
                if (patchBaseDir != null && !patchBaseDir.equals("")) {
                    try {
                        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchBaseDir, new String[0]);
                        filterFiles myFilter = new filterFiles();
                        DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                        Object[] patchLocs2 = null;
                        list = new ArrayList<String>();
                        for (Path stream : patchStreams) {
                            list.add(stream.toString());
                        }
                        patchLocs2 = new String[list.size()];
                        list.toArray(patchLocs2);
                        Arrays.sort(patchLocs2);
                        patchLocs2 = OPatchChecks.handleCompositeCases((String[])patchLocs2, patchBaseDir);
                        pObjs = new PatchObject[patchLocs2.length];
                        for (i2 = 0; i2 < patchLocs2.length; ++i2) {
                            PatchObject pObj;
                            Object patchLoc = patchLocs2[i2];
                            pObjs[i2] = pObj = PatchObject.getInstance((String)patchLoc);
                        }
                    }
                    catch (Exception e3) {
                        oe2 = new OiixException((Throwable)e3);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe2);
                    }
                } else if (patchList != null && !patchList.equals("")) {
                    try {
                        patchLocs = null;
                        Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(patchList, new String[0]);
                        BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                        patchLocs = OPatchChecks.parseBaseFile(br);
                        patchLocs = OPatchChecks.handleCompositeCases((String[])patchLocs, patchBaseDir);
                        pObjs = new PatchObject[patchLocs.length];
                        for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                            PatchObject pObj;
                            pObjs[i3] = pObj = PatchObject.getInstance(patchLocs[i3]);
                        }
                    }
                    catch (Exception e4) {
                        oe2 = new OiixException((Throwable)e4);
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe2);
                    }
                } else {
                    patchLocs = new String[]{patchLocation};
                    if (PQSession.isComposite(patchLocation)) {
                        try {
                            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                            filterFiles myFilter = new filterFiles();
                            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
                            list = new ArrayList();
                            for (Path stream : patchStreams) {
                                list.add(stream.toString());
                            }
                            patchLocs = new String[list.size()];
                            list.toArray(patchLocs);
                            Arrays.sort(patchLocs);
                            pObjs = new PatchObject[patchLocs.length];
                            for (i2 = 0; i2 < patchLocs.length; ++i2) {
                                pObjs[i2] = PatchObject.getInstance((String)patchLocs[i2]);
                            }
                        }
                        catch (Exception e5) {
                            oe = new OiixException((Throwable)e5);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                    } else {
                        try {
                            pObjs = new PatchObject[]{PatchObject.getInstance(patchLocs[0])};
                        }
                        catch (Exception e6) {
                            oe = new OiixException((Throwable)e6);
                            oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        }
                    }
                }
                String[] patchIDList = new String[]{};
                if (!patchIDs.equals("")) {
                    patchIDList = patchIDs.split("[\\s|,]");
                }
                try {
                    OneOffEntry[] oneOffs = new OneOffEntry[pObjs.length];
                    for (int idIter = 0; idIter < pObjs.length; ++idIter) {
                        oneOffs[idIter] = pObjs[idIter].toOneOffEntry(oracleHomePath);
                    }
                    PrereqResult resObj = null;
                    resObj = patchIDList != null && patchIDList.length != 0 ? PrereqAPI.checkPatchApplyDependents(oracleHomePath, oneOffs, patchIDList) : PrereqAPI.checkPatchApplyDependents(oracleHomePath, oneOffs);
                    oResult = OPatchChecks.parsePrereqResult(resObj);
                }
                catch (Exception e7) {
                    oe = new OiixException((Throwable)e7);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e8) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e8);
            }
            catch (OipckUnknownKnowledgeSourceException e9) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e9);
            }
            catch (OipckUnknownBuilderException e10) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e10);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkPatchRollbackDependents(OipcrIRulesEngine oRulesEngine, String refFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        System.setProperty("oracle.opatch.opatchprereq.calledFromOUI", "true");
        OPatchChecks.getAndSetInvPtrLoc();
        if (oRulesEngine != null) {
            try {
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVarOracleHome = oContext.getVariable("ORACLE_HOME");
                String oracleHomePath = (String)oVarOracleHome.getValue();
                OPatchChecks.setOracleHome(oracleHomePath);
                OiisVariable oVarPatchID = oContext.getVariable("OPATCH_PATCH_ID");
                String patchID = (String)oVarPatchID.getValue();
                StringTokenizer st = new StringTokenizer(patchID, ",");
                String[] patchIDs = new String[st.countTokens()];
                int i2 = 0;
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    patchIDs[i2++] = str.trim();
                }
                Vector installedPatchIDs = new Vector();
                Vector notInstalledPatchIDs = new Vector();
                PrereqResult pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
                if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    if (installedPatchIDs.size() == 0) {
                        OiixException oe = new OiixException("None of the given patches are present in the Oracle Home.");
                        oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                        return oResult;
                    }
                    if (installedPatchIDs.size() == 0) {
                        pRes.setResult(PrereqResult.ExecuteStatus.FAILED);
                    } else {
                        pRes.setResult(PrereqResult.ExecuteStatus.PASSED);
                    }
                } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    return OPatchChecks.parsePrereqResult(pRes);
                }
                try {
                    String[] oneOffIDs = new String[installedPatchIDs.size()];
                    for (int idIter = 0; idIter < installedPatchIDs.size(); ++idIter) {
                        oneOffIDs[idIter] = (String)installedPatchIDs.get(idIter);
                    }
                    PrereqResult resObj = PrereqAPI.checkPatchRollbackDependents(oracleHomePath, oneOffIDs);
                    oResult = OPatchChecks.parsePrereqResult(resObj);
                }
                catch (Exception e2) {
                    OiixException oe = new OiixException((Throwable)e2);
                    oResult = OipcrResult.getNotExecutedResult((OiixException)oe);
                }
            }
            catch (OipckKnowledgeSourceException e3) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e3);
            }
            catch (OipckUnknownKnowledgeSourceException e4) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e4);
            }
            catch (OipckUnknownBuilderException e5) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e5);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static String getCompositeLocation(String[] patchLocs, String phBaseDir) throws FileNotFoundException, IOException {
        String compositeLoc;
        String output = "";
        if (!PQSession.isComposite(phBaseDir) && (compositeLoc = PQSession.allowOnlyOneComposite(patchLocs)) != null) {
            output = compositeLoc;
        }
        return output;
    }

    public static String[] handleCompositeCases(String[] patchLocs, String phBaseDir) throws FileNotFoundException, IOException {
        String compositeLoc;
        if (!PQSession.isComposite(phBaseDir) && (compositeLoc = PQSession.allowOnlyOneComposite(patchLocs)) != null) {
            int i2;
            Object[] compPatchLocs = new String[]{};
            ArrayList<Object> newPatchLocs = new ArrayList<Object>();
            Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(compositeLoc, new String[0]);
            filterFiles myFilter = new filterFiles();
            DirectoryStream<Path> patchStreams = Files.newDirectoryStream(patchDir, myFilter);
            ArrayList<String> list = new ArrayList<String>();
            for (Path stream : patchStreams) {
                list.add(stream.toString());
            }
            compPatchLocs = new String[list.size()];
            list.toArray(compPatchLocs);
            Arrays.sort(compPatchLocs);
            for (i2 = 0; patchLocs != null && i2 < patchLocs.length; ++i2) {
                if (patchLocs[i2].equals(compositeLoc)) continue;
                newPatchLocs.add(patchLocs[i2]);
            }
            for (i2 = 0; compPatchLocs != null && i2 < compPatchLocs.length; ++i2) {
                newPatchLocs.add(compPatchLocs[i2]);
            }
            patchLocs = new String[newPatchLocs.size()];
            newPatchLocs.toArray(patchLocs);
        }
        return patchLocs;
    }

    public static String[] parseBaseFile(BufferedReader br) throws IOException {
        String[] patchLocs = new String[]{};
        ArrayList<String> al = new ArrayList<String>();
        String line = br.readLine();
        while (line != null) {
            String loc = line;
            boolean isValidPatchLoc = PQSession.isValidPatchLoc(loc);
            boolean isComposite = PQSession.isComposite(loc);
            if (isValidPatchLoc || isComposite) {
                al.add(line);
            } else {
                Path pDir = WrapperFactory.getNioServiceWrapper().getPath(line, new String[0]);
                if (pDir != null && Files.exists(pDir, new LinkOption[0]) && Files.isDirectory(pDir, new LinkOption[0])) {
                    DirectoryStream<Path> subDirs = null;
                    try {
                        subDirs = Files.newDirectoryStream(pDir);
                    }
                    catch (IOException e2) {
                        OLogger.debug(e2.getMessage());
                    }
                    for (Path subDir : subDirs) {
                        if (!Files.isDirectory(subDir, new LinkOption[0])) continue;
                        al.add(subDir.toString());
                    }
                }
            }
            line = br.readLine();
        }
        patchLocs = new String[al.size()];
        al.toArray(patchLocs);
        return patchLocs;
    }

    static class filterFiles
    implements DirectoryStream.Filter<Path> {
        filterFiles() {
        }

        @Override
        public boolean accept(Path entry) {
            String name = entry.getFileName().toString();
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    }
}

