/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdkv2impl;

import java.nio.file.Path;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdkv2.IPatch;
import oracle.opatch.opatchsdkv2.ce.OperationConfiguration;
import oracle.opatch.opatchsdkv2impl.PatchPlanController;
import oracle.opatch.opatchsdkv2impl.PatchPlanStep;
import oracle.opatch.wrappers.WrapperFactory;

abstract class ReadWriteShadowHomeSession {
    private OperationConfiguration cfg = null;
    protected boolean isReuse = false;
    protected List<IPatch> patchList = null;
    protected OPatchContext context = null;
    protected OPatchTarget target = null;

    public ReadWriteShadowHomeSession(OperationConfiguration opCfg, List<IPatch> incomingPatch) {
        this.cfg = opCfg;
        this.patchList = incomingPatch;
    }

    void setup() {
        this.setupSdkSession();
        this.setupCas();
    }

    private void setupSdkSession() {
        try {
            if (this.isReuse) {
                return;
            }
            this.context = OPatchContext.getInstance((String)this.getSoh().toString(), (String)this.cfg.getInvPtr().toString());
            this.target = new OPatchTarget(this.context);
        }
        catch (OPatchException e2) {
            e2.printStackTrace();
        }
    }

    private void setupCas() {
        System.out.println("SetupCAS");
    }

    void teardown() {
        if (!this.isReuse) {
            try {
                OPatchContext.destroyContextReference();
                System.out.println("TODO Clear CAS");
            }
            catch (OPatchException e2) {
                e2.printStackTrace();
            }
        }
    }

    public void willReuse() {
        this.isReuse = true;
    }

    abstract void changeSOH(IPatch var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifySOH() {
        try {
            this.setup();
            for (IPatch p2 : this.patchList) {
                this.changeSOH(p2);
                PatchPlanStep step = new PatchPlanStep(this.getPatchSession(p2), null);
                PatchPlanController.INSTANCE.add(step);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.teardown();
        }
    }

    protected Path getSoh() {
        Path soh = WrapperFactory.getNioServiceWrapper().getPath(this.cfg.getOracleHomePath().toString() + "/../db_cas1", new String[0]);
        return soh;
    }

    protected String getPatchSession(IPatch p2) {
        return p2.getPatchId();
    }
}

