/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Properties;
import oracle.opatch.Applicable;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchmdXml;
import oracle.opatch.Rollbackable;
import oracle.opatch.opatchactions.sqlAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchutil.OPatchUtilHelper;

public class ApplyRollbackSql {
    private ApplyRollbackSql() {
    }

    protected static void applySql(String oracleHomePath) throws RuntimeException, Exception {
        int i2;
        int i3;
        StringBuffer buff = new StringBuffer("UTIL:ApplyRollbackSql.applySql()");
        OLogger.debug(buff);
        PrereqResult resObj = PrereqAPI.checkOracleHome(oracleHomePath);
        if (resObj.getResult() != PrereqResult.ExecuteStatus.PASSED) {
            throw new RuntimeException(resObj.toString());
        }
        String[] patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
        if (patchIDs == null || patchIDs.length == 0) {
            if (!OPatchEnv.isSqlScript()) {
                throw new RuntimeException("Please specify patch id(s) with '-id' option.");
            }
            try {
                OPatchACL.setRunSql(new ApplyRollbackSql(), true);
                ApplyRollbackSql.runCustomScript();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return;
        }
        boolean isOk = true;
        int skipCount = 0;
        ArrayList<PatchObject> refinedPatchObjects = new ArrayList<PatchObject>();
        Object sqlprocExecute = null;
        String msg = "";
        StringBuffer skipPatchBuff = new StringBuffer();
        PatchObject[] appliedObj = new PatchObject[patchIDs.length];
        for (int i4 = 0; i4 < patchIDs.length; ++i4) {
            try {
                appliedObj[i4] = PatchObject.getInstance(oracleHomePath, patchIDs[i4]);
            }
            catch (IllegalAccessException e3) {
                buff = new StringBuffer(e3.getMessage());
                buff.append("\n");
                buff.append("Unable to create patch object for id " + patchIDs[i4]);
                throw new RuntimeException(buff.toString(), e3);
            }
            catch (Exception e4) {
                buff = new StringBuffer(e4.getMessage());
                buff.append("\n");
                buff.append("Unable to create patch object for id " + patchIDs[i4]);
                throw new RuntimeException(buff.toString(), e4);
            }
            if (!appliedObj[i4].isSqlRelatedActions()) {
                ++skipCount;
                skipPatchBuff.append(patchIDs[i4]);
                skipPatchBuff.append(" ");
                continue;
            }
            refinedPatchObjects.add(appliedObj[i4]);
        }
        if (skipCount == patchIDs.length) {
            msg = OLogger.getString("OUI-67319");
            OLogger.println(msg);
        } else if (skipCount != 0) {
            msg = OLogger.getString("OUI-67313", new Object[]{skipPatchBuff.toString().trim()});
            OLogger.println(msg);
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        StringBuffer sidValue = new StringBuffer();
        for (int sidCount = 0; sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.append(sidArray[sidCount]);
            if (sidCount == sidArray.length - 1) continue;
            sidValue.append(",");
        }
        HashSet inputSet = ApplyRollbackSql.giveSet(sidValue.toString());
        boolean isFirstError = false;
        StringBuffer errorInfo = new StringBuffer();
        Properties pCheck = null;
        for (i3 = 0; i3 < refinedPatchObjects.size(); ++i3) {
            String appliedSid;
            boolean isSqlRun;
            PatchObject po = (PatchObject)refinedPatchObjects.get(i3);
            pCheck = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, po.getCookedPatchID());
            if (pCheck == null || !(isSqlRun = Boolean.valueOf(pCheck.getProperty("RUNSQL")).booleanValue()) || (appliedSid = pCheck.getProperty("SID")) == null || appliedSid.equals("")) continue;
            HashSet appliedSet = ApplyRollbackSql.giveSet(appliedSid);
            appliedSet.retainAll(inputSet);
            if (appliedSet.size() == 0) continue;
            if (!isFirstError) {
                errorInfo.append(OLogger.getString("OUI-67318"));
                errorInfo.append("\n");
                errorInfo.append("Input database instanc(es) are \"" + sidValue.toString() + "\".");
                errorInfo.append("\n\n");
                isFirstError = true;
            }
            errorInfo.append("Database instanc(es) patched by the patch " + po.getPatchID() + " are ");
            errorInfo.append("\"" + appliedSid + "\".");
            errorInfo.append("\n");
        }
        if (isFirstError) {
            if (OPatchEnv.isForce()) {
                OLogger.printlnOnLog(OLogger.INFO, errorInfo.toString());
            } else {
                throw new RuntimeException(errorInfo.toString());
            }
        }
        OPatchACL.setRunSql(new ApplyRollbackSql(), true);
        for (i3 = 0; i3 < refinedPatchObjects.size(); ++i3) {
            PatchObject backupRollbackPo = (PatchObject)refinedPatchObjects.get(i3);
            if (backupRollbackPo == null) {
                throw new RuntimeException("The patch object is null");
            }
            String patchID = backupRollbackPo.getPatchID();
            String cookedPatchID = backupRollbackPo.getCookedPatchID();
            String relativePatchLoc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
            OPatchACL.setPatchLocation(new ApplyRollbackSql(), relativePatchLoc);
            msg = OLogger.getString("OUI-67315", new Object[]{patchID});
            OLogger.println(msg);
            ListIterator iter = backupRollbackPo.getAllDelayedPluginActions();
            if (iter == null) {
                throw new RuntimeException("Unable to get plugin actions for the patch : " + patchID);
            }
            while (iter.hasNext()) {
                PatchAction pa = (PatchAction)iter.next();
                if (!(pa instanceof sqlprocAction)) continue;
                sqlprocAction spa = (sqlprocAction)pa;
                spa.constructApplyRestoreRollbackBackupSQL(oracleHomePath, cookedPatchID);
                spa.backupForRollback(oracleHomePath, cookedPatchID);
            }
        }
        StringBuffer errorBuff = new StringBuffer();
        boolean errorFlag = false;
        boolean globalError = false;
        OLogger.println("");
        for (i2 = 0; i2 < refinedPatchObjects.size(); ++i2) {
            String inSid;
            boolean isRunSql;
            String runSql;
            PatchObject applyPo = (PatchObject)refinedPatchObjects.get(i2);
            if (applyPo == null) {
                throw new RuntimeException("The patch object is null");
            }
            String patchID = applyPo.getPatchID();
            String cookedPatchID = applyPo.getCookedPatchID();
            String relativePatchLoc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
            msg = OLogger.getString("OUI-67316", new Object[]{patchID});
            OLogger.println(msg);
            ListIterator iter = applyPo.getAllDelayedPluginActions();
            if (iter == null) {
                throw new RuntimeException("Unable to get plugin actions for the patch : " + patchID);
            }
            while (iter.hasNext()) {
                PatchAction pa = (PatchAction)iter.next();
                if (!(pa instanceof sqlAction) && !(pa instanceof sqlprocAction) || !(pa instanceof Applicable)) continue;
                Applicable aa = (Applicable)((Object)pa);
                buff = new StringBuffer();
                buff.append(aa.getApplyDescription(oracleHomePath));
                msg = OLogger.getString("OUI-67124", new Object[]{buff.toString()});
                OLogger.log(OLogger.FINE, msg);
                try {
                    aa.apply(oracleHomePath, relativePatchLoc);
                }
                catch (RuntimeException e5) {
                    pa.setApplyFailed();
                    errorBuff.append(e5.getMessage());
                    errorBuff.append("\n");
                    errorFlag = true;
                    globalError = true;
                }
            }
            if (errorFlag) {
                OLogger.println("\nThe following actions have failed:");
                OLogger.info("OUI-67124", new Object[]{errorBuff.toString()});
                OLogger.println("");
                errorFlag = false;
                errorBuff = new StringBuffer();
                continue;
            }
            if (!applyPo.isSqlRelatedActions()) continue;
            Properties inProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
            if (inProp != null && (runSql = inProp.getProperty("RUNSQL")) != null && !runSql.equals("") && (isRunSql = Boolean.valueOf(runSql).booleanValue()) && (inSid = inProp.getProperty("SID")) != null && !inSid.equals("")) {
                int j2;
                ArrayList<String> combineSid = new ArrayList<String>();
                String[] s1 = inSid.split(",");
                String[] s2 = sidValue.toString().split(",");
                sidValue = new StringBuffer();
                for (j2 = 0; j2 < s1.length; ++j2) {
                    if (combineSid.contains(s1[j2])) continue;
                    combineSid.add(s1[j2]);
                    sidValue.append(s1[j2]);
                    if (j2 == s1.length - 1) continue;
                    sidValue.append(",");
                }
                for (j2 = 0; j2 < s2.length; ++j2) {
                    if (combineSid.contains(s2[j2])) continue;
                    sidValue.append(",");
                    combineSid.add(s2[j2]);
                    sidValue.append(s2[j2]);
                }
            }
            Properties prop = new Properties();
            prop.setProperty("RUNSQL", "true");
            prop.setProperty("SID", sidValue.toString());
            OPatchEnv.setupSqlPropertyFile(oracleHomePath, cookedPatchID);
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, cookedPatchID);
        }
        if (globalError) {
            throw new RuntimeException("OPatch util \"applySql\" has failed to apply some or all sql, sql procedure actions.");
        }
        for (i2 = 0; i2 < patchIDs.length; ++i2) {
            PatchObject po = PatchObject.getInstance(oracleHomePath, patchIDs[i2]);
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, po.getCookedPatchID());
            ApplyRollbackSql.runPatchmdXmlScript(patchIDs[i2], oracleHomePath, true, originalPatchLoc, po.getAllIncludedCopyActions(), po.getPatchInventory().isSqlMigrate());
        }
        try {
            ApplyRollbackSql.runCustomScript();
        }
        catch (RuntimeException e6) {
            // empty catch block
        }
    }

    protected static void rollbackSql(String oracleHomePath) throws RuntimeException, Exception {
        int i2;
        StringBuffer buff = new StringBuffer("ApplyRollbackSql::rollbackSql()");
        OLogger.debug(buff);
        PatchObject[] rpo = null;
        PatchObject singlePatch = null;
        try {
            rpo = OPatchUtilHelper.getPatchesToRollbackSql(oracleHomePath);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            OLogger.printlnOnLog(OLogger.FINE, e2.getMessage());
        }
        if (rpo == null || rpo.length == 0) {
            String patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc == null || patchLoc.equals("")) {
                if (!OPatchEnv.isSqlScript()) {
                    throw new RuntimeException("No patch location(s) specified to rollback");
                }
                try {
                    OPatchACL.setRunSql(new ApplyRollbackSql(), true);
                    ApplyRollbackSql.runCustomScript();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                return;
            }
            try {
                singlePatch = PatchObject.getInstance(patchLoc);
                rpo = new PatchObject[]{singlePatch};
            }
            catch (IllegalAccessException e4) {
                OLogger.printStackTrace(e4);
                OLogger.printlnOnLog(OLogger.FINE, e4.getMessage());
                throw new RuntimeException("Unable to create patch object(s)");
            }
            catch (Exception e5) {
                OLogger.printStackTrace(e5);
                OLogger.printlnOnLog(OLogger.FINE, e5.getMessage());
                throw new RuntimeException("Unable to create patch object(s)");
            }
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        HashSet<String> sidValue = new HashSet<String>();
        for (int sidCount = 0; sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.add(sidArray[sidCount]);
        }
        for (int i3 = 0; i3 < rpo.length; ++i3) {
            PrereqResult resObj;
            if (!rpo[i3].isSqlRelatedActions() || (resObj = PrereqAPI.checkRollbackSid(oracleHomePath, rpo[i3], sidValue, true)).getResult() == PrereqResult.ExecuteStatus.PASSED) continue;
            throw new RuntimeException(resObj.toString());
        }
        int skipCount = 0;
        ArrayList<PatchObject> refinedRollback = new ArrayList<PatchObject>();
        String msg = "";
        StringBuffer skipPatchBuff = new StringBuffer();
        for (int i4 = 0; i4 < rpo.length; ++i4) {
            if (!rpo[i4].isSqlRelatedActions()) {
                ++skipCount;
                skipPatchBuff.append(rpo[i4].getPatchID());
                skipPatchBuff.append(" ");
                continue;
            }
            refinedRollback.add(rpo[i4]);
        }
        if (skipCount == rpo.length) {
            msg = OLogger.getString("OUI-67319");
            OLogger.println(msg);
        } else if (skipCount != 0) {
            msg = OLogger.getString("OUI-67313", new Object[]{skipPatchBuff.toString().trim()});
            OLogger.println(msg);
        }
        OPatchACL.setRunSql(new ApplyRollbackSql(), true);
        StringBuffer errorBuff = new StringBuffer();
        boolean errorFlag = false;
        boolean globalError = false;
        for (i2 = 0; i2 < refinedRollback.size(); ++i2) {
            PatchObject rb = (PatchObject)refinedRollback.get(i2);
            if (rb == null) {
                throw new RuntimeException("The patch object is null");
            }
            String patchID = rb.getPatchID();
            String cookedPatchID = rb.getCookedPatchID();
            msg = OLogger.getString("OUI-67317", new Object[]{patchID});
            OLogger.println(msg);
            ListIterator iter = rb.getAllDelayedPluginActions();
            if (iter == null) {
                throw new RuntimeException("Unable to get plugin actions for the patch : " + patchID);
            }
            while (iter.hasNext()) {
                PatchAction pa = (PatchAction)iter.next();
                if (!(pa instanceof sqlAction) && !(pa instanceof sqlprocAction) || !(pa instanceof Rollbackable)) continue;
                Rollbackable roll = (Rollbackable)((Object)pa);
                buff = new StringBuffer();
                buff.append(roll.getRollbackDescription(oracleHomePath));
                msg = OLogger.getString("OUI-67124", new Object[]{buff.toString()});
                OLogger.log(OLogger.FINE, msg);
                try {
                    roll.rollback(oracleHomePath, cookedPatchID);
                }
                catch (RuntimeException e6) {
                    pa.setRollbackFailed();
                    errorBuff.append(e6.getMessage());
                    errorBuff.append("\n");
                    errorFlag = true;
                }
            }
            if (errorFlag) {
                OLogger.println("\nThe following actions have failed:");
                OLogger.info("OUI-67124", new Object[]{errorBuff.toString()});
                OLogger.println("");
                errorFlag = false;
                globalError = true;
                errorBuff = new StringBuffer();
                continue;
            }
            if (!rb.isSqlRelatedActions()) continue;
            OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, rb.getCookedPatchID());
        }
        if (globalError) {
            throw new RuntimeException("OPatch util \"rollbackSql\" has failed to rollback some or all sql, sql procedure actions.");
        }
        for (i2 = 0; i2 < rpo.length; ++i2) {
            ApplyRollbackSql.runPatchmdXmlScript(rpo[i2].getPatchID(), oracleHomePath, false, rpo[i2].getPatchLocation(), rpo[i2].getAllIncludedCopyActions(), rpo[i2].getPatchInventory().isSqlMigrate());
        }
        try {
            ApplyRollbackSql.runCustomScript();
        }
        catch (RuntimeException e7) {
            // empty catch block
        }
    }

    private static void runPatchmdXmlScript(String patchID, String oracleHomePath, boolean apply, String patchLocation, ListIterator copy, boolean sqlMigrate) {
        String mode = "";
        mode = apply ? "apply" : "rollback";
        PatchmdXml sqlObj = new PatchmdXml(oracleHomePath, patchLocation, apply, copy, patchID);
        String sqlPath = sqlObj.getSqlPath();
        if (sqlPath != null && !sqlPath.equals("") && OPatchEnv.isRunSql()) {
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{mode, sqlPath, patchID}));
                OPatchSessionHelper.runSqlScript(sqlPath, sqlMigrate);
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                OLogger.printlnOnLog(OLogger.INFO, e2.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{mode, sqlPath, patchID}));
            }
        }
    }

    private static void runCustomScript() throws RuntimeException {
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            OLogger.printlnOnLog(OLogger.INFO, e2.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
            throw e2;
        }
    }

    private static HashSet giveSet(String in) {
        String[] sidValue = in.split(",");
        HashSet<String> setObj = new HashSet<String>();
        for (int i2 = 0; i2 < sidValue.length; ++i2) {
            setObj.add(sidValue[i2]);
        }
        return setObj;
    }
}

