/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.ClassPathAdder;
import oracle.opatch.wrappers.WrapperFactory;

public final class CasClasspathLoader {
    StringBuffer casDLMsg = new StringBuffer("");
    Path opatchJlibPath;

    public boolean isCASEnableHome() throws Exception {
        this.opatchJlibPath = this.getOPatchJlibPath();
        this.casDLMsg.append("\nCasClasspathLoader: Opatch path to be searched for cas jars :" + this.opatchJlibPath.toString());
        OLogger.printlnOnLog("CasClasspathLoader: Opatch path to be searched for cas jars :" + this.opatchJlibPath.toString());
        MyFilenameFilter filter = new MyFilenameFilter("content-store-");
        String[] flist = this.opatchJlibPath.toFile().list(filter);
        OLogger.printlnOnLog("CasClasspathLoader:Number of content-store* list:" + flist.length);
        if (flist.length != 0) {
            this.casDLMsg.append("\nCasClasspathLoader : CAS Enabled Home");
            OLogger.printlnOnLog("CasClasspathLoader : CAS Enabled Home");
            return true;
        }
        this.casDLMsg.append("\nCasClasspathLoader : Non CAS based Home");
        OLogger.printlnOnLog("CasClasspathLoader : Non CAS based Home");
        return false;
    }

    public void loadCasJars() throws Exception {
        Path casJarsLoc;
        String casClassPathJarLoc = "";
        Path opatchJlib = this.getOPatchJlibPath();
        Path casAplmPath = WrapperFactory.getNioServiceWrapper().getPath(this.getAplmPath(opatchJlib), new String[0]);
        if (Files.exists(casAplmPath, new LinkOption[0])) {
            this.casDLMsg.append("\nCasClasspathLoader:APLM path exists: " + casAplmPath);
            OLogger.printlnOnLog("CasClasspathLoader:APLM path exists: " + casAplmPath);
            casJarsLoc = casAplmPath;
            casClassPathJarLoc = this.getCASClassPathJar(casAplmPath);
        } else {
            this.casDLMsg.append("\nCasClasspathLoader:  OPatch jlib Path: " + opatchJlib);
            OLogger.printlnOnLog("CasClasspathLoader: OPatch jlib Path: " + opatchJlib);
            casJarsLoc = opatchJlib;
            casClassPathJarLoc = this.getCASClassPathJar(opatchJlib);
        }
        if (casClassPathJarLoc == null || casClassPathJarLoc == "") {
            this.loadCasJarsFromLib(casJarsLoc);
        } else {
            this.loadJarFromCasClassPath(casClassPathJarLoc);
        }
    }

    private void loadCasJarsFromLib(Path casJarsPath) throws Exception {
        String casJarLoc = "";
        this.casDLMsg.append("\nCasClasspathLoader: loadCasJarsFromLib : Loading jars from: " + casJarsPath.toString());
        OLogger.printlnOnLog("CasClasspathLoader: loadCasJarsFromLib : Loading jars from: " + casJarsPath.toString());
        JarFilesFilter filter1 = new JarFilesFilter(".jar");
        String[] jarList = casJarsPath.toFile().list(filter1);
        if (jarList.length != 0) {
            for (String s : jarList) {
                if (s.contains("opatch")) continue;
                casJarLoc = casJarsPath + File.separator + s;
                this.casDLMsg.append("\nCasClasspathLoader: Loading jar : " + casJarLoc);
                OLogger.printlnOnLog("\nCasClasspathLoader: Loading jar : " + casJarLoc);
                ClassPathAdder.add(NioServiceFactory.getNioService().getPath(casJarLoc, new String[0]));
            }
        } else {
            this.casDLMsg.append("\nERROR: cas jars do not exist at :" + casJarsPath);
            OLogger.printlnOnLog("\nERROR: cas jars do not exist at :" + casJarsPath);
            throw new Exception("\nERROR: cas jars do not exist at :" + casJarsPath);
        }
    }

    private void loadJarFromCasClassPath(String casClasspathJarLoc) throws Exception {
        try {
            this.casDLMsg.append("\nCasClasspathLoader: casClasspathJarLoc : " + casClasspathJarLoc);
            OLogger.printlnOnLog("CasClasspathLoader: casClasspathJarLoc : " + casClasspathJarLoc);
            ClassPathAdder.add(WrapperFactory.getNioServiceWrapper().getPath(casClasspathJarLoc, new String[0]));
        }
        catch (Exception e2) {
            this.casDLMsg.append("\nERROR: Exception while loading CasClassPath :" + casClasspathJarLoc);
            OLogger.printlnOnLog("ERROR: Exception while loading CasClassPath :" + casClasspathJarLoc);
            throw new Exception("ERROR: Exception while loading CasClassPath :" + casClasspathJarLoc, e2);
        }
    }

    private String getCASClassPathJar(Path casClassPathLoc) {
        String casClasspathJarLoc = "";
        this.casDLMsg.append("\nCasClasspathLoader: casClassPathJarExists -> Directory to be searched :\n" + casClassPathLoc.toString());
        OLogger.printlnOnLog("CasClasspathLoader: casClassPathJarExists -> Directory to be searched :\n" + casClassPathLoc.toString());
        MyFilenameFilter filter = new MyFilenameFilter("cas-classpath");
        String[] flist = casClassPathLoc.toFile().list(filter);
        if (flist.length != 0) {
            casClasspathJarLoc = casClassPathLoc + File.separator + flist[0];
            this.casDLMsg.append("\nCasClasspathLoader:casClasspathJarLoc:" + casClasspathJarLoc);
            OLogger.printlnOnLog("CasClasspathLoader:casClasspathJarLoc:" + casClasspathJarLoc);
        } else {
            this.casDLMsg.append("\nCasClasspathLoader: Could not find cas classpath jar");
            OLogger.printlnOnLog("CasClasspathLoader: Could not find cas classpath jar");
        }
        return casClasspathJarLoc;
    }

    public String getDebugMsg() {
        return this.casDLMsg.toString();
    }

    private Path getOPatchJlibPath() throws IOException {
        if (this.opatchJlibPath != null && Files.exists(this.opatchJlibPath, new LinkOption[0])) {
            return this.opatchJlibPath;
        }
        this.opatchJlibPath = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOPatchHome(), "jlib");
        return this.opatchJlibPath;
    }

    private String getAplmPath(Path opatchPath) {
        if (opatchPath.toString().contains("_target_predowntime")) {
            return StringResource.CAS_APLM_TARGET_PREDOWNTIME_PATH;
        }
        return StringResource.CAS_APLM_PATH;
    }

    class JarFilesFilter
    implements FilenameFilter {
        String initials;

        public JarFilesFilter(String initials) {
            this.initials = initials;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.initials);
        }
    }

    class MyFilenameFilter
    implements FilenameFilter {
        String initials;

        public MyFilenameFilter(String initials) {
            this.initials = initials;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.initials);
        }
    }
}

