/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchlevel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchlevel.PatchLevelRelation;

public class CheckPatchLevel {
    Collection<IPatch> pis = null;
    Collection<IPatch> pohs = null;

    public CheckPatchLevel(Collection<IPatch> pis, Collection<IPatch> pohs) {
        this.pis = pis;
        this.pohs = pohs;
    }

    public void checkBetweenPi() {
        if (this.pis == null) {
            return;
        }
        ArrayList<OneOffEntry> piPLOs = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> piCUPs = new ArrayList<OneOffEntry>();
        for (IPatch e2 : this.pis) {
            if (e2.getOneOffEntry().getSubType().equalsIgnoreCase("upgrade")) {
                piCUPs.add(e2.getOneOffEntry());
            }
            if (!e2.getOneOffEntry().getSubType().equalsIgnoreCase("update")) continue;
            piPLOs.add(e2.getOneOffEntry());
        }
        for (OneOffEntry piCUP : piCUPs) {
            ArrayList<PatchComponent> matchedCUPComponents;
            for (OneOffEntry piPLO : piPLOs) {
                ArrayList<PatchComponent> matchedPLOComponents;
                if (!this.isComponentSubset(piPLO, piCUP, matchedPLOComponents = new ArrayList<PatchComponent>(), matchedCUPComponents = new ArrayList<PatchComponent>()) || !this.isTheSameComponentPatchLevel(matchedPLOComponents, matchedCUPComponents)) continue;
                piPLO.addOverlayPatchIDs(new String[]{piCUP.getPatchID()});
                piPLO.addPrereqPatchIDs(new String[]{piCUP.getPatchID()});
                OLogger.printlnOnLog("CUP_LOG: Found pi PLO " + piPLO.getPatchID() + " implicitly overlays pi CUP: " + piCUP.getPatchID());
            }
            for (OneOffEntry piCUP1 : piCUPs) {
                ArrayList<PatchComponent> matchedCUP1Components;
                if (piCUP1 == piCUP || !this.isComponentSubset(piCUP, piCUP1, matchedCUPComponents = new ArrayList(), matchedCUP1Components = new ArrayList<PatchComponent>()) || !this.isTheSameorLessComponentPatchLevel(matchedCUPComponents, matchedCUP1Components)) continue;
                piCUP1.setSubsetPatchID(piCUP.getPatchID());
                piCUP.setSupersetPatchID(piCUP1.getPatchID());
                OLogger.printlnOnLog("CUP_LOG: Found pi CUP " + piCUP1.getPatchID() + " is superset of pi CUP: " + piCUP.getPatchID());
            }
        }
    }

    public void checkBetweenPoh() {
        if (this.pohs == null) {
            return;
        }
        ArrayList<OneOffEntry> pohPLOs = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> pohCUPs = new ArrayList<OneOffEntry>();
        for (IPatch e2 : this.pohs) {
            if (e2.getOneOffEntry().getSubType().equalsIgnoreCase("upgrade")) {
                pohCUPs.add(e2.getOneOffEntry());
            }
            if (!e2.getOneOffEntry().getSubType().equalsIgnoreCase("update")) continue;
            pohPLOs.add(e2.getOneOffEntry());
        }
        for (OneOffEntry pohCUP1 : pohCUPs) {
            for (OneOffEntry pohCUP2 : pohCUPs) {
                ArrayList<PatchComponent> matchedCUP2Components;
                ArrayList<PatchComponent> matchedCUP1Components;
                if (pohCUP1 == pohCUP2 || !this.isComponentSubset(pohCUP1, pohCUP2, matchedCUP1Components = new ArrayList<PatchComponent>(), matchedCUP2Components = new ArrayList<PatchComponent>())) continue;
                if (matchedCUP1Components.size() == pohCUP2.getIncludedPatchComponents().length) {
                    if (!this.isTheSameComponentPatchLevel(matchedCUP1Components, matchedCUP2Components)) continue;
                    long r = this.compareUPI(pohCUP1.getPSENumber(), pohCUP2.getPSENumber());
                    if (r > 0L) {
                        pohCUP2.setSupersetPatchID(pohCUP1.getPatchID());
                        pohCUP1.setSubsetPatchID(pohCUP2.getPatchID());
                        OLogger.printlnOnLog("CUP_LOG: Found poh CUP " + pohCUP2.getPatchID() + " is a subset of other poh CUP: " + pohCUP1.getPatchID());
                        continue;
                    }
                    if (r >= 0L) continue;
                    pohCUP1.setSupersetPatchID(pohCUP2.getPatchID());
                    pohCUP2.setSubsetPatchID(pohCUP1.getPatchID());
                    OLogger.printlnOnLog("CUP_LOG: Found poh CUP " + pohCUP1.getPatchID() + " is a subset of other poh CUP: " + pohCUP2.getPatchID());
                    continue;
                }
                if (!this.isTheSameorLessComponentPatchLevel(matchedCUP1Components, matchedCUP2Components)) continue;
                pohCUP1.setSupersetPatchID(pohCUP2.getPatchID());
                pohCUP2.setSubsetPatchID(pohCUP1.getPatchID());
                OLogger.printlnOnLog("CUP_LOG: Found poh CUP " + pohCUP1.getPatchID() + " is a subset of other poh CUP: " + pohCUP2.getPatchID());
            }
            for (OneOffEntry pohPLO : pohPLOs) {
                ArrayList<PatchComponent> matchedCUPComponents;
                ArrayList<PatchComponent> matchedPLOComponents;
                if (!this.isComponentSubset(pohPLO, pohCUP1, matchedPLOComponents = new ArrayList<PatchComponent>(), matchedCUPComponents = new ArrayList<PatchComponent>()) || !this.isTheSameComponentPatchLevel(matchedPLOComponents, matchedCUPComponents)) continue;
                pohPLO.addOverlayPatchIDs(new String[]{pohCUP1.getPatchID()});
                pohPLO.addPrereqPatchIDs(new String[]{pohCUP1.getPatchID()});
                OLogger.printlnOnLog("CUP_LOG: Found poh PLO " + pohPLO.getPatchID() + " implicitly overlays poh CUP: " + pohCUP1.getPatchID());
            }
        }
    }

    private long compareUPI(String upi1, String upi2) {
        String s1 = upi1 == null ? "" : upi1.trim();
        String s2 = upi2 == null ? "" : upi2.trim();
        long u1 = Long.parseLong(upi1);
        long u2 = Long.parseLong(upi2);
        if (u1 < 0L && u2 < 0L) {
            u1 *= -1L;
            u2 *= -1L;
        }
        return u1 - u2;
    }

    public void checkBetweenPiAndPoh() {
        if (this.pis == null || this.pohs == null) {
            return;
        }
        ArrayList<OneOffEntry> piCUPs = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> piPLOs = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> pohCUPs = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> pohPLOs = new ArrayList<OneOffEntry>();
        for (IPatch e2 : this.pis) {
            if (e2.getOneOffEntry().getSubType().equalsIgnoreCase("upgrade")) {
                piCUPs.add(e2.getOneOffEntry());
            }
            if (!e2.getOneOffEntry().getSubType().equalsIgnoreCase("update")) continue;
            piPLOs.add(e2.getOneOffEntry());
        }
        for (IPatch e2 : this.pohs) {
            if (e2.getOneOffEntry().getSubType().equalsIgnoreCase("upgrade")) {
                pohCUPs.add(e2.getOneOffEntry());
            }
            if (!e2.getOneOffEntry().getSubType().equalsIgnoreCase("update")) continue;
            pohPLOs.add(e2.getOneOffEntry());
        }
        for (OneOffEntry pohCUP : pohCUPs) {
            ArrayList<PatchComponent> matchedPohCUPComponents;
            for (OneOffEntry piCUP : piCUPs) {
                ArrayList<PatchComponent> matchedPiCUPComponents;
                if (this.isComponentSubset(pohCUP, piCUP, matchedPohCUPComponents = new ArrayList<PatchComponent>(), matchedPiCUPComponents = new ArrayList<PatchComponent>()) && this.isTheSameorLessComponentPatchLevel(matchedPohCUPComponents, matchedPiCUPComponents)) {
                    pohCUP.setSupersetPatchID(piCUP.getPatchID());
                    piCUP.setSubsetPatchID(pohCUP.getPatchID());
                    OLogger.printlnOnLog("CUP_LOG: Found pi CUP " + piCUP.getPatchID() + " is a superset of  poh CUP: " + pohCUP.getPatchID());
                }
                if (!this.isComponentSubset(piCUP, pohCUP, matchedPiCUPComponents, matchedPohCUPComponents) || !this.isTheSameorLessComponentPatchLevel(matchedPiCUPComponents, matchedPohCUPComponents)) continue;
                piCUP.setSupersetPatchID(pohCUP.getPatchID());
                pohCUP.setSubsetPatchID(piCUP.getPatchID());
                OLogger.printlnOnLog("CUP_LOG: Found pi CUP " + piCUP.getPatchID() + " is a subset of  poh CUP: " + pohCUP.getPatchID());
            }
            for (OneOffEntry piPLO : piPLOs) {
                ArrayList<PatchComponent> matchedPiPLOComponents;
                if (!this.isComponentSubset(piPLO, pohCUP, matchedPiPLOComponents = new ArrayList<PatchComponent>(), matchedPohCUPComponents = new ArrayList()) || !this.isTheSameComponentPatchLevel(matchedPiPLOComponents, matchedPohCUPComponents) || !this.canPiPLOoverlayPohCUP(piPLO, pohCUP, piCUPs)) continue;
                piPLO.addOverlayPatchIDs(new String[]{pohCUP.getPatchID()});
                piPLO.addPrereqPatchIDs(new String[]{pohCUP.getPatchID()});
                OLogger.printlnOnLog("CUP_LOG: Found pi PLO " + piPLO.getPatchID() + " implicitly overlays poh CUP: " + pohCUP.getPatchID());
            }
        }
        for (OneOffEntry piCUP : piCUPs) {
            for (OneOffEntry pohPLO : pohPLOs) {
                ArrayList<PatchComponent> matchedPiCUPComponents;
                ArrayList<PatchComponent> matchedPohPLOComponents;
                if (!this.isComponentSubset(pohPLO, piCUP, matchedPohPLOComponents = new ArrayList<PatchComponent>(), matchedPiCUPComponents = new ArrayList<PatchComponent>()) || !this.isTheSameComponentPatchLevel(matchedPohPLOComponents, matchedPiCUPComponents)) continue;
                pohPLO.setAutoRollback(true);
            }
        }
    }

    private boolean canPiPLOoverlayPohCUP(OneOffEntry piPLO, OneOffEntry pohCUP, List<OneOffEntry> piCUPs) {
        HashSet<String> piSupersets = pohCUP.getSupersetPatchIDs();
        for (OneOffEntry piCUP : piCUPs) {
            String piCUPid = piCUP.getPatchID();
            if (!piSupersets.contains(piCUPid) || !piPLO.isOverlay(piCUPid)) continue;
            return false;
        }
        return true;
    }

    private boolean isComponentSubset(OneOffEntry subset, OneOffEntry superSet, List<PatchComponent> matchedInSubComponents, List<PatchComponent> matchedinSuperComponents) {
        boolean result = true;
        PatchComponent[] subComps = subset.getIncludedPatchComponents();
        PatchComponent[] superComps = superSet.getIncludedPatchComponents();
        for (PatchComponent cSub : subComps) {
            boolean matched = false;
            for (PatchComponent cSuper : superComps) {
                if (!cSub.getName().equalsIgnoreCase(cSuper.getName()) || !cSub.getVersion().equalsIgnoreCase(cSuper.getVersion())) continue;
                matched = true;
                matchedInSubComponents.add(cSub);
                matchedinSuperComponents.add(cSuper);
                break;
            }
            if (matched) continue;
            result = false;
        }
        return result;
    }

    private boolean isTheSameComponentPatchLevel(List<PatchComponent> matchedSubComponents, List<PatchComponent> matchedSuperComponents) {
        boolean result = true;
        int n2 = matchedSubComponents.size();
        for (int i2 = 0; i2 < matchedSubComponents.size(); ++i2) {
            PatchComponent cSub = matchedSubComponents.get(i2);
            PatchComponent cSuper = matchedSuperComponents.get(i2);
            if (cSub.getPatchLevelObj() != null && cSuper.getPatchLevelObj() != null && cSub.getPatchLevelObj().compare(cSuper.getPatchLevelObj()) == PatchLevelRelation.SAME) continue;
            result = false;
        }
        return result;
    }

    private boolean isTheSameorLessComponentPatchLevel(List<PatchComponent> matchedSubComponents, List<PatchComponent> matchedSuperComponents) {
        boolean result = true;
        for (int i2 = 0; i2 < matchedSubComponents.size(); ++i2) {
            PatchComponent cSub = matchedSubComponents.get(i2);
            PatchComponent cSuper = matchedSuperComponents.get(i2);
            if (cSub.getPatchLevelObj() != null && cSuper.getPatchLevelObj() != null && (cSub.getPatchLevelObj().compare(cSuper.getPatchLevelObj()) == PatchLevelRelation.SAME || cSub.getPatchLevelObj().compare(cSuper.getPatchLevelObj()) == PatchLevelRelation.LOWER)) continue;
            result = false;
        }
        return result;
    }

    public static void printConflictMap(ConflictMap map) {
        HashMap<IPatch, NPatchRelations> rm = map.getRelationsMap();
        Set<IPatch> keyset = rm.keySet();
        for (IPatch p2 : keyset) {
            NPatchRelations relations = rm.get(p2);
            CheckPatchLevel.printRelations(relations);
        }
    }

    private static void printRelations(NPatchRelations relations) {
        CheckPatchLevel.printRelation(relations.getSubsets());
        CheckPatchLevel.printRelation(relations.getBetters());
        CheckPatchLevel.printRelation(relations.getConflicts());
        CheckPatchLevel.printRelation(relations.getDuplicates());
        CheckPatchLevel.printRelation(relations.getSingleConflicts());
        CheckPatchLevel.printRelation(relations.getSingleSubsets());
        CheckPatchLevel.printRelation(relations.getSingleSupersets());
        CheckPatchLevel.printRelation(relations.getSubsets());
    }

    private static void printRelation(Collection<NPatchRelation> colRel) {
        for (NPatchRelation p2 : colRel) {
            System.out.println("From: " + p2.from().getPatchId() + " to:" + p2.to().getPatchId() + " relation: " + p2.getDef().getDescription());
        }
    }
}

