/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchlevel;

import oracle.opatch.patchlevel.AbstractPatchLevel;
import oracle.opatch.patchlevel.PatchLevel;
import oracle.opatch.patchlevel.PatchLevelRelation;

public class TwoDigitPatchLevel
extends AbstractPatchLevel {
    public TwoDigitPatchLevel(int[] digits) {
        this.digits = digits;
    }

    @Override
    public PatchLevelRelation compare(PatchLevel other) {
        if (other == null) {
            return PatchLevelRelation.HIGHER;
        }
        if (other.getType() == 2) {
            return this.compareAgainst2(other);
        }
        if (other.getType() == 3) {
            return this.compareAgainst3(other);
        }
        if (other.getType() == 4) {
            return this.compareAgainst4(other);
        }
        return PatchLevelRelation.INVALID;
    }

    protected PatchLevelRelation compareAgainst4(PatchLevel other) {
        int[] digits2 = this.digits;
        int[] digits4 = other.getValues();
        if (digits2[0] < digits4[0]) {
            return PatchLevelRelation.LOWER;
        }
        if (digits2[0] > digits4[0]) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits2[1] == 0) {
            return PatchLevelRelation.LOWER;
        }
        return PatchLevelRelation.DIFFERENT_BRANCH;
    }

    protected PatchLevelRelation compareAgainst2(PatchLevel other) {
        int[] digits2 = this.digits;
        int[] otherDigits2 = other.getValues();
        if (digits2[0] > otherDigits2[0]) {
            return PatchLevelRelation.HIGHER;
        }
        if (digits2[0] < otherDigits2[0]) {
            return PatchLevelRelation.LOWER;
        }
        if (digits2[1] > otherDigits2[1]) {
            return PatchLevelRelation.HIGHER;
        }
        if (digits2[1] == otherDigits2[1]) {
            return PatchLevelRelation.SAME;
        }
        return PatchLevelRelation.LOWER;
    }

    protected PatchLevelRelation compareAgainst3(PatchLevel other) {
        int[] digits2 = this.digits;
        int[] digits3 = other.getValues();
        if (digits2[0] > digits3[0]) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (this.digits[0] < digits3[0]) {
            return PatchLevelRelation.LOWER;
        }
        if (digits3[2] == 0) {
            if (digits2[1] == 0) {
                return PatchLevelRelation.LOWER;
            }
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits2[1] <= digits3[1]) {
            return PatchLevelRelation.LOWER;
        }
        return PatchLevelRelation.DIFFERENT_BRANCH;
    }

    @Override
    public String getReleaseType() {
        if (this.digits[1] != 0) {
            return "RUI";
        }
        return "RU";
    }
}

