/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.patchsdk.OPatchBundlePatch;
import oracle.opatch.patchsdk.OPatchCompositePatch;
import oracle.opatch.patchsdk.OPatchCompositePatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchGIBundleXML;
import oracle.opatch.patchsdk.OPatchGIBundleXmlHelper;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.ZipStringResource;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.PatchBundle;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchBundlePatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(OPatchBundlePatchValidatorAndGenerator.class.getName());

    @Override
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
        if (!Files.exists(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!Files.isDirectory(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        Path bxml = WrapperFactory.getNioServiceWrapper().getPath(bundleXMLLoc.toString(), new String[0]);
        if (!Files.exists(bxml, new LinkOption[0])) {
            logger.log(Level.INFO, "Bundle.xml does not exist");
            return false;
        }
        if (!Files.isRegularFile(bxml, new LinkOption[0])) {
            throw new PatchPackageException("Bundle.xml exists at location " + bxml.toAbsolutePath().toString() + " but is not a file");
        }
        OPatchGIBundleXML gibxml = null;
        OPatchGIBundleXmlHelper gibhxml = new OPatchGIBundleXmlHelper();
        try {
            InputStream in = Files.newInputStream(bxml, new OpenOption[0]);
            gibxml = gibhxml.readBundle(this.getContent(in).toString());
        }
        catch (IOException e2) {
            throw new PatchPackageException("Exception while reading the input stream.", e2);
        }
        catch (BundleXmlException e3) {
            throw new PatchPackageException("Exception occured while trying to read the bundle.xml", e3);
        }
        catch (BundleValidationException e4) {
            logger.log(Level.INFO, "Exception while making the OPatchGIBundleXML object. This might implythat the bundle.xml is of the new format corresponding to the EngineeredSystemPatch");
            return false;
        }
        if ((gibxml.getPatchesOrder() == null || gibxml.getPatchesOrder().isEmpty()) && (gibxml.getPatchToTargetList() == null || gibxml.getPatchToTargetList().isEmpty())) {
            logger.log(Level.FINE, "Couldn't get the list of patches and order of patches from the bundle.xml");
            return false;
        }
        return true;
    }

    @Override
    public boolean isPatchValid(Map map) throws PatchPackageException {
        assert (!map.isEmpty());
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        if (bundleXMLArray.length == 0) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
            return false;
        }
        ByteArrayInputStream bundleXML = new ByteArrayInputStream((byte[])bundleXMLArray[1]);
        OPatchGIBundleXML gibxml = null;
        OPatchGIBundleXmlHelper gibhxml = new OPatchGIBundleXmlHelper();
        try {
            gibxml = gibhxml.readBundle(this.getContent(bundleXML).toString());
        }
        catch (IOException e2) {
            throw new PatchPackageException("Exception while reading the input stream.", e2);
        }
        catch (BundleXmlException e3) {
            throw new PatchPackageException("Exception occured while trying to read the bundle.xml", e3);
        }
        catch (BundleValidationException e4) {
            logger.log(Level.INFO, "Exception while making the OPatchGIBundleXML object. This might implythat the bundle.xml is of the new format corresponding to the EngineeredSystemPatch");
            return false;
        }
        if ((gibxml.getPatchesOrder() == null || gibxml.getPatchesOrder().isEmpty()) && (gibxml.getPatchToTargetList() == null || gibxml.getPatchToTargetList().isEmpty())) {
            logger.log(Level.FINE, "Couldn't get the list of patches and order of patches from the bundle.xml");
            return false;
        }
        return true;
    }

    @Override
    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        OPatchGIBundleXML gibxml;
        OPatchBundlePatch patch;
        Path bundlexml;
        Path patchDir;
        block26: {
            assert (patchLocation != null);
            patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
            if (!Files.exists(patchDir, new LinkOption[0])) {
                throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
            }
            if (!Files.isDirectory(patchDir, new LinkOption[0])) {
                throw new PatchPackageException("The patchLocation " + patchLocation + " specified is not a directory");
            }
            StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
            bundleXMLLoc.append(File.separator);
            bundleXMLLoc.append("bundle.xml");
            bundlexml = WrapperFactory.getNioServiceWrapper().getPath(bundleXMLLoc.toString(), new String[0]);
            if (!Files.exists(bundlexml, new LinkOption[0]) || !Files.isRegularFile(bundlexml, new LinkOption[0])) {
                throw new PatchPackageException("Location " + patchDir.toAbsolutePath().toString() + "does not contain 'bundle.xml' file.");
            }
            patch = new OPatchBundlePatch(patchLocation);
            patch.setBundleXmlLoc(bundlexml.toAbsolutePath().toString());
            gibxml = null;
            OPatchGIBundleXmlHelper gibhxml = new OPatchGIBundleXmlHelper();
            try {
                gibxml = gibhxml.readBundle(this.getContent(Files.newInputStream(bundlexml, new OpenOption[0])).toString());
                String bundleType = gibxml.getBundleType();
                if (bundleType.startsWith("GI_BUNDLE")) {
                    patch.setBundlePatchType("GI_BUNDLE");
                    break block26;
                }
                if (bundleType.startsWith("EXA_BUNDLE")) {
                    patch.setBundlePatchType("EXA_BUNDLE");
                    break block26;
                }
                throw new PatchPackageException("This bundle patch is not valid as it's neither GI BUNDLE nor EXA BUNDLE");
            }
            catch (IOException e2) {
                throw new PatchPackageException("Exception while reading bundle.xml", e2);
            }
            catch (BundleXmlException e3) {
                throw new PatchPackageException("Exception occured while trying to create bundleXml object", e3);
            }
            catch (BundleValidationException e4) {
                throw new PatchPackageException("The bundle.xml in the patch does not correspond to a Bundle Patch. Hence,OPatchGIBundleXML object cannot be created.", e4);
            }
        }
        try {
            patch.setBundleXml(this.getContent(Files.newInputStream(bundlexml, new OpenOption[0])).toString());
        }
        catch (IOException e1) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml", e1);
        }
        String messagePropPath = patchLocation + File.separator + "automation" + File.separator + "messages.properties";
        Path messageProp = WrapperFactory.getNioServiceWrapper().getPath(messagePropPath, new String[0]);
        if (Files.exists(messageProp, new LinkOption[0]) && Files.isRegularFile(messageProp, new LinkOption[0])) {
            try {
                patch.setResourceBundle(this.getContent(Files.newInputStream(messageProp, new OpenOption[0])).toString());
            }
            catch (IOException ex) {
                throw new PatchPackageException("Couldn't get the string content of the messages.properties", ex);
            }
        } else {
            patch.setResourceBundle(null);
        }
        Path automationXmlFolderLocation = WrapperFactory.getNioServiceWrapper().getPath(patchDir + File.separator + "automation", new String[0]);
        if (Files.exists(automationXmlFolderLocation, new LinkOption[0])) {
            DirectoryStream<Path> subFiles = null;
            if (Files.isDirectory(automationXmlFolderLocation, new LinkOption[0])) {
                try {
                    subFiles = Files.newDirectoryStream(automationXmlFolderLocation);
                }
                catch (IOException e5) {
                    OLogger.debug(e5.getMessage());
                }
            }
            Iterator iterator = subFiles.iterator();
            if (!Files.isDirectory(automationXmlFolderLocation, new LinkOption[0])) {
                throw new PatchPackageException(automationXmlFolderLocation.toAbsolutePath().toString() + " exists but is not a folder");
            }
            if (subFiles == null || !iterator.hasNext()) {
                throw new PatchPackageException(automationXmlFolderLocation.toAbsolutePath().toString() + " exists but does not contain any automationXmls.");
            }
            patch.setAutomationXmlLocation(automationXmlFolderLocation.toAbsolutePath().toString());
            ArrayList<String> automationXmls = new ArrayList<String>();
            while (iterator.hasNext()) {
                Path automationXml = (Path)iterator.next();
                if (!Files.isRegularFile(automationXml, new LinkOption[0])) continue;
                try {
                    automationXmls.add(this.getContent(Files.newInputStream(automationXml, new OpenOption[0])).toString());
                }
                catch (IOException e6) {
                    throw new PatchPackageException("Couldn't read the automationXmls", e6);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        patch.setSubPatches(this.instantiatePatches(patchDir, gibxml));
        patch.setPatchID(this.getPatchID(patch));
        patch.setPatchLocation(patchLocation);
        return patch;
    }

    @Override
    public PatchPackage generate(Map map) throws PatchPackageException {
        OPatchGIBundleXML gibxml;
        OPatchBundlePatch patch;
        Object[] bundleXMLArray;
        block30: {
            assert (!map.isEmpty());
            bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
            if (bundleXMLArray.length == 0) {
                logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
                throw new PatchPackageException("Bundle.xml was not found in the given patch zip file");
            }
            ByteArrayInputStream bundleXML = new ByteArrayInputStream((byte[])bundleXMLArray[1]);
            patch = new OPatchBundlePatch((String)map.get(OPatchZipStringResource.TOPDIRNAME));
            String bundleLoc = (String)bundleXMLArray[0];
            if (bundleLoc.equals("bundle.xml")) {
                patch.setPatchLocation("");
                patch.setAutomationXmlLocation("automation");
            } else {
                patch.setPatchLocation((String)map.get(OPatchZipStringResource.TOPDIRNAME));
                patch.setAutomationXmlLocation(patch.getPatchLocation() + File.separator + "automation");
            }
            patch.setBundleXmlLoc((String)bundleXMLArray[0]);
            gibxml = null;
            OPatchGIBundleXmlHelper gibhxml = new OPatchGIBundleXmlHelper();
            try {
                gibxml = gibhxml.readBundle(this.getContent(bundleXML).toString());
                String bundleType = gibxml.getBundleType();
                if (bundleType.startsWith("GI_BUNDLE")) {
                    patch.setBundlePatchType("GI_BUNDLE");
                    break block30;
                }
                if (bundleType.startsWith("EXA_BUNDLE")) {
                    patch.setBundlePatchType("EXA_BUNDLE");
                    break block30;
                }
                throw new PatchPackageException("This bundle patch is not valid as it's neither GI BUNDLE nor EXA BUNDLE");
            }
            catch (IOException e2) {
                throw new PatchPackageException("Exception while reading bundle.xml", e2);
            }
            catch (BundleXmlException e3) {
                throw new PatchPackageException("Exception occured while trying to create bundleXml object", e3);
            }
            catch (BundleValidationException e4) {
                throw new PatchPackageException("The bundle.xml in the patch does not correspond to a Bundle Patch. Hence,OPatchGIBundleXML object cannot be created.", e4);
            }
        }
        try {
            patch.setBundleXml(this.getContent(new ByteArrayInputStream((byte[])bundleXMLArray[1])).toString());
        }
        catch (IOException e1) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml", e1);
        }
        Object[] messageArray = (Object[])map.get(OPatchZipStringResource.MESSAGE);
        if (messageArray.length == 2) {
            ByteArrayInputStream messageStream = new ByteArrayInputStream((byte[])messageArray[1]);
            try {
                patch.setResourceBundle(this.getContent(messageStream).toString());
            }
            catch (IOException ex) {
                throw new PatchPackageException("Couldn't get the string content of the messages.properties", ex);
            }
        } else {
            patch.setResourceBundle(null);
        }
        ArrayList<byte[]> automationList = new ArrayList<byte[]>();
        Map autoStreamMap = (Map)map.get(ZipStringResource.AUTOS);
        Iterator autoStreamIterator = autoStreamMap.values().iterator();
        while (autoStreamIterator.hasNext()) {
            automationList.add((byte[])autoStreamIterator.next());
        }
        if (automationList.isEmpty()) {
            patch.setAutoXmls(null);
        }
        ArrayList<String> automationXmls = new ArrayList<String>();
        for (byte[] automationXml : automationList) {
            try {
                automationXmls.add(this.getContent(new ByteArrayInputStream(automationXml)).toString());
            }
            catch (IOException e5) {
                throw new PatchPackageException("Couldn't read the automationXmls", e5);
            }
        }
        patch.setAutoXmls(automationXmls);
        ArrayList<GenericPatch> subPatchList = new ArrayList<GenericPatch>();
        Map patchesMap = OPatchPatch.getPatches((Map)map);
        ArrayList<String> removePatchList = new ArrayList<String>();
        Map compositeMap = (Map)map.get(OPatchZipStringResource.COMPOSITE);
        Iterator compositeIte = compositeMap.entrySet().iterator();
        Map inventoryMap = (Map)map.get(OPatchZipStringResource.INVENTORY);
        while (compositeIte.hasNext()) {
            String[] subPatchIDs;
            Map.Entry comEntry = compositeIte.next();
            ArrayList<OPatchSingletonPatch> arrayList = new ArrayList<OPatchSingletonPatch>();
            String compositeLocation = (String)comEntry.getKey();
            byte[] compositBytes = (byte[])comEntry.getValue();
            for (String subPatchID : subPatchIDs = CompositePatchObject.getConstituentList(new ByteArrayInputStream(compositBytes))) {
                String subPatchLoc = compositeLocation + File.separator + subPatchID;
                OPatchPatch subComOPP = (OPatchPatch)patchesMap.get(subPatchLoc);
                OPatchSingletonPatch subComPatch = new OPatchSingletonPatch(subComOPP);
                subComPatch.setPatchID(subComOPP.getPatchId());
                subComPatch.setPatchLocation(subPatchLoc);
                arrayList.add(subComPatch);
                removePatchList.add(subPatchLoc);
            }
            if (subPatchIDs.length == 0) {
                throw new PatchPackageException("Invalid Bundle patch format, Could not get subpatch of the sub composite patch.");
            }
            String inventoryPath = PatchObject.getInventoryFilePath(compositeLocation + File.separator + subPatchIDs[0]);
            ByteArrayInputStream inventoryStr = new ByteArrayInputStream((byte[])inventoryMap.get(inventoryPath));
            String patchID = CompositePatchObject.getActiveConstituent(inventoryStr);
            OPatchCompositePatch compPatch = new OPatchCompositePatch(patchID, compositeLocation, arrayList);
            try {
                compPatch.setCompositeXml(this.getContent(new ByteArrayInputStream(compositBytes)).toString());
            }
            catch (IOException e6) {
                throw new PatchPackageException("Exception while reading composite.xml", e6);
            }
            subPatchList.add(compPatch);
        }
        for (Object e2 : removePatchList) {
            patchesMap.remove((String)e2);
        }
        for (Map.Entry entry : patchesMap.entrySet()) {
            String subpatchlocation = (String)entry.getKey();
            OPatchPatch opp = (OPatchPatch)entry.getValue();
            OPatchSingletonPatch subpatch = new OPatchSingletonPatch(opp);
            subpatch.setPatchID(opp.getPatchId());
            subpatch.setPatchLocation(subpatchlocation);
            subPatchList.add(subpatch);
        }
        ArrayList<GenericPatch> arrayList = new ArrayList<GenericPatch>();
        for (String subPatchLoc : gibxml.getPatchesOrder()) {
            for (GenericPatch gsubPatch : subPatchList) {
                String sublocation = gsubPatch.getPatchLocation();
                if (!sublocation.endsWith(subPatchLoc) || sublocation.contains("custom") && !subPatchLoc.contains("custom")) continue;
                gsubPatch.setApplicableTargets(gibxml.getPatchToTargetList().get(subPatchLoc));
                arrayList.add(gsubPatch);
            }
        }
        patch.setSubPatches(arrayList);
        patch.setPatchID(this.getPatchID(patch));
        return patch;
    }

    private List<GenericPatch> instantiatePatches(Path patchDir, OPatchGIBundleXML gibxml) throws PatchPackageException {
        ArrayList<GenericPatch> subPatches = new ArrayList<GenericPatch>();
        for (String patchloc : gibxml.getPatchesOrder()) {
            GenericPatch subPatch;
            Path subPatchDir = WrapperFactory.getNioServiceWrapper().getPath(patchDir + File.separator + patchloc, new String[0]);
            if (!Files.isDirectory(subPatchDir, new LinkOption[0])) {
                throw new PatchPackageException("Sub-patch path " + subPatchDir + " specified in bundle.xml does not exists.");
            }
            String subPatchLoc = subPatchDir.toAbsolutePath().toString();
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            OPatchCompositePatchValidatorAndGenerator ocvg = new OPatchCompositePatchValidatorAndGenerator();
            if (osvg.isPatchValid(subPatchLoc)) {
                subPatch = (GenericPatch)osvg.generate(subPatchLoc);
                subPatch.setApplicableTargets(gibxml.getPatchToTargetList().get(patchloc));
                subPatches.add(subPatch);
            }
            if (!ocvg.isPatchValid(subPatchLoc)) continue;
            subPatch = (GenericPatch)ocvg.generate(subPatchLoc);
            subPatch.setApplicableTargets(gibxml.getPatchToTargetList().get(patchloc));
            subPatches.add(subPatch);
        }
        return subPatches;
    }

    public String getPatchID(PatchBundle bundle) {
        if (bundle.getSubPatches().size() > 0) {
            return bundle.getSubPatches().get(0).getPatchID();
        }
        return null;
    }

    @Override
    public String getPatchTool() {
        return "OPATCH";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }
}

