/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.CopyAction;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.NRollback;
import oracle.opatch.twophase.PhaseOneOperator;
import oracle.opatch.wrappers.WrapperFactory;

public class NRollbackOperator
extends PhaseOneOperator {
    @Override
    public Map<Path, String> modify(String soh, PatchObject[] rollbackPatch) {
        String[] patchesToRollback = new String[rollbackPatch.length];
        for (int i2 = 0; i2 < rollbackPatch.length; ++i2) {
            patchesToRollback[i2] = rollbackPatch[i2].getPatchID();
        }
        NRollback.legacy_process(soh, patchesToRollback);
        this.setPatchActions(OPatchEnv.getOracleHome(), rollbackPatch);
        HashMap<Path, String> remove = new HashMap();
        remove = this.getRemovedFiles(OPatchEnv.getOracleHome(), soh, rollbackPatch);
        return remove;
    }

    @Override
    public String getPrefix() {
        return OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "nrollback.key";
    }

    @Override
    public String getKeyPostfix() {
        return "nrollback";
    }

    @Override
    public PatchObject[] buildInputPatchList(PatchObject patch, PatchObject[] patchList) {
        if (patch.getIsComposite()) {
            if (patch.isActiveCompositeSubPatch()) {
                ArrayList<PatchObject> piPatches = new ArrayList<PatchObject>();
                for (PatchObject p2 : patchList) {
                    if (!p2.getIsComposite()) continue;
                    piPatches.add(p2);
                }
                return piPatches.toArray(new PatchObject[piPatches.size()]);
            }
            return new PatchObject[0];
        }
        return new PatchObject[]{patch};
    }

    @Override
    public List<PatchObject> getScriptsSavePatchList(PatchObject p2, PatchObject[] piList) {
        return new ArrayList<PatchObject>(Arrays.asList(piList));
    }

    private void setPatchActions(String oracleHomePath, PatchObject[] patches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::setPatchActions (String oracleHomePath, PatchObject[] patches)");
        for (PatchObject po : patches) {
            String cookedPatchID = po.getCookedPatchID();
            String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(prevAppliedPatchLocation);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(prevAppliedPatchLocation);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
            String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
            String preScriptLoc = PatchObject.getPreScriptFilePath(prevAppliedPatchLocation);
            String postScriptLoc = PatchObject.getPostScriptFilePath(prevAppliedPatchLocation);
            po.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
            po.setInitScriptAction(new InitScriptAction(initScriptLoc));
            po.setPreReadMeAction(new PreReadMeAction(preReadMeLoc));
            po.setPreScriptAction(new PreScriptAction(preScriptLoc));
            String c1 = this.readScriptContent(postReadMeLoc);
            String newPostReadMeLoc = this.writeScriptContent(c1, po, ".newpost.readme.");
            String c2 = this.readScriptContent(postScriptLoc);
            String newPostScriptLoc = this.writeScriptContent(c2, po, ".newpost.");
            po.setPostReadMeAction(new PostReadMeAction(newPostReadMeLoc));
            po.setPostScriptAction(new PostScriptAction(newPostScriptLoc));
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::setPatchActions (String oracleHomePath, PatchObject[] patches)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScriptContent(String scriptLoc) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::readScriptContent (String scriptLoc)");
        StringBuffer sb = new StringBuffer();
        Path scriptFile = WrapperFactory.getNioServiceWrapper().getPath(scriptLoc, new String[0]);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(Files.newInputStream(scriptFile, new OpenOption[0])));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find scripts content under {0}:", scriptLoc));
            String string = null;
            return string;
        }
        catch (Exception e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to read scripts content from {0}:", scriptLoc));
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::readScriptContent (String scriptLoc)");
        return sb.toString();
    }

    private String writeScriptContent(String content, PatchObject po, String postfix) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::writeScriptContent (String content, PatchObject po, String postfix)");
        String newLoc = "";
        if (content == null) {
            return "";
        }
        try {
            newLoc = this.getNewScriptLoc(po, postfix);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("OPatch is re-writing scripts to {0}:", newLoc));
            Path file = WrapperFactory.getNioServiceWrapper().getPath(newLoc, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                try {
                    Files.createFile(file, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    OLogger.printlnOnLog(MessageFormat.format("Failed to create file: ", file.toString()));
                    return "";
                }
            }
            FileWriter fw = new FileWriter(file.toAbsolutePath().toString());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to write scripts content under {0}:", newLoc));
            return "";
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::writeScriptContent (String content, PatchObject po, String postfix)");
        return newLoc;
    }

    public String getNewScriptLoc(PatchObject po, String script) {
        StringBuffer buff = new StringBuffer(this.getPrefix());
        buff.append(".");
        buff.append(po.getPatchID());
        buff.append(script);
        buff.append(this.getPostfix());
        return buff.toString();
    }

    private Map<Path, String> getRemovedFiles(String oh, String soh, PatchObject[] patches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::getRemovedFiles(String oh, PatchObject[] patches)");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> remove = new HashMap<Path, String>();
        Map<Object, Object> sameFileMap = new HashMap();
        for (PatchObject po : patches) {
            Path pd;
            String loc = OPatchEnv.getPatchFilemapInfoLoc(oh, po.getPatchID());
            loc = loc.substring(oh.length() + 1, loc.length());
            Path pLoc = WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]);
            remove.put(pLoc, loc);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed oneoff entry: adding \"{0}\" to remove list. \n", loc));
            if (OPatchEnv.isNextGen()) {
                String ngXml = OPatchEnv.getNGPatchXmlLoc(oh, po.getPatchID());
                ngXml = ngXml.substring(oh.length() + 1, ngXml.length());
                Path ngXmlLoc = WrapperFactory.getNioServiceWrapper().getPath(ngXml, new String[0]);
                remove.put(ngXmlLoc, ngXml);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed oneoff entry: adding \"{0}\" to remove list. \n", ngXml));
            }
            String cookedPatchID = po.getCookedPatchID();
            String ps = OPatchEnv.getPatchStorageName() + File.separator + cookedPatchID;
            Path pPs = WrapperFactory.getNioServiceWrapper().getPath(ps, new String[0]);
            remove.put(pPs, ps);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing backup area, adding \"{0}\" to remove list. \n", ps));
            ListIterator cIter = po.getAllIncludedCopyActions();
            sameFileMap = CopyAction.getSrcFileInUnchangedFileList(oh, cookedPatchID);
            while (cIter.hasNext()) {
                CopyAction a2 = (CopyAction)cIter.next();
                String f2 = a2.getFilename();
                Boolean isInUnchangedFile = false;
                String src = this.getRollbackFile(oh, f2, cookedPatchID);
                String dst = a2.getParentFilePath(oh);
                Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
                Path sohSrcFile = WrapperFactory.getNioServiceWrapper().getPath(soh + File.separator + f2, new String[0]);
                if (sameFileMap.containsKey(f2)) {
                    isInUnchangedFile = true;
                }
                if (Files.exists(srcFile, new LinkOption[0]) && Files.isReadable(srcFile)) {
                    if (Files.isRegularFile(srcFile, new LinkOption[0]) && Files.isDirectory(Paths.get(dst, new String[0]), new LinkOption[0])) {
                        OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" was deleted as file, patched as directory. \n", src));
                        dst = dst.substring(oh.length() + 1, dst.length());
                        pd = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
                        remove.put(pd, dst);
                        OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing newly created directory, adding \"{0}\" to remove list. \n", dst));
                        continue;
                    }
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, do not remove. \n", src));
                    continue;
                }
                if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
                    String notReadableMsg = MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, but it's not readable. \n", src);
                    OLogger.justlog(OLogger.INFO, notReadableMsg);
                    throw new RuntimeException(notReadableMsg);
                }
                if (!Files.exists(srcFile, new LinkOption[0]) && isInUnchangedFile.booleanValue()) {
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" doesn't exist in .patch_storage, but it exists in unchanged_files.txt, do not remove. \n", src));
                    continue;
                }
                if (Files.exists(sohSrcFile, new LinkOption[0])) {
                    OLogger.justlog(OLogger.INFO, "Shadow home contains file " + sohSrcFile.toString() + ". Rollback of delete action may have added this file. Just update file from shadow home to oh. Do not remove it");
                    continue;
                }
                OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" doesn't exist in .patch_storage, to be removed. \n", src));
                StringBuffer srcFileName = new StringBuffer(src);
                dst = dst.substring(oh.length() + 1, dst.length());
                Path pd2 = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
                remove.put(pd2, dst);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing newly created file, adding \"{0}\" to remove list. \n", dst));
            }
            if (!OPatchEnv.isNextGen()) continue;
            for (PatchComponent pc : po.getPatchComponents()) {
                Path sohSrcFile;
                Path sohSrcFile2;
                Path sohSrcFile3;
                String cmpInventoryPath = NRollbackOperator.getCompInventoryPath(oh, pc.getName(), pc.getVersion());
                String shadowohInventoryPath = NRollbackOperator.getCompInventoryPath(soh, pc.getName(), pc.getVersion());
                String upgrade_comp_xml = NRollbackOperator.getNGCompInventoryUpgradeXmlLoc(cmpInventoryPath, "");
                pd = WrapperFactory.getNioServiceWrapper().getPath(upgrade_comp_xml, new String[0]);
                if (Files.exists(pd, new LinkOption[0]) && !Files.exists(sohSrcFile3 = WrapperFactory.getNioServiceWrapper().getPath(NRollbackOperator.getNGCompInventoryUpgradeXmlLoc(shadowohInventoryPath, ""), new String[0]), new LinkOption[0])) {
                    upgrade_comp_xml = upgrade_comp_xml.substring(oh.length() + 1, upgrade_comp_xml.length());
                    Path cmpInventoryPathLoc = WrapperFactory.getNioServiceWrapper().getPath(upgrade_comp_xml, new String[0]);
                    remove.put(cmpInventoryPathLoc, upgrade_comp_xml);
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed component upgrade-compDef entry: adding \"{0}\" to remove list. \n", upgrade_comp_xml));
                }
                String upgrade_patchid_comp_xml = NRollbackOperator.getNGCompInventoryUpgradeXmlLoc(cmpInventoryPath, po.getPatchUniqID());
                Path pd_patchid = WrapperFactory.getNioServiceWrapper().getPath(upgrade_patchid_comp_xml, new String[0]);
                if (Files.exists(pd_patchid, new LinkOption[0]) && !Files.exists(sohSrcFile2 = WrapperFactory.getNioServiceWrapper().getPath(NRollbackOperator.getNGCompInventoryUpgradeXmlLoc(shadowohInventoryPath, po.getPatchUniqID()), new String[0]), new LinkOption[0])) {
                    upgrade_patchid_comp_xml = upgrade_patchid_comp_xml.substring(oh.length() + 1, upgrade_patchid_comp_xml.length());
                    Path cmpInventoryPathLoc = WrapperFactory.getNioServiceWrapper().getPath(upgrade_patchid_comp_xml, new String[0]);
                    remove.put(cmpInventoryPathLoc, upgrade_patchid_comp_xml);
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed component upgrade-compDef entry: adding \"{0}\" to remove list. \n", upgrade_patchid_comp_xml));
                }
                String patches_comp_xml = NRollbackOperator.getNGCompInventoryPatchCompdefXMLLoc(cmpInventoryPath);
                Path patches_comp_xml_path = WrapperFactory.getNioServiceWrapper().getPath(patches_comp_xml, new String[0]);
                if (!Files.exists(patches_comp_xml_path, new LinkOption[0]) || Files.exists(sohSrcFile = WrapperFactory.getNioServiceWrapper().getPath(NRollbackOperator.getNGCompInventoryPatchCompdefXMLLoc(shadowohInventoryPath), new String[0]), new LinkOption[0])) continue;
                patches_comp_xml = patches_comp_xml.substring(oh.length() + 1, patches_comp_xml.length());
                Path cmpInventoryPathLoc = WrapperFactory.getNioServiceWrapper().getPath(patches_comp_xml, new String[0]);
                remove.put(cmpInventoryPathLoc, patches_comp_xml);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed component patches compDef entry: adding \"{0}\" to remove list. \n", patches_comp_xml));
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::getRemovedFiles(String oh, PatchObject[] patches)");
        return remove;
    }

    private static String getCompInventoryPath(String oracleHomePath, String compName, String cmpVersion) {
        String oh = null;
        oh = oracleHomePath == null ? "" : oracleHomePath;
        StringBuffer buff = new StringBuffer(oh);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("Components");
        buff.append(File.separator);
        buff.append(compName);
        buff.append(File.separator);
        buff.append(cmpVersion);
        buff.append(File.separator);
        return buff.toString();
    }

    private static String getNGCompInventoryUpgradeXmlLoc(String invPath, String patchId) {
        StringBuffer buff = new StringBuffer(invPath);
        buff.append(File.separator);
        if (!patchId.equals("")) {
            buff.append(patchId);
            buff.append("-");
        }
        buff.append("upgrade-compDef.xml");
        return buff.toString();
    }

    private static String getNGCompInventoryPatchCompdefXMLLoc(String invPath) {
        StringBuffer buff = new StringBuffer(invPath);
        buff.append(File.separator);
        buff.append("patches");
        buff.append(File.separator);
        buff.append("compDef.xml");
        return buff.toString();
    }

    private String getRollbackFile(String oh, String copyFile, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oh, cookedPatchID));
        buff.append(File.separator);
        buff.append(copyFile);
        String file = buff.toString();
        return file;
    }
}

