/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.content.api.IIOCPatch;
import oracle.opatch.CustomizedActionResults;
import oracle.opatch.FVData;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ioc.IOCHelper;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.InitReadMePatchActions;
import oracle.opatch.twophase.InitScriptPatchActions;
import oracle.opatch.twophase.MakePatchActions;
import oracle.opatch.twophase.PostReadMePatchActions;
import oracle.opatch.twophase.PostScriptPatchActions;
import oracle.opatch.twophase.PreReadMePatchActions;
import oracle.opatch.twophase.PreScriptPatchActions;
import oracle.opatch.wrappers.WrapperFactory;

public abstract class PhaseOneOperator {
    protected void run(String sohPath, PatchObject[] patchList) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseOneOperator::run(String sohPath, PatchObject[] patchList)");
        CASFileServices cas = new CASFileServices();
        if (patchList == null || patchList.length == 0) {
            return;
        }
        LinkedHashMap<OPatchPatchKey, PatchObject[]> patchMap = new LinkedHashMap<OPatchPatchKey, PatchObject[]>();
        OPatchEnv.setApplicationVersion(patchList[patchList.length - 1].getPatchID());
        try {
            if (!OPatchEnv.isRunWithScriptsforCAS()) {
                OPatchPatchKey opKey = new OPatchPatchKey(patchList[0], this.getKeyPostfix());
                this.casRun(sohPath, opKey, patchList, true);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("Save key \"{0}\" and corresponding patch \"{1}\" to the map. \n", opKey.toString(), patchList[0].getPatchID()));
                patchMap.put(opKey, patchList);
            } else {
                ArrayList<PatchObject> scriptsSavePhList = new ArrayList<PatchObject>();
                int realInstalledPhNum = 0;
                for (int i2 = 0; i2 < patchList.length; ++i2) {
                    PatchObject p2 = patchList[i2];
                    PatchObject[] piList = this.buildInputPatchList(p2, patchList);
                    scriptsSavePhList.addAll(this.getScriptsSavePatchList(p2, piList));
                    if (piList.length < 1) continue;
                    OPatchPatchKey opKey = new OPatchPatchKey(p2, this.getKeyPostfix());
                    if ((realInstalledPhNum += scriptsSavePhList.size()) == patchList.length) {
                        this.casRun(sohPath, opKey, piList, true);
                    } else if (p2.getScriptsFlagForOPatchOverCAS()) {
                        this.casRun(sohPath, opKey, piList, true);
                    } else {
                        this.casRun(sohPath, opKey, piList, false);
                    }
                    patchMap.put(opKey, scriptsSavePhList.toArray(new PatchObject[scriptsSavePhList.size()]));
                    scriptsSavePhList = new ArrayList();
                }
            }
            cas.verify(null);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Save the map to \"{0}\" \n", this.getPrefix()));
            this.save(this.getPrefix(), this.getPostfix(), patchMap);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseOneOperator::run(String sohPath, PatchObject[] patchList)");
    }

    private void casRun(String sohPath, OPatchPatchKey opKey, PatchObject[] patchList, boolean endflag) {
        CASFileServices cas = new CASFileServices();
        HashMap<Path, String> remove = new HashMap<Path, String>();
        ArrayList<SparseCopyContext> sccs = new ArrayList<SparseCopyContext>();
        Set<String> appDirNames = OPatchEnv.getApplicationWorkingDirectory().keySet();
        HashSet<String> leftAppDirs = new HashSet<String>(appDirNames);
        LinkedList<String> patchInfo = new LinkedList<String>();
        for (PatchObject p2 : patchList) {
            patchInfo.add(new OPatchPatchKey(p2, this.getKeyPostfix()).toString());
        }
        HashMap<String, ICustomizedActionResults> map = new HashMap<String, ICustomizedActionResults>();
        try {
            OLogger.justlog(OLogger.INFO, MessageFormat.format("CAS beginPatchBranch with patchkey \"{0}\". \n", opKey.toString()));
            cas.begin(opKey);
            for (PatchObject p3 : patchList) {
                ICustomizedActionResults preResults = this.runSparseAction(sohPath, p3, sccs, true, leftAppDirs);
                this.addToRemoveList(preResults, remove);
                map.put(p3.getPatchUniqID(), preResults);
                for (Object appDir : p3.getApplicationDirs()) {
                    leftAppDirs.remove((String)appDir);
                }
            }
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Modifying system on \"{0}\"... \n", sohPath));
            Map<Path, String> modifyResults = this.modify(sohPath, patchList);
            for (Map.Entry<Path, String> entry : modifyResults.entrySet()) {
                remove.put(entry.getKey(), entry.getValue());
            }
            for (PatchObject p4 : patchList) {
                ICustomizedActionResults postResults = this.runSparseAction(sohPath, p4, sccs, false, null);
                this.addToRemoveList(postResults, remove);
                ICustomizedActionResults preResults = (ICustomizedActionResults)map.get(p4.getPatchUniqID());
                ArrayList<String> addedFiles = new ArrayList();
                ArrayList<String> removedFiles = new ArrayList();
                if (preResults != null) {
                    addedFiles = preResults.getAddedFiles();
                }
                if (postResults != null) {
                    removedFiles = postResults.getRemoveFiles();
                }
                CustomizedActionResults actionResults = new CustomizedActionResults(addedFiles, removedFiles);
                map.put(p4.getPatchUniqID(), actionResults);
            }
            if (IOC.INSTANCE.isInventoryConverted()) {
                List<IIOCPatch> iocPatchList = IOCHelper.convertPatchObjectToIOCPatch(patchList);
                OneOffEntry[] pi = new OneOffEntry[patchList.length];
                for (int i2 = 0; i2 < patchList.length; ++i2) {
                    pi[i2] = patchList[i2].toOneOffEntry(OPatchEnv.getOracleHome());
                }
                FVData fvData = OPatchSessionHelper.getCopyFileVerForPi(pi);
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                HashMap<String, String> m_fv_oh = new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "fv_oh.txt"));
                cas.updateIOCMemento(opKey, iocPatchList, new HashSet<String>(), m_fv_oh);
            }
            OLogger.justlog(OLogger.INFO, "A list of files to be removed in original OH is: " + remove);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("CAS endPatchBranch with patchkey \"{0}\". \n", opKey.toString()));
            cas.end(opKey, remove, endflag);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("CAS save patchinfo with memento \"{0}\". \n", opKey.toString()));
            cas.savePatchInfo(opKey.toString(), patchInfo);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        OPatchEnv.addMSIDCustomResults(map);
    }

    private void addToRemoveList(ICustomizedActionResults results, Map<Path, String> remove) {
        if (results != null) {
            List<String> removeList = results.getRemoveFiles();
            for (String removeFile : removeList) {
                Path removePath = WrapperFactory.getNioServiceWrapper().getPath(removeFile, new String[0]);
                remove.put(removePath, removeFile);
            }
        }
    }

    private ICustomizedActionResults runSparseAction(String sohPath, PatchObject p2, List<SparseCopyContext> sccs, boolean flag, Set<String> leftAppDirs) {
        ICustomizedActions customizedAction = null;
        customizedAction = flag ? p2.getPreCustomizedAction(sccs, sohPath, leftAppDirs) : p2.getPostCustomizedAction(sccs, sohPath);
        ICustomizedActionResults results = customizedAction.run();
        return results;
    }

    protected abstract Map<Path, String> modify(String var1, PatchObject[] var2) throws Exception;

    protected abstract PatchObject[] buildInputPatchList(PatchObject var1, PatchObject[] var2);

    protected abstract List<PatchObject> getScriptsSavePatchList(PatchObject var1, PatchObject[] var2);

    protected abstract String getPrefix();

    protected abstract String getKeyPostfix();

    protected String getPostfix() {
        if (OPatchEnv.isOPatchSDKMode()) {
            return "SDK";
        }
        return "CLI";
    }

    protected void save(String prefix, String postfix, Map<OPatchPatchKey, PatchObject[]> patchMap) throws IOException {
        OLogger.justlog(OLogger.INFO, "Saving patch keys and custom scripts..");
        InitScriptPatchActions inits = new InitScriptPatchActions();
        InitReadMePatchActions initrms = new InitReadMePatchActions();
        MakePatchActions makes = new MakePatchActions();
        PreScriptPatchActions pres = new PreScriptPatchActions();
        PreReadMePatchActions prerms = new PreReadMePatchActions();
        PostScriptPatchActions posts = new PostScriptPatchActions();
        PostReadMePatchActions postrms = new PostReadMePatchActions();
        inits.save(prefix, postfix, patchMap);
        initrms.save(prefix, postfix, patchMap);
        pres.save(prefix, postfix, patchMap);
        prerms.save(prefix, postfix, patchMap);
        posts.save(prefix, postfix, patchMap);
        postrms.save(prefix, postfix, patchMap);
        makes.save(prefix, postfix, patchMap);
        OLogger.justlog(OLogger.INFO, "Finished saving patch keys and custom scripts.");
    }
}

