/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.glcm.opatch.content.api.CasApiException;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSession;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.CASStabilityServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.ioc.IOC;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.InitReadMePatchActions;
import oracle.opatch.twophase.InitScriptPatchActions;
import oracle.opatch.twophase.MakePatchActions;
import oracle.opatch.twophase.PhaseTwoOperatorHelper;
import oracle.opatch.twophase.PostReadMePatchActions;
import oracle.opatch.twophase.PostScriptPatchActions;
import oracle.opatch.twophase.PreReadMePatchActions;
import oracle.opatch.twophase.PreScriptPatchActions;
import oracle.opatch.twophase.TwoPhaseMatchType;
import oracle.opatch.twophase.TwoPhaseOperations;
import oracle.opatch.wrappers.WrapperFactory;

public class PhaseTwoOperator {
    protected OPatchCASOracleHome coh;
    protected String oh;
    protected String shadow;
    protected boolean copyOh = false;
    protected Long markedTimestamp;
    protected CASFileServices cas;
    private CASStabilityServices css;

    public PhaseTwoOperator(OPatchCASOracleHome coh) {
        this.coh = coh;
        this.oh = coh.getOracleHomePath();
        this.shadow = coh.getCASStoragePath();
        this.cas = new CASFileServices();
        this.css = new CASStabilityServices();
    }

    protected void run() throws ExitTwoPhaseException, Exception {
        boolean isDBHome;
        OLogger.debug("ENTERING METHOD: PhaseTwoOperator::run()");
        boolean bl = isDBHome = IOC.INSTANCE.isInventoryConverted() ? false : OPatchEnv.isDBHome(OPatchEnv.getOracleHome());
        if (isDBHome) {
            OLogger.justlog(OLogger.INFO, "commit everything.");
            this.commitall();
        } else {
            TwoPhaseMatchType t = PhaseTwoOperatorHelper.getMatchType(this.oh);
            if (t == TwoPhaseMatchType.SAME) {
                OLogger.justlog(OLogger.INFO, "Pi and Poh are unchanged between phase1 and phase2, commit everything");
                this.commitall();
            } else if (t == TwoPhaseMatchType.NOCOLLISION) {
                OLogger.justlog(OLogger.INFO, "Changed Poh touch different components, no file collision, commit bits only, exclude inventory");
                this.commitbits();
            } else if (t == TwoPhaseMatchType.DIFFERENT) {
                OLogger.justlog(OLogger.INFO, "Pi changed, or changed Poh touch same components, file collision, re-run CAS phase1 and commit");
                this.commitdiff();
            }
        }
        this.endPhaseTwoCheckpoint();
        OLogger.debug("EXITING METHOD: PhaseTwoOperator::run()");
    }

    protected void commit(Map<Path, String> ignore) {
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] begin CAS bits and inventory commit");
        this.beginPhaseTwoCheckpoint();
        this.markTimestampForRescan();
        this.runNRollbackPhaseTwo(ignore);
        this.runNApplyPhaseTwo(ignore);
        this.runFinalProcessingSteps(ignore);
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS bits and inventory commit done");
    }

    protected void commitall() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperator::commitall()");
        this.commit(new HashMap<Path, String>());
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperator::commitall()");
    }

    protected void commitbits() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperator::commitbits()");
        this.commit(PhaseTwoOperatorHelper.getIgnoreList());
        String soh = this.oh + File.separator + this.shadow + File.separator + OPatchEnv.getBranchKey();
        PhaseTwoOperatorHelper.mergeInventory(this.oh, soh);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperator::commitbits()");
    }

    protected void commitdiff() throws ExitTwoPhaseException, Exception {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperator::commitdiff()");
        OPatchOverCAS.INSTANCE.prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY);
        this.commit(new HashMap<Path, String>());
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperator::commitdiff()");
    }

    private void runPhaseTwo(String key, Map<Path, String> ignore) {
        InitReadMePatchActions initrms = new InitReadMePatchActions();
        InitScriptPatchActions inits = new InitScriptPatchActions();
        MakePatchActions makes = new MakePatchActions();
        PreReadMePatchActions prerms = new PreReadMePatchActions();
        PreScriptPatchActions pres = new PreScriptPatchActions();
        PostReadMePatchActions postrms = new PostReadMePatchActions();
        PostScriptPatchActions posts = new PostScriptPatchActions();
        String prefix = PhaseTwoOperatorHelper.getPrefixFileName(this.oh, key);
        String postfix = PhaseTwoOperatorHelper.getPostfixFileName();
        try {
            this.load(prefix, postfix, initrms, inits, makes, prerms, pres, postrms, posts);
            if (PhaseTwoOperatorHelper.shouldRunCopyOH(inits, pres, posts, makes)) {
                OLogger.justlog(OLogger.INFO, "re-link actions or custom pre/post scripts detected, copyOH.");
                this.runCopyOh();
            }
            for (OPatchPatchKey opKey : inits.keySet()) {
                initrms.run(opKey);
                inits.run(opKey);
            }
            for (OPatchPatchKey opKey : pres.keySet()) {
                prerms.run(opKey);
                pres.run(opKey);
                this.commitkey(opKey, ignore);
                postrms.run(opKey);
                posts.run(opKey);
            }
            if (!IOC.INSTANCE.isInventoryConverted()) {
                PhaseTwoOperatorHelper.runPatchGen(this.oh, pres.keySet());
            }
            makes.runAll();
        }
        catch (Exception e2) {
            OPatchSession.restorePatchgen(this.oh);
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            PhaseTwoOperatorHelper.clear(this.oh, key, postfix);
        }
    }

    protected void load(String prefix, String postfix, InitReadMePatchActions initrms, InitScriptPatchActions inits, MakePatchActions makes, PreReadMePatchActions prerms, PreScriptPatchActions pres, PostReadMePatchActions postrms, PostScriptPatchActions posts) throws ClassNotFoundException, IOException {
        OLogger.justlog(OLogger.INFO, "Loading patch keys and custom scripts..");
        initrms.load(prefix, postfix);
        inits.load(prefix, postfix);
        makes.load(prefix, postfix);
        prerms.load(prefix, postfix);
        pres.load(prefix, postfix);
        postrms.load(prefix, postfix);
        posts.load(prefix, postfix);
        OLogger.justlog(OLogger.INFO, "Finished loading patch keys and custom scripts.");
    }

    private void runNRollbackPhaseTwo(Map<Path, String> ignore) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperator::runNRollbackPhaseTwo()");
        this.runPhaseTwo("nrollback.key", ignore);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperator::runNRollbackPhaseTwo()");
    }

    private void runNApplyPhaseTwo(Map<Path, String> ignore) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperator::runNApplyPhaseTwo()");
        this.runPhaseTwo("napply.key", ignore);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperator::runNApplyPhaseTwo()");
    }

    private void runCopyOh() {
        if (!this.copyOh) {
            OLogger.justlog(OLogger.INFO, "Converting OH from hardlink to real copy..");
            HashMap<Path, String> ignore = new HashMap<Path, String>();
            Path ps = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getPatchStorageName(), new String[0]);
            ignore.put(ps, OPatchEnv.getPatchStorageName());
            this.cas.copyOh(ignore);
            this.copyOh = true;
            OLogger.justlog(OLogger.INFO, "Finished converting OH from hardlink to real copy.");
        }
    }

    private void runFinalProcessingSteps(Map<Path, String> ignore) {
        boolean isDBHome;
        boolean bl = IOC.INSTANCE.isInventoryConverted() ? false : (isDBHome = OPatchEnv.isDBHome(this.oh) && !OPatchEnv.isFullDBCasRepo());
        if (isDBHome) {
            OLogger.justlog(OLogger.INFO, "Skipping normalizing and syncing to latest patch for this DB Home.");
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Reforming cas store for DB");
            this.cas.normalizeOH(this.copyOh, this.getMarkedTimestampForRescan());
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Reforming cas store for DB is complete");
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Detaching cas store for DB");
            this.runCopyOh();
            this.cas.detach();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - Detaching cas store for DB is complete");
            try {
                ICASFileServices casFileServices = CASServices.getFileServices();
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - This is DB home. destroying CLI and SDK shadow branch if exists");
                casFileServices.destroyShadowOH("CLI", false);
                casFileServices.destroyShadowOH("SDK", false);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - This is DB home. CLI and SDK shadow branch shadow branch destroyed, if it was exist");
            }
            catch (CasApiException e2) {
                OLogger.println("Failed to destroy shadow home. OPatch cannot proceed.\n");
                OLogger.printStackTrace(e2);
                RuntimeException re = new RuntimeException(e2.getMessage());
                throw re;
            }
        } else {
            OLogger.justlog(OLogger.INFO, "Normalizing OH and syncing to latest patch..");
            this.cas.normalizeOH(this.copyOh, null);
            if (!OPatchEnv.isFullDBCasRepo()) {
                this.cas.synch(ignore);
            }
            OLogger.justlog(OLogger.INFO, "Finished normalizing OH.");
        }
    }

    private void commitkey(OPatchPatchKey key, Map<Path, String> ignore) {
        try {
            this.cas.commit(key, ignore);
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, MessageFormat.format("Commited patch with key \"{0}\" \n", key.toString()));
    }

    private void beginPhaseTwoCheckpoint() {
        try {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching(): begin Checkpoint.");
            this.css.beginPhaseTwoCheckpoint(this.oh);
        }
        catch (Throwable t) {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching(): Failed to create Checkpoint: " + t.getMessage());
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    private void endPhaseTwoCheckpoint() {
        try {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching(): end Checkpoint.");
            this.css.endPhaseTwoCheckpoint(this.oh);
        }
        catch (Throwable th) {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching(): Failed to create Checkpoint: " + th.getMessage());
            RuntimeException re = new RuntimeException(th.getMessage());
            re.setStackTrace(th.getStackTrace());
            throw re;
        }
    }

    private Long getMarkedTimestampForRescan() {
        return this.markedTimestamp;
    }

    private void markTimestampForRescan() {
        this.markedTimestamp = new Date().getTime();
    }
}

