/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import oracle.dbsysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public abstract class ProductDriver {
    protected SystemInstance ti = null;
    protected LocalInfo localInfo = null;

    public abstract SystemInstance buildSystemInstance();

    public SystemInstance constructSystemInstance() throws ProductDriverException {
        if (this.ti != null) {
            return this.ti;
        }
        this.ti = this.buildSystemInstance();
        return this.ti;
    }

    public abstract LocalInfo getLocalInfo();

    public void setLocalInfoBySystemInstance(SystemInstance si) {
        this.localInfo = new LocalInfo();
        this.localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object b : si.getEntities()) {
            if (!(b instanceof OracleHome)) continue;
            OracleHome oh = (OracleHome)b;
            this.localInfo.getOracleHomes().add(oh);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (BaseClass b : si.getEntities()) {
            if (!(b instanceof Host)) continue;
            Host h = (Host)b;
            hosts.add(h);
        }
        HostComparatorCreator hostComparatorCreator = HostComparatorCreator.getInstance();
        Collections.sort(hosts, hostComparatorCreator.getHostComparator());
        Host first = (Host)hosts.get(0);
        this.localInfo.setLocalHostName(first.getHostName());
        this.localInfo.setLocalHost(first);
    }

    @Deprecated
    public OracleHome copyHome(OracleHome oh) {
        OracleHome clone = new OracleHome();
        clone.setDescription(oh.getDescription());
        clone.setDisplayName(oh.getDisplayName());
        clone.setName(oh.getName());
        clone.setHomeName(oh.getHomeName());
        clone.setARUId(oh.getARUId());
        clone.setPath(oh.getPath());
        clone.setOriginalOracleHome(oh.getOriginalOracleHome());
        clone.setARUId(oh.getARUId());
        clone.setCentralInvPtr(oh.getCentralInvPtr());
        clone.setHomeGuid(oh.getHomeGuid());
        clone.setHomeType(oh.getHomeType());
        clone.setHosts(oh.getHosts());
        clone.setInstalledSWComponents(new ArrayList(oh.getInstalledSWComponents()));
        clone.setOCM(oh.getOCM());
        clone.setOwner(oh.getOwner());
        clone.setPatches(oh.getPatches());
        clone.setOracleBaseLocation(oh.getOracleBaseLocation());
        clone.setPlatform(oh.getPlatform());
        clone.setTopComponents(oh.getTopComponents());
        clone.setTopLevelOUI(oh.getTopLevelOUI());
        clone.setType(oh.getType());
        clone.setVersion(oh.getVersion());
        clone.setVersionOPatch(oh.getVersionOPatch());
        clone.setId(UUID.randomUUID().toString());
        return clone;
    }

    protected void defaultValues(AbstractBaseTarget t) {
        t.setDisplayName(t.getName());
        t.setId("ID_" + UUID.randomUUID().toString());
        t.setPlatform("linux");
        t.setType(t.getClass().getName());
        t.setDescription("A " + t.getType());
    }

    public static class HostComparator
    implements Comparator<Host> {
        @Override
        public int compare(Host h1, Host h2) {
            String localName = OsysUtility.getHostname();
            if (h1.getHostName().equals(localName)) {
                return -1;
            }
            if (h2.getHostName().equals(localName)) {
                return 1;
            }
            return h1.getHostName().compareTo(h2.getHostName());
        }
    }
}

