/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import model.common.EMtargetTypes;
import model.patchmetadata.EsysPatchBundleXML;
import model.patchmetadata.SubpatchXML;
import model.patchmetadata.TargetType;
import model.patchmetadata.automation;
import model.patchmetadata.fvalue;
import model.patchmodel.PatchType;
import model.patchmodel.PatchingTool;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import org.xml.sax.SAXException;

public class BundleXmlV1Helper {
    protected static Logger logger = null;
    protected String xsdFileName = null;
    protected static String xmlFileName = null;
    protected JAXBContext context = null;
    protected Unmarshaller unmarshaller = null;

    public BundleXmlV1Helper() throws BundleXmlException {
        this("model/xml/bundle.xsd");
        xmlFileName = "model/util/test/bundle.xml";
    }

    public BundleXmlV1Helper(String string) throws BundleXmlException {
        this.xsdFileName = string;
        logger = Logger.getLogger(this.getClass().getName());
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getResource("/" + string));
            this.context = JAXBContext.newInstance((Class[])this.getClasses());
            this.unmarshaller = this.context.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException jAXBException) {
            String string2 = "Failed to create JAXB context due to: " + jAXBException.getMessage();
            logger.log(Level.SEVERE, string2);
            throw new BundleXmlException(string2, jAXBException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "The Bundle schema is invalid. ");
            throw new BundleXmlException("The Bundle schema is invalid", sAXException);
        }
    }

    protected Class[] getClasses() {
        return new Class[]{EsysPatchBundleXML.class, SubpatchXML.class, TargetType.class, automation.class, fvalue.class, PatchingTool.class, PatchType.class, EMtargetTypes.class};
    }

    public EsysPatchBundleXML readBundle(File file) throws BundleXmlException, BundleValidationException {
        if (file == null) {
            throw new BundleXmlException("xml file is null!");
        }
        xmlFileName = file.getAbsolutePath() + file.getName();
        try {
            Object object = this.unmarshaller.unmarshal(file);
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException unmarshalException) {
            String string = xmlFileName + " is not valid: " + unmarshalException.getMessage() + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleValidationException(string, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string = "Unexpected error " + jAXBException.getMessage() + " occures while unmarshalling " + xmlFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException(string);
        }
    }

    public EsysPatchBundleXML readBundle(InputStream inputStream) throws BundleXmlException, BundleValidationException {
        try {
            Object object = this.unmarshaller.unmarshal(inputStream);
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException unmarshalException) {
            String string = " bundle.xml is not valid: " + unmarshalException.getMessage() + ". xml is " + inputStream + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleValidationException(string, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string = "Unexpected error " + jAXBException.getMessage() + " occures while unmarshalling bundle.xml: " + inputStream;
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException("Unexpected errors occur while unmarshalling bundle.xml");
        }
    }

    public EsysPatchBundleXML readBundle(String string) throws BundleValidationException, BundleXmlException {
        try {
            Object object = this.unmarshaller.unmarshal((Reader)new StringReader(string));
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException unmarshalException) {
            String string2 = " bundle.xml is not valid:" + unmarshalException.getMessage() + ". xml is " + string + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, string2);
            throw new BundleValidationException(string2, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string3 = "Unexpected error " + jAXBException.getMessage() + " occures while unmarshalling bundle.xml: " + string;
            logger.log(Level.SEVERE, string3);
            throw new BundleXmlException(string3);
        }
    }

    public static void main(String[] stringArray) {
        try {
            BundleXmlV1Helper bundleXmlV1Helper = new BundleXmlV1Helper();
            EsysPatchBundleXML esysPatchBundleXML = bundleXmlV1Helper.readBundle(new File(xmlFileName));
            System.out.println("\n**********  TESTING NEW XSD WITH OLD XML  **************");
            bundleXmlV1Helper.printEsysPatchBundleXMLObj(esysPatchBundleXML);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable throwable) {
            System.out.println(" Exception = " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public void printEsysPatchBundleXMLObj(EsysPatchBundleXML esysPatchBundleXML) {
        System.out.println(esysPatchBundleXML.toString());
        System.out.println(" UPI=" + esysPatchBundleXML.getUPI() + " PatchID=" + esysPatchBundleXML.getPatchID() + " PatchType=" + (Object)((Object)esysPatchBundleXML.getPatchType()) + " TypeVersion=" + esysPatchBundleXML.getTypeVersion() + " Description=" + esysPatchBundleXML.getDescription());
        automation automation2 = esysPatchBundleXML.getAutomation();
        System.out.println("   automation: OplanVersion=" + automation2.getOplanVersion() + " Hash=" + automation2.getHash());
        fvalue fvalue2 = esysPatchBundleXML.getFvalue();
        System.out.println("   fvalue: Minimum_opatch_version" + fvalue2.getMinimum_opatch_version() + " Function=" + fvalue2.getFunction() + " Value=" + fvalue2.getValue());
        System.out.println("   system:" + this.targetTypetoString(esysPatchBundleXML.getSystem()));
        System.out.println("   subpatches:");
        for (SubpatchXML subpatchXML : esysPatchBundleXML.getSubpatches()) {
            System.out.println(this.subpatchtoString(subpatchXML));
        }
    }

    public String targetTypetoString(TargetType targetType) {
        StringBuffer stringBuffer = new StringBuffer("TargetType: type=").append((Object)targetType.getType()).append(" version=").append(targetType.getVersion()).append(" Product=").append(targetType.getProduct()).append(" Release=").append(targetType.getRelease());
        return stringBuffer.toString();
    }

    public String subpatchtoString(SubpatchXML subpatchXML) {
        StringBuffer stringBuffer = new StringBuffer("subpatch: Location=").append(subpatchXML.getLocation()).append(" patchID=").append(subpatchXML.getPatchID()).append(" PatchingTool=").append((Object)subpatchXML.getPatchingTool()).append(" PatchType=").append((Object)subpatchXML.getPatchType()).append(" Platform=").append(subpatchXML.getPlatform());
        for (TargetType targetType : subpatchXML.getTargetTypes()) {
            stringBuffer.append("\n   ").append(this.targetTypetoString(targetType));
        }
        return stringBuffer.toString();
    }
}

