/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectionHelper {
    private static Map<String, Class<?>> _mapNameToClass = new HashMap();

    public static Object process(String className, Object object, String methodName, Class<Object>[] argTypes, Object[] args) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionHelper.process(className, object, methodName, argTypes, args, null);
    }

    public static Object process(String className, Object object, String methodName, Class<Object>[] argTypes, Object[] args, ClassLoader classloader) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<Object> classZ;
        if (classloader == null) {
            classloader = ReflectionHelper.class.getClassLoader();
        }
        if (object != null) {
            classZ = object.getClass();
        } else {
            classZ = _mapNameToClass.get(className);
            if (classZ == null) {
                classZ = classloader.loadClass(className);
                _mapNameToClass.put(className, classZ);
            }
        }
        Method m = classZ.getMethod(methodName, argTypes);
        return m.invoke(object, args);
    }

    public static Object processStaticMethod(String className, String methodName, Class<Object>[] argTypes, Object[] args, ClassLoader classloader) throws NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (classloader == null) {
            classloader = ReflectionHelper.class.getClassLoader();
        }
        Class<Object> classZ = classloader.loadClass(className);
        Method m = classZ.getMethod(methodName, argTypes);
        return m.invoke(null, args);
    }

    public static Object createObject(String className, Class<?>[] argTypes, Object[] args, ClassLoader classloader) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> classZ;
        if (classloader == null) {
            classloader = ReflectionHelper.class.getClassLoader();
        }
        if ((classZ = _mapNameToClass.get(className)) == null) {
            classZ = classloader.loadClass(className);
            _mapNameToClass.put(className, classZ);
        }
        Constructor<?> constructor = classZ.getDeclaredConstructor(argTypes);
        return constructor.newInstance(args);
    }

    public static Field getDeclaredField(String className, String name) throws SecurityException, NoSuchFieldException, ClassNotFoundException {
        Class<?> classZ = ReflectionHelper.loadClass(className);
        if (classZ != null) {
            return classZ.getDeclaredField(name);
        }
        return null;
    }

    public static Class<?> getDeclaredClass(String className, String innerClassName) throws ClassNotFoundException {
        Class<?> classZ = ReflectionHelper.loadClass(className);
        if (classZ != null) {
            for (Class<?> innerClass : classZ.getDeclaredClasses()) {
                if (!innerClass.getName().equals(innerClassName)) continue;
                return innerClass;
            }
        }
        return null;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        return clazz;
    }
}

