/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.PrePostVisitorAdapter;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeDataModel;
import com.oracle.cie.common.comdev.TreeFilter;
import com.oracle.cie.common.comdev.TreeHelper;
import com.oracle.cie.common.comdev.TreeVisitor;
import java.beans.PropertyVetoException;

public class TreeAttrHelper {
    public static final String DISABLED_ATTR = "disabled";
    public static final String SELECTABLE_ATTR = "selectable";
    public static final String SELECTED_ATTR = "selected";

    public static void mirrorAttribute(Tree source, Tree dest, TreeDataModel destModel, String attrName) {
        MirrorAttributeVisitor visitor = new MirrorAttributeVisitor(destModel, attrName);
        TreeHelper.coDdepthFirstTraversal(source, dest, visitor);
    }

    public static boolean isAttributeIdentical(Tree source, Tree dest, String attrName, Object defaultVal) {
        IdenticalAttributeVisitor visitor = new IdenticalAttributeVisitor(attrName, defaultVal);
        TreeHelper.coDdepthFirstTraversal(source, dest, visitor);
        return visitor.isIdentical();
    }

    public static void removeAttribute(Tree t, Object key) {
        if (t.hasAttributes()) {
            t.getAttributes().removeAttribute(key);
        }
    }

    public static boolean getBooleanAttribute(Tree t, Object key) {
        if (!t.hasAttributes()) {
            return false;
        }
        Boolean b = (Boolean)t.getAttributes().getAttribute(key, Boolean.FALSE);
        return b;
    }

    public static void setBooleanAttribute(Tree t, Object key, boolean b) {
        t.getAttributes().setAttribute(key, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isSelected(Tree t) {
        return TreeAttrHelper.getBooleanAttribute(t, SELECTED_ATTR);
    }

    public static void setSelected(Tree t, boolean b) {
        TreeAttrHelper.setBooleanAttribute(t, SELECTED_ATTR, b);
    }

    public static boolean isSelectable(Tree t) {
        return TreeAttrHelper.getBooleanAttribute(t, SELECTABLE_ATTR);
    }

    public static void setSelectable(Tree t, boolean b) {
        TreeAttrHelper.setBooleanAttribute(t, SELECTABLE_ATTR, b);
    }

    public static boolean isDisabled(Tree t) {
        return TreeAttrHelper.getBooleanAttribute(t, DISABLED_ATTR);
    }

    public static void setDisabled(Tree t, boolean b) {
        TreeAttrHelper.setBooleanAttribute(t, DISABLED_ATTR, b);
    }

    public static class IdenticalAttributeVisitor
    extends PrePostVisitorAdapter {
        private String _attrName;
        private Object _defaultVal;
        private boolean _identical = true;

        public IdenticalAttributeVisitor(String attrName, Object defaultVal) {
            this._attrName = attrName;
            this._defaultVal = defaultVal;
        }

        @Override
        public void preVisit(Object o1, Object o2) {
            Object v2;
            Tree source = (Tree)o1;
            Tree dest = (Tree)o2;
            Object v1 = source.hasAttributes() ? source.getAttributes().getAttribute(this._attrName, this._defaultVal) : null;
            Object object = v2 = dest.hasAttributes() ? dest.getAttributes().getAttribute(this._attrName, this._defaultVal) : null;
            if (this._defaultVal == null) {
                this._identical = v1 != null && v1.equals(v2) || v2 != null && v2.equals(v1) || v1 == v2;
            } else {
                assert (v1 != null && v2 != null);
                this._identical = v1.equals(v2);
            }
        }

        @Override
        public boolean isDone() {
            return !this._identical;
        }

        public boolean isIdentical() {
            return this._identical;
        }
    }

    public static class MirrorAttributeVisitor
    extends PrePostVisitorAdapter {
        private TreeDataModel _destModel;
        private String _attrName;

        public MirrorAttributeVisitor(TreeDataModel destModel, String attrName) {
            this._destModel = destModel;
            this._attrName = attrName;
        }

        @Override
        public void preVisit(Object o1, Object o2) {
            Tree source = (Tree)o1;
            Tree dest = (Tree)o2;
            Object val = source.hasAttributes() ? source.getAttributes().getAttribute(this._attrName) : null;
            try {
                if (val == null) {
                    this._destModel.removeAttribute(dest, this._attrName);
                } else {
                    this._destModel.setAttribute(dest, this._attrName, val);
                }
            }
            catch (PropertyVetoException pe) {
                pe.printStackTrace();
            }
        }
    }

    public static class SetAttrVisitor
    extends TreeVisitor {
        private TreeDataModel _model;
        private Object _attrKey;
        private Object _attrVal;
        private PropertyVetoException _exception;

        public SetAttrVisitor(TreeDataModel model, Object key, Object val) {
            this._model = model;
            this._attrKey = key;
            this._attrVal = val;
        }

        @Override
        public void visitTree(Tree t, TreeFilter filter) {
            try {
                this._model.setAttribute(t, this._attrKey, this._attrVal);
            }
            catch (PropertyVetoException e) {
                this._exception = e;
            }
        }

        @Override
        public boolean isDone() {
            return this._exception != null;
        }

        public PropertyVetoException getException() {
            return this._exception;
        }
    }
}

