/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.Attributes;
import com.oracle.cie.common.comdev.MVetoableChangeSupport;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeFilter;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;

public class TreeDataModel {
    public static final String SET_ROOT_EVENT = "setRoot";
    public static final String SET_KEY_EVENT = "setKey";
    public static final String SET_ATTRIBUTE_EVENT = "setAttr";
    public static final String REMOVE_ATTRIBUTE_EVENT = "removeAttr";
    public static final String ADD_SUBTREE_EVENT = "addSubtree";
    public static final String INSERT_SUBTREE_EVENT = "insertSubtree";
    public static final String REMOVE_SUBTREE_EVENT = "removeSubtree";
    public static final String RELOAD_EVENT = "reload";
    private Tree _root;
    private TreeFilter _filter;
    private MVetoableChangeSupport _propertySupport = new MVetoableChangeSupport();

    public TreeDataModel(Tree root) {
        this._root = root;
    }

    public Tree getRoot() {
        return this._root;
    }

    public void setRoot(Tree root) throws PropertyVetoException {
        Tree oldRoot = this._root;
        this._propertySupport.fireVetoableChange(this, SET_ROOT_EVENT, oldRoot, root);
        this._root = root;
        if (this._filter != null) {
            this._filter.setRoot(this._root);
        }
    }

    public TreeFilter getFilter() {
        return this._filter;
    }

    public void setFilter(TreeFilter filter) {
        this._filter = filter;
        if (this._filter != null) {
            this._filter.setRoot(this._root);
        }
    }

    public Tree getSubtree(Tree root, Tree t, int index) {
        return this._filter == null ? t.getSubtree(index) : this._filter.getSubtree(t, index);
    }

    public int getDegree(Tree root, Tree t) {
        return this._filter == null ? t.getDegree() : this._filter.getDegree(t);
    }

    public int getIndexOfSubtree(Tree root, Tree parent, Tree child) {
        return this._filter == null ? parent.getIndexOfSubtree(child) : this._filter.getIndexOfSubtree(parent, child);
    }

    public boolean isLeaf(Tree root, Tree node) {
        return this._filter == null ? node.isLeaf() : this._filter.isLeaf(node);
    }

    public void setKey(Tree t, Object key) throws PropertyVetoException {
        Object oldValue = t.getKey();
        t.setKey(key);
        try {
            this._propertySupport.fireVetoableChange(t, SET_KEY_EVENT, oldValue, key);
        }
        catch (PropertyVetoException e) {
            t.setKey(oldValue);
            throw e;
        }
    }

    public void setAttribute(Tree t, Object key, Object value) throws PropertyVetoException {
        Attributes attrs = t.getAttributes();
        Object oldValue = attrs.getAttribute(key);
        if (oldValue == null && value instanceof Boolean) {
            oldValue = Boolean.FALSE;
        }
        attrs.setAttribute(key, value);
        try {
            this._propertySupport.fireVetoableChange(t, SET_ATTRIBUTE_EVENT + key, oldValue, value);
        }
        catch (PropertyVetoException e) {
            attrs.setAttribute(key, oldValue);
            throw e;
        }
    }

    public void removeAttribute(Tree t, Object key) throws PropertyVetoException {
        Attributes attrs = t.getAttributes();
        Object oldValue = attrs.getAttribute(key);
        attrs.removeAttribute(key);
        try {
            this._propertySupport.fireVetoableChange(t, REMOVE_ATTRIBUTE_EVENT + key, oldValue, null);
        }
        catch (PropertyVetoException e) {
            attrs.setAttribute(key, oldValue);
            throw e;
        }
    }

    public Tree addSubtree(Tree parent, Tree subtree) throws PropertyVetoException {
        Tree result = parent.addSubtree(subtree);
        try {
            this._propertySupport.fireVetoableChange(parent, ADD_SUBTREE_EVENT, null, subtree);
        }
        catch (PropertyVetoException e) {
            parent.removeSubtree(result);
            throw e;
        }
        return result;
    }

    public Tree insertSubtree(Tree parent, int index, Tree subtree) throws PropertyVetoException {
        Tree result = parent.insertSubtree(index, subtree);
        try {
            this._propertySupport.fireVetoableChange(parent, INSERT_SUBTREE_EVENT, null, subtree);
        }
        catch (PropertyVetoException e) {
            parent.removeSubtree(result);
            throw e;
        }
        return result;
    }

    public Tree removeSubtree(Tree subtree) throws PropertyVetoException {
        Tree parent = subtree.getParent();
        if (parent == null) {
            return null;
        }
        this._propertySupport.fireVetoableChange(parent, REMOVE_SUBTREE_EVENT, subtree, null);
        return parent.removeSubtree(subtree);
    }

    public void reload(Tree t) {
        try {
            this._propertySupport.fireVetoableChange(t, RELOAD_EVENT, null, null);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this._propertySupport.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this._propertySupport.removeVetoableChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this._propertySupport.addVetoableChangeListener(propertyName, listener);
    }

    public synchronized void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this._propertySupport.removeVetoableChangeListener(propertyName, listener);
    }
}

