/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.net;

import com.oracle.cie.common.comdev.Base64;
import com.oracle.cie.common.net.DownloadEvent;
import com.oracle.cie.common.net.DownloadFile;
import com.oracle.cie.common.net.DownloadListener;
import com.oracle.cie.common.net.Downloader;
import com.oracle.cie.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DownloaderImpl
implements Downloader {
    protected DownloadFile _downloadFile;
    protected boolean _shutdown = false;
    protected boolean _aborted = false;
    protected boolean _canceled = false;
    private boolean _paused = false;
    private long _startTime = 0L;
    protected long _endTime = 0L;
    protected BufferedInputStream _bis = null;
    protected URLConnection _conn = null;
    protected byte[] _buf = null;
    protected long _totalBytesTransferred = 0L;
    protected URL _url = null;
    protected File _target = null;
    protected boolean _resume = true;
    protected RandomAccessFile _targetFile = null;
    protected String _targetFilePath = "";
    protected long _expectedBytes = -1L;
    protected Exception _rootCauseException = null;
    protected List<DownloadListener> _listenerList = Collections.synchronizedList(new ArrayList(5));
    protected boolean _generateDataTransferEvents = true;
    protected long _start = 0L;
    protected int _connectTimeout = 30000;
    protected int _readTimeout = 30000;

    protected DownloaderImpl(DownloadFile dlf) throws IOException {
        this(dlf, 8192);
    }

    protected DownloaderImpl(DownloadFile dlf, boolean resume) throws IOException {
        this(dlf, 8192, resume);
    }

    protected DownloaderImpl(DownloadFile dlf, int bufferSize) throws IOException {
        this(dlf, bufferSize, true);
    }

    protected DownloaderImpl(DownloadFile dlf, int bufferSize, boolean resume) throws IOException {
        if (dlf == null) {
            throw new IllegalArgumentException("DownloadFile must not be null!");
        }
        this._downloadFile = dlf;
        this._target = dlf.getFile();
        if (this._target == null) {
            throw new IllegalArgumentException("DownloadFile must contain a valid destination file!");
        }
        this._targetFilePath = this._target.getPath();
        this._url = dlf.getUrl();
        if (this._url == null) {
            throw new IllegalArgumentException("DownloadFile must contain a valid url!");
        }
        this._buf = new byte[bufferSize];
        this._resume = resume;
        this._expectedBytes = dlf.getExpectedFileSize();
        if (this._expectedBytes < 0L) {
            this._expectedBytes = 0L;
        }
        if (this._resume && this._target.exists()) {
            this._start = this._target.length();
            if (this._expectedBytes >= this._start) {
                this._expectedBytes -= this._start;
            }
        }
    }

    @Override
    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this._readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    @Override
    public DownloadFile getDownloadFile() {
        return this._downloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object password;
        this._startTime = System.currentTimeMillis();
        this.fireDownloadInit();
        try {
            this._conn = this._url.openConnection();
            this._conn.setConnectTimeout(this._connectTimeout);
            this._conn.setReadTimeout(this._readTimeout);
            String username = this._downloadFile.getUsername();
            password = this._downloadFile.getPassword();
            if (!StringUtil.isNullOrEmpty(username, true) && !StringUtil.isNullOrEmpty((String)password, true)) {
                String userPassword = username + ":" + (String)password;
                String encoding = Base64.bytesToBase64(userPassword.getBytes());
                encoding = encoding.replaceAll("\n", "");
                this._conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            if (this._start > 0L) {
                this._conn.setRequestProperty("Range", "bytes=" + this._start + "-");
            }
            this._bis = new BufferedInputStream(this._conn.getInputStream());
            this._expectedBytes = this._conn.getContentLength();
            if (this._expectedBytes == 0L) {
                this.shutdown();
            }
            this.fireDownloadBegun();
        }
        catch (IOException iox) {
            this._rootCauseException = iox;
            this.shutdown();
        }
        while (!this._shutdown) {
            if (Thread.interrupted() || this._paused) {
                password = this;
                synchronized (password) {
                    try {
                        this.fireDownloadPaused();
                        this.wait();
                        this.fireDownloadResumed();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                int bytesRead = this._bis.read(this._buf);
                if (bytesRead == -1) {
                    this.shutdown();
                    continue;
                }
                if (this._targetFile == null) {
                    if (!this._resume && this._target.exists() && !this._target.delete()) {
                        this._rootCauseException = new IOException("Unable to delete file " + this._target);
                        this.shutdown();
                        continue;
                    }
                    File parent = this._target.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    this._targetFile = new RandomAccessFile(this._target, "rw");
                    this._start = this._targetFile.length();
                    this._targetFile.seek(this._start);
                }
                this._targetFile.write(this._buf, 0, bytesRead);
                this._totalBytesTransferred += (long)bytesRead;
                if (!this._generateDataTransferEvents) continue;
                this.fireDownloadTransfer(bytesRead);
            }
            catch (IOException iox) {
                this._rootCauseException = iox;
                this.shutdown();
            }
        }
        this.closeAll();
        if (this._aborted) {
            this._rootCauseException = new IOException("Download of " + this._url + " aborted.");
            this.fireDownloadFailed();
        } else if (this._canceled) {
            this.fireDownloadCanceled();
        } else {
            if (this._rootCauseException == null) {
                this._rootCauseException = this._downloadFile.verify();
            }
            if (this._rootCauseException == null && (this._expectedBytes == 0L || this._totalBytesTransferred == this._expectedBytes)) {
                this.fireDownloadFinished();
            } else {
                if (this._rootCauseException == null) {
                    this._rootCauseException = new IOException("Download of " + this._url + " failed. Transferred bytes (" + this._totalBytesTransferred + ") did not match expected bytes (" + this._expectedBytes + ").");
                }
                this.fireDownloadFailed();
            }
        }
    }

    protected final void closeAll() {
        if (this._conn != null && this._conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this._conn).disconnect();
        }
        try {
            if (this._bis != null) {
                this._bis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this._targetFile != null) {
                this._targetFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setGenerateDataTransferEvents(boolean b) {
        this._generateDataTransferEvents = b;
    }

    @Override
    public boolean isGeneratingDataTransferEvents() {
        return this._generateDataTransferEvents;
    }

    @Override
    public synchronized void setTransferBufferSize(int size) throws UnsupportedOperationException {
        if (this._startTime != 0L) {
            throw new UnsupportedOperationException("Can't change buffer size of an active download!");
        }
        this._buf = new byte[size];
    }

    @Override
    public int getTransferBufferSize() {
        return this._buf.length;
    }

    public String getURLString() {
        return this._url.toString();
    }

    @Override
    public String getTargetFilePath() {
        return this._targetFilePath;
    }

    @Override
    public long getTotalBytesTransferred() {
        return this._totalBytesTransferred;
    }

    @Override
    public long getExpectedBytes() {
        return this._expectedBytes;
    }

    @Override
    public synchronized void resume() {
        this._paused = false;
        this.notify();
    }

    @Override
    public synchronized void pause() {
        this._paused = true;
        this.notify();
    }

    @Override
    public synchronized void shutdown() {
        this._shutdown = true;
        this.notify();
    }

    @Override
    public void abort() {
        this._aborted = true;
        this.shutdown();
    }

    @Override
    public boolean isPaused() {
        return this._paused;
    }

    @Override
    public synchronized void cancel() {
        if (!this._shutdown) {
            this._canceled = true;
            this.shutdown();
        }
    }

    protected void fireDownloadInit() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(6);
        for (DownloadListener dl : this._listenerList) {
            dl.downloadInit(e);
        }
    }

    private void fireDownloadBegun() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(7);
        for (DownloadListener dl : this._listenerList) {
            dl.downloadBegun(e);
        }
    }

    protected void fireDownloadFailed() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(5);
        e.setEndTime(System.currentTimeMillis());
        e.setRootCause(this._rootCauseException);
        for (DownloadListener dl : this._listenerList) {
            dl.downloadFailed(e);
        }
    }

    protected void fireDownloadCanceled() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(8);
        e.setEndTime(System.currentTimeMillis());
        for (DownloadListener dl : this._listenerList) {
            dl.downloadCanceled(e);
        }
    }

    protected void fireDownloadTransfer(int bytesTransferred) {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(1);
        e.setBytesTransferred(bytesTransferred);
        for (DownloadListener dl : this._listenerList) {
            dl.dataTransfer(e);
        }
    }

    protected void fireDownloadPaused() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(3);
        for (DownloadListener dl : this._listenerList) {
            dl.downloadPaused(e);
        }
    }

    private void fireDownloadResumed() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(4);
        for (DownloadListener dl : this._listenerList) {
            dl.downloadResumed(e);
        }
    }

    protected void fireDownloadFinished() {
        DownloadEvent e = this.makeDownloadEvent();
        e.setAction(2);
        e.setEndTime(System.currentTimeMillis());
        for (DownloadListener dl : this._listenerList) {
            dl.downloadComplete(e);
        }
    }

    protected DownloadEvent makeDownloadEvent() {
        DownloadEvent e = new DownloadEvent(this);
        e.setStartTime(this._startTime);
        if (this._targetFilePath != null) {
            e.setFilename(this._targetFilePath);
        }
        e.setUrl(this._url.toString());
        e.setTotalBytesTransferred(this._totalBytesTransferred);
        e.setExpectedBytes(this._expectedBytes);
        e.setDownloader(this);
        return e;
    }

    @Override
    public void addDownloadListener(DownloadListener dl) {
        this._listenerList.add(dl);
    }

    @Override
    public void removeDownloadListener(DownloadListener dl) {
        this._listenerList.remove(dl);
    }
}

