/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.DefaultCheckBoxComboModel;
import com.oracle.cie.common.util.ResourceBundleManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CheckBoxComboComponent
extends JComboBox {
    private static final Logger _log = Logger.getLogger(CheckBoxComboComponent.class.getName());
    private boolean _itemChanged = false;
    public static final String SELECTION_CHANGES = "selectionChanges";

    public CheckBoxComboComponent() {
        super(new DefaultCheckBoxComboModel());
        this.init();
    }

    public CheckBoxComboComponent(DefaultCheckBoxComboModel model) {
        super(model);
        this.init();
    }

    public CheckBoxComboComponent(Object[] items) {
        super(new DefaultCheckBoxComboModel(items));
        this.init();
    }

    public Object getValue() {
        return this.getModel().getValue();
    }

    public int getSelectedItemCount() {
        return this.getModel().getSelectedItemCount();
    }

    public DefaultCheckBoxComboModel getModel() {
        return (DefaultCheckBoxComboModel)super.getModel();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        try {
            Boolean state = this.getModel().getItemState(anObject);
            this.fireVetoableChange(SELECTION_CHANGES, state, state == false);
        }
        catch (PropertyVetoException e) {
            _log.log(Level.FINE, "Operation to un-select the last item of combo-box is not permitted.", e);
            this._itemChanged = true;
            return;
        }
        super.setSelectedItem(anObject);
        super.setToolTipText(this.getModel().getDisplayValue());
    }

    public void setModel(ComboBoxModel model) {
        if (!(model instanceof DefaultCheckBoxComboModel)) {
            _log.warning("Can not cast the given model " + model.getClass().getCanonicalName() + " to " + DefaultCheckBoxComboModel.class.getCanonicalName());
            throw new IllegalArgumentException("Unsupported Model type");
        }
        super.setModel(model);
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this._itemChanged) {
            super.setPopupVisible(this._itemChanged);
        } else {
            super.setPopupVisible(v);
        }
        this._itemChanged = false;
    }

    private void init() {
        this.setRenderer(new CheckComboBoxRenderer());
        this.setEditable(false);
        this.addKeyListener(new KeyListenerImpl());
        this.addActionListener(this.getActionListener());
        this.getAccessibleContext().setAccessibleDescription("Use arrow key to open combobox, and use space bar to select or de-select items");
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((long)e.getModifiers() == 16L) {
                    CheckBoxComboComponent.this.getModel().toggleSelection();
                    CheckBoxComboComponent.this._itemChanged = true;
                } else {
                    JComboBox cb = (JComboBox)e.getSource();
                    boolean state = CheckBoxComboComponent.this.getModel().getItemState(cb.getSelectedItem());
                    String oldValue = cb.getAccessibleContext().getAccessibleChild(0).getAccessibleContext().getAccessibleDescription();
                    cb.getAccessibleContext().getAccessibleChild(0).getAccessibleContext().firePropertyChange("AccessibleDescription", oldValue, " check box  is " + (state ? "checked" : "not checked"));
                }
            }
        };
    }

    private class CheckComboBoxRenderer
    implements ListCellRenderer {
        private JCheckBox _checkBox = new JCheckBox();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && index > -1) {
                String field = value != null ? value.toString() : null;
                list.setToolTipText(value.toString());
                this._checkBox.setText(field);
                this._checkBox.setSelected(CheckBoxComboComponent.this.getModel().getItemState(value));
                this._checkBox.setBackground(isSelected ? Color.GRAY : null);
                String decription = this._checkBox.isSelected() ? ResourceBundleManager.getString("comdev", "CheckBoxComboComponent.checkbox.checked") : ResourceBundleManager.getString("comdev", "CheckBoxComboComponent.checkbox.notChecked");
                this._checkBox.getAccessibleContext().setAccessibleName(value.toString() + decription);
                return this._checkBox;
            }
            return new JLabel(CheckBoxComboComponent.this.getModel().getDisplayValue());
        }
    }

    private class KeyListenerImpl
    implements KeyListener {
        private KeyListenerImpl() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                CheckBoxComboComponent.this.getModel().toggleSelection();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                CheckBoxComboComponent.this._itemChanged = true;
            }
        }
    }
}

