/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class FileChooserRegExFileFilter
extends FileFilter {
    private String[] _filters = new String[0];
    private String _description = "All Files";

    public FileChooserRegExFileFilter(String wildcards) {
        this(wildcards, wildcards);
    }

    public FileChooserRegExFileFilter(String wildcards, String desc) {
        if (wildcards != null && !"".equals(wildcards)) {
            if (wildcards.indexOf(",") != -1) {
                StringTokenizer toke = new StringTokenizer(wildcards, ",");
                this._filters = new String[toke.countTokens()];
                int x = 0;
                while (toke.hasMoreTokens()) {
                    this._filters[x++] = toke.nextToken();
                }
            } else {
                this._filters = new String[1];
                this._filters[0] = wildcards;
            }
        }
        this._description = desc;
    }

    @Override
    public boolean accept(File f) {
        if (this._filters.length == 0 || f.isDirectory()) {
            return true;
        }
        String file = f.getName();
        for (int x = 0; x < this._filters.length; ++x) {
            if (!file.matches(this._filters[x])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }
}

