/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoad {
    static final Logger s_logger = Logger.getLogger(ClassLoad.class.getName());
    private String[] _classpath;
    private URL[] _urlClasspath;
    private String _classname;
    private Object[] _args;
    private String _method = "main";
    private Properties _props;
    private Class[] _argTypes;
    private boolean _static = false;
    private boolean _internal = false;
    private Properties _sysProps = System.getProperties();

    public ClassLoad(String classname, String method, String classpath, String argz, String props) {
        this._classname = classname;
        this._method = method;
        this._classpath = classpath != null ? classpath.split(File.pathSeparator) : new String[]{};
        this.setURLClasspath(this._classpath);
        this.setArgs(argz, "main".equals(method));
        this.setProperties(props);
    }

    public ClassLoad(String classname, String[] classpath, String[] args, Properties props) {
        this._classname = classname;
        this._method = "main";
        this._static = true;
        this._classpath = classpath;
        this._props = props;
        this._args = new Object[]{args};
        this._argTypes = new Class[]{String[].class};
        this.setURLClasspath(classpath);
    }

    private void setArgs(String argz, boolean isMain) {
        String[] args;
        String[] stringArray = args = argz != null ? argz.split(",") : new String[]{};
        if (isMain) {
            this._args = new Object[]{args};
            this._argTypes = new Class[]{String[].class};
        } else {
            this._args = new Object[args.length];
            this._argTypes = new Class[args.length];
            int x = 0;
            for (String arg : args) {
                this._args[x] = arg;
                this._argTypes[x++] = String.class;
            }
        }
    }

    public void setClasspath(String classpath) {
        this._classpath = classpath != null ? classpath.split(File.pathSeparator) : new String[]{};
        this.setURLClasspath(this._classpath);
    }

    public void setClass(String clazz) {
        this._classname = clazz;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setArgs(String args) {
        this.setArgs(args, "main".equals(this._method));
    }

    public void setStatic(boolean ztatic) {
        this._static = ztatic;
    }

    public void setInternal(boolean internal) {
        this._internal = internal;
    }

    public void setSystemProperties(String props) {
        this.setProperties(props);
    }

    private void setProperties(String props) {
        this._props = new Properties();
        if (props == null) {
            return;
        }
        for (String prop : props.split(";")) {
            int idx = prop.indexOf("=");
            String key = prop.substring(0, idx);
            String value = prop.substring(idx + 1);
            this._props.put(key, value);
        }
    }

    private void setURLClasspath(String[] classpath) {
        if (classpath == null || classpath.length == 0) {
            this._urlClasspath = new URL[0];
            return;
        }
        int x = 0;
        this._urlClasspath = new URL[classpath.length];
        for (String path : classpath) {
            try {
                this._urlClasspath[x++] = new File(path).toURI().toURL();
            }
            catch (MalformedURLException mue) {
                s_logger.log(Level.FINE, "Malformed URL.", mue);
            }
        }
    }

    public Object load() {
        if (s_logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append("ClassLoading: ");
            sb.append("\nClass=").append(this._classname);
            sb.append("\nMethod=").append(this._method);
            sb.append("\nargs=");
            if (this._method.equals("main") && this._static) {
                String[] args = (String[])this._args[0];
                for (int i = 0; i < args.length; ++i) {
                    sb.append("\n\t\targ[").append(i).append("]=").append((String)args[i]);
                }
            } else {
                for (Object arg : this._args) {
                    sb.append("\n\t\t").append(arg.toString());
                }
            }
            sb.append("\nprops=");
            for (String key : this._props.stringPropertyNames()) {
                sb.append("\n\t\t").append(key).append("=").append(this._props.get(key));
            }
            sb.append("\nClasspathURLs=\n");
            for (URL url : this._urlClasspath) {
                sb.append("\n\t\t").append(url.toString());
            }
            s_logger.fine(sb.toString());
        }
        if (this._props != null) {
            this._sysProps.putAll((Map<?, ?>)this._props);
            System.setProperties(this._sysProps);
        }
        Object returnVal = null;
        try {
            URLClassLoader myClassLoader;
            if (!this._internal) {
                myClassLoader = new URLClassLoader(this._urlClasspath);
                Class<?> myClass = myClassLoader.loadClass(this._classname);
                Method myMethod = myClass.getDeclaredMethod(this._method, this._argTypes);
                returnVal = this._static ? myMethod.invoke(null, this._args) : myMethod.invoke(myClass.newInstance(), this._args);
            } else {
                myClassLoader = new InternalClassLoader(this._urlClasspath);
                Class<?> myClass = myClassLoader.loadClass(this._classname);
                Method myMethod = myClass.getDeclaredMethod(this._method, this._argTypes);
                returnVal = this._static ? myMethod.invoke(null, this._args) : myMethod.invoke(myClass.newInstance(), this._args);
            }
        }
        catch (ClassNotFoundException cnfe) {
            s_logger.log(Level.FINE, "Class not found: " + this._classname, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            s_logger.log(Level.FINE, "Method not found: " + this._method, nsme);
        }
        catch (InstantiationException ie) {
            s_logger.log(Level.FINE, "Error instantiating: " + this._classname + " " + this._method, ie);
        }
        catch (IllegalAccessException iae) {
            s_logger.log(Level.FINE, "Error accessing: " + this._classname + " " + this._method, iae);
        }
        catch (InvocationTargetException ite) {
            s_logger.log(Level.FINE, "Error invoking: " + this._classname + " " + this._method, ite);
        }
        return returnVal;
    }

    class InternalClassLoader
    extends URLClassLoader {
        public InternalClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public URL getResource(String name) {
            Enumeration<URL> e;
            try {
                e = this.getResources(name);
            }
            catch (IOException ioe) {
                return null;
            }
            URL url = null;
            while (e.hasMoreElements()) {
                url = e.nextElement();
            }
            return url;
        }
    }
}

