/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileUtils {
    private static final int SUFFIX_LENGTH = 4;
    private static final int MAX_FILENAME_LENGTH = 100;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Logger s_log = Logger.getLogger(FileUtils.class.getName());

    public static String mapNameToFileName(String name) {
        byte[] bytes = null;
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            bytes = name.getBytes();
        }
        byte[] filenameBuf = new byte[1024];
        int pos = 0;
        boolean suffixRequired = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 45 || bytes[i] == 95 || bytes[i] == 43 || bytes[i] == 36) {
                filenameBuf[pos++] = bytes[i];
                continue;
            }
            if (bytes[i] >= 65 && bytes[i] <= 90) {
                filenameBuf[pos++] = bytes[i];
                suffixRequired = true;
                continue;
            }
            if (bytes[i] == 32) {
                filenameBuf[pos++] = 95;
                suffixRequired = true;
                continue;
            }
            suffixRequired = true;
            String hex = FileUtils.asHex(bytes[i]);
            byte[] hexBytes = hex.getBytes();
            System.arraycopy(hexBytes, 0, filenameBuf, pos, hexBytes.length);
            pos += hexBytes.length;
        }
        String filename = new String(filenameBuf, 0, pos);
        if (filename.length() > 100) {
            filename = filename.substring(0, 99);
            suffixRequired = true;
        }
        if (suffixRequired) {
            String hashSuffix = "" + name.hashCode();
            if (hashSuffix.length() > 4) {
                hashSuffix = hashSuffix.substring(hashSuffix.length() - 4);
            }
            return filename + "-" + hashSuffix;
        }
        return filename;
    }

    private static String asHex(int b) {
        char[] buf = new char[]{HEX_CHARS[(b & 0xF0) >> 4], HEX_CHARS[(b & 0xF) >> 0]};
        return new String(buf);
    }

    public static File getFile(String file) {
        return file == null ? null : FileUtils.getFile(new File(file));
    }

    public static File getFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception ex) {
            s_log.log(Level.SEVERE, "Wasn't able to convert file to canonical form", ex);
            return file.getAbsoluteFile();
        }
    }

    public static boolean areFilesEqual(File file1, File file2, Pattern regex) throws IOException {
        if (file1.getCanonicalPath().equals(file2.getCanonicalPath())) {
            return true;
        }
        if (file1.exists() && file2.exists() && file1.isFile() && file2.isFile()) {
            if (!StringUtil.isNullOrEmpty(regex.pattern())) {
                File tmp1 = FileUtils.replacePattern(file1, regex);
                File tmp2 = FileUtils.replacePattern(file2, regex);
                tmp1.deleteOnExit();
                tmp2.deleteOnExit();
                return FileUtils.areFilesEqual(tmp1, tmp2);
            }
            return FileUtils.areFilesEqual(file1, file2);
        }
        return false;
    }

    public static boolean areFilesEqual(File file1, File file2) throws IOException {
        int BUFFER_SIZE = 100000;
        FileInputStream input1 = null;
        InputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            ReadableByteChannel ch1 = Channels.newChannel(input1);
            ReadableByteChannel ch2 = Channels.newChannel(input2);
            ByteBuffer buf1 = ByteBuffer.allocateDirect(100000);
            ByteBuffer buf2 = ByteBuffer.allocateDirect(100000);
            while (true) {
                int n1 = ch1.read(buf1);
                int n2 = ch2.read(buf2);
                if (n1 == -1 || n2 == -1) {
                    boolean bl = n1 == n2;
                    return bl;
                }
                buf1.flip();
                buf2.flip();
                if (buf1.compareTo(buf2) != 0) {
                    boolean bl = false;
                    return bl;
                }
                buf1.clear();
                buf2.clear();
            }
        }
        finally {
            if (input1 != null) {
                ((InputStream)input1).close();
            }
            if (input2 != null) {
                input2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File replacePattern(File file, Pattern regex) throws IOException {
        File tempFile = null;
        FileInputStream input = null;
        InputStreamReader reader = null;
        Scanner scan = null;
        Scanner lineScan = null;
        StringBuilder builder = new StringBuilder();
        try {
            input = new FileInputStream(file);
            reader = new InputStreamReader(input);
            scan = new Scanner(reader);
            scan.useDelimiter(regex);
            while (scan.hasNext()) {
                String tt = scan.next();
                if (tt.trim().isEmpty()) continue;
                builder.append(tt);
            }
            int extensionIndex = file.getName().lastIndexOf(".");
            if (extensionIndex == -1) {
                extensionIndex = file.getName().length();
            }
            String fileName = file.getName().substring(0, extensionIndex);
            tempFile = File.createTempFile(fileName, ".tmp", file.getParentFile());
            BufferedWriter output = new BufferedWriter(new FileWriter(tempFile));
            try {
                output.write(builder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                ((Writer)output).close();
            }
        }
        catch (Exception e) {
            s_log.warning("Failed to replace pattern " + regex + " in file " + file + " :" + e);
            e.printStackTrace();
        }
        finally {
            if (scan != null) {
                scan.close();
            }
            if (lineScan != null) {
                lineScan.close();
            }
        }
        return tempFile;
    }
}

