/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class IsolatedClassLoader
extends URLClassLoader {
    private ClassLoader _systemCl;
    private List<String> _packages = new ArrayList<String>();

    public IsolatedClassLoader(URL[] urls, ClassLoader parent, Collection<String> packages) {
        super(urls, parent);
        this._systemCl = IsolatedClassLoader.getSystemClassLoader();
        if (this._systemCl != null) {
            ClassLoader cl;
            this._systemCl = this._systemCl.getParent();
            for (cl = parent; cl != null && !cl.equals(this._systemCl); cl = cl.getParent()) {
            }
            this._systemCl = cl;
        }
        if (packages != null) {
            for (String pkg : packages) {
                if (pkg == null) continue;
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                this._packages.add(pkg);
            }
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            if (this._systemCl != null) {
                try {
                    cls = this._systemCl.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    if (this.isReservedPackage(name)) {
                        throw new ClassNotFoundException();
                    }
                    cls = this.findClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    cls = super.loadClass(name, resolve);
                }
                catch (IllegalArgumentException iae) {
                    cls = super.findClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this._systemCl != null) {
            url = this._systemCl.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.getParent() == null) {
            return super.getResources(name);
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this._systemCl != null) {
            resources.addAll(Collections.list(this._systemCl.getResources(name)));
        }
        resources.addAll(Collections.list(this.findResources(name)));
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        while (parentResources.hasMoreElements()) {
            URL url = parentResources.nextElement();
            if (resources.contains(url)) continue;
            resources.add(url);
        }
        return Collections.enumeration(resources);
    }

    private boolean isReservedPackage(String name) {
        for (String pkg : this._packages) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

