/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xml.difftreefilter.XmlDiffRuleType;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlDiffRule {
    private Element _ruleElement;

    public XmlDiffRule(XmlDiffRuleType rule) {
        this._ruleElement = rule.getAny();
    }

    public XmlDiffRule(String elementName) throws ParserConfigurationException {
        this._ruleElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createElement(elementName);
    }

    public boolean matchesSimpleElement(String elementName, Object value) {
        if (this._ruleElement.getNodeName().equals(elementName)) {
            String textContent = this._ruleElement.getTextContent();
            return textContent == null && value == null || textContent != null && textContent.equals(value);
        }
        return false;
    }

    public boolean matchesComplexElement(String elementName, Map<String, Object> attrMap) {
        if (this._ruleElement.getNodeName().equals(elementName)) {
            for (Map.Entry<String, Object> attribute : attrMap.entrySet()) {
                if (attribute.getValue() == null || StringUtil.isNullOrEmpty(this._ruleElement.getAttribute(attribute.getKey())) || attribute.getValue().equals(this._ruleElement.getAttribute(attribute.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matchesAttribute(String elementName, String attributeName) {
        NamedNodeMap attributes;
        if (!StringUtil.isNullOrEmpty(elementName, true) && !StringUtil.isNullOrEmpty(attributeName, true) && this._ruleElement.getNodeName().equals(elementName) && (attributes = this._ruleElement.getAttributes()) != null) {
            for (int x = 0; x < attributes.getLength(); ++x) {
                Node attribute = attributes.item(x);
                if (!attributeName.equals(attribute.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }
}

