/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xml.difftreefilter.DiffTreeFilterType;
import com.oracle.cie.common.xml.difftreefilter.ObjectFactory;
import com.oracle.cie.common.xml.difftreefilter.XmlDiffRuleType;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XmlDiffTreeFilter {
    public static final String DIFF_TREE_FILTER_SCHEMA_LOCATION = "com/oracle/cie/common/xml/difftreefilter/difftreefilter.xsd";
    private static Schema _diffTreeFilterSchema;
    private List<XmlDiffRule> _includes;
    private List<XmlDiffRule> _excludes;
    private List<XmlDiffRule> _attributeExcludes;
    private Map<XmlDiffAspect, HashMap<String, Object>> attributeCache = new HashMap<XmlDiffAspect, HashMap<String, Object>>();

    public XmlDiffTreeFilter() {
        this(null, null);
    }

    public XmlDiffTreeFilter(List<XmlDiffRule> includes, List<XmlDiffRule> excludes) {
        this(includes, excludes, null);
    }

    public XmlDiffTreeFilter(List<XmlDiffRule> includes, List<XmlDiffRule> excludes, List<XmlDiffRule> attributeExcludes) {
        this.setIncludes(includes);
        this.setExcludes(excludes);
        this.setAttributeExcludes(attributeExcludes);
    }

    public boolean hasIncludeRules() {
        return this._includes.size() > 0;
    }

    public boolean hasExcludeRules() {
        return this._excludes.size() > 0 || this._attributeExcludes.size() > 0;
    }

    public void setIncludes(List<XmlDiffRule> includes) {
        this._includes = includes == null ? new ArrayList() : includes;
    }

    public void addInclude(XmlDiffRule include) {
        if (this._includes == null) {
            this._includes = new ArrayList<XmlDiffRule>();
        }
        this._includes.add(include);
    }

    public void setExcludes(List<XmlDiffRule> excludes) {
        this._excludes = excludes == null ? new ArrayList() : excludes;
    }

    public void addExclude(XmlDiffRule exclude) {
        if (this._excludes == null) {
            this._excludes = new ArrayList<XmlDiffRule>();
        }
        this._excludes.add(exclude);
    }

    public void setAttributeExcludes(List<XmlDiffRule> excludes) {
        this._attributeExcludes = excludes == null ? new ArrayList() : excludes;
    }

    public void addAttributeExclude(XmlDiffRule exclude) {
        if (this._attributeExcludes == null) {
            this._attributeExcludes = new ArrayList<XmlDiffRule>();
        }
        this._attributeExcludes.add(exclude);
    }

    public static XmlDiffTreeFilter load(String string) throws IOException {
        return XmlDiffTreeFilter.load(string, null);
    }

    public static XmlDiffTreeFilter load(String string, ClassLoader classLoader) throws IOException {
        if (StringUtil.isNullOrEmpty(string)) {
            throw new NullPointerException("The string provided was null or empty.");
        }
        try {
            return XmlDiffTreeFilter.load(new StringReader(string), classLoader);
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree filter from string " + string, e);
        }
    }

    public static XmlDiffTreeFilter load(Reader reader) throws IOException {
        return XmlDiffTreeFilter.load(reader, null);
    }

    public static XmlDiffTreeFilter load(Reader reader, ClassLoader classLoader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("The reader provided was null.");
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(XmlDiffTreeFilter.getSchema(classLoader));
            Object o = SecureUnmarshaller.unmarshal(unmarshaller, reader);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            XmlDiffTreeFilter xmlDiffTreeFilter = XmlDiffTreeFilter.getDiffTreeFilterFromFilters((DiffTreeFilterType)o);
            return xmlDiffTreeFilter;
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree filter.", e);
        }
        finally {
            reader.close();
        }
    }

    public static XmlDiffTreeFilter load(File file) throws IOException {
        return XmlDiffTreeFilter.load(file, null);
    }

    public static XmlDiffTreeFilter load(File file, ClassLoader classLoader) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file provided was null.");
        }
        try {
            return XmlDiffTreeFilter.load(new FileInputStream(file), classLoader);
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree filter from " + file, e);
        }
    }

    public static XmlDiffTreeFilter load(InputStream inputStream) throws IOException {
        return XmlDiffTreeFilter.load(inputStream, null);
    }

    public static XmlDiffTreeFilter load(InputStream inputStream, ClassLoader classLoader) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("The output stream provided was null.");
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(XmlDiffTreeFilter.getSchema(classLoader));
            Object o = SecureUnmarshaller.unmarshal(unmarshaller, inputStream);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            XmlDiffTreeFilter xmlDiffTreeFilter = XmlDiffTreeFilter.getDiffTreeFilterFromFilters((DiffTreeFilterType)o);
            return xmlDiffTreeFilter;
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree filter.", e);
        }
        finally {
            inputStream.close();
        }
    }

    private static Schema getSchema(ClassLoader classLoader) throws SAXException, IOException {
        if (_diffTreeFilterSchema == null) {
            InputStream schemaIn;
            if (classLoader == null) {
                classLoader = XmlDiffTreeFilter.class.getClassLoader();
            }
            if ((schemaIn = classLoader.getResourceAsStream(DIFF_TREE_FILTER_SCHEMA_LOCATION)) == null) {
                throw new IOException("Unable to locate xml difftreefilter schema com/oracle/cie/common/xml/difftreefilter/difftreefilter.xsd");
            }
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                _diffTreeFilterSchema = schemaFactory.newSchema(new StreamSource(schemaIn));
            }
            finally {
                try {
                    schemaIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return _diffTreeFilterSchema;
    }

    private static XmlDiffTreeFilter getDiffTreeFilterFromFilters(DiffTreeFilterType diffTreeFilterType) throws XmlDiffException {
        if (diffTreeFilterType == null) {
            throw new NullPointerException("No filtering rules were provided.");
        }
        ArrayList<XmlDiffRule> includes = new ArrayList<XmlDiffRule>();
        List<XmlDiffRuleType> diffTreeFilterTypeInclude = diffTreeFilterType.getInclude();
        for (XmlDiffRuleType ruleType : diffTreeFilterTypeInclude) {
            includes.add(new XmlDiffRule(ruleType));
        }
        ArrayList<XmlDiffRule> excludes = new ArrayList<XmlDiffRule>();
        List<XmlDiffRuleType> diffTreeFilterTypeExclude = diffTreeFilterType.getExclude();
        for (XmlDiffRuleType ruleType : diffTreeFilterTypeExclude) {
            excludes.add(new XmlDiffRule(ruleType));
        }
        ArrayList<XmlDiffRule> attributeExcludes = new ArrayList<XmlDiffRule>();
        List<XmlDiffRuleType> diffTreeFilterTypeAttributeExclude = diffTreeFilterType.getAttributeExclude();
        for (XmlDiffRuleType ruleType : diffTreeFilterTypeAttributeExclude) {
            attributeExcludes.add(new XmlDiffRule(ruleType));
        }
        return new XmlDiffTreeFilter(includes, excludes, attributeExcludes);
    }

    private boolean matchSimpleElement(String element, Object value, List<XmlDiffRule> rules) {
        for (XmlDiffRule rule : rules) {
            if (!rule.matchesSimpleElement(element, value)) continue;
            return true;
        }
        return false;
    }

    public boolean includeSimpleElement(String element, Object value) {
        return this.matchSimpleElement(element, value, this._includes);
    }

    public boolean excludeSimpleElement(String element, Object value) {
        return this.matchSimpleElement(element, value, this._excludes);
    }

    private boolean matchComplexElement(XmlDiffAspect aspect, List<XmlDiffRule> rules) {
        if (aspect != null && !rules.isEmpty()) {
            Map<String, Object> attrMap = this.getAttributesMap(aspect);
            for (XmlDiffRule rule : rules) {
                if (!rule.matchesComplexElement(aspect.getElement(), attrMap)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean includeComplexElement(XmlDiffAspect aspect) {
        return this.matchComplexElement(aspect, this._includes);
    }

    public boolean excludeComplexElement(XmlDiffAspect aspect) {
        return this.matchComplexElement(aspect, this._excludes);
    }

    public boolean excludeAttribute(XmlDiffAspect aspect, String attribute) {
        if (aspect != null) {
            for (XmlDiffRule rule : this._attributeExcludes) {
                if (!rule.matchesAttribute(aspect.getElement(), attribute)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Object> getAttributesMap(XmlDiffAspect aspect) {
        HashMap<String, Object> attrMap = this.attributeCache.get(aspect);
        if (attrMap == null) {
            attrMap = new HashMap();
        }
        for (String attr : aspect.getAttributeNames()) {
            attrMap.put(attr, aspect.getAttributeValue(attr));
        }
        this.attributeCache.put(aspect, attrMap);
        return attrMap;
    }
}

