/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.utils.configdiff;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import oracle.osysmodel.utils.configdiff.ConfigDiffException;
import oracle.osysmodel.utils.configdiff.ConfigDiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigDiff {
    protected final SystemInstance source;
    protected final SystemInstance destination;
    protected ArrayList<AbstractBaseTarget> sourceEntitiesNotFoundInDestination = new ArrayList();
    protected ArrayList<AbstractBaseTarget> destinationEntitiesNotFoundInSource = new ArrayList();
    protected boolean isDifferent;
    protected HashMap<Class<? extends AbstractBaseTarget>, List<Method>> mapAttributes;
    protected HashMap<AbstractBaseTarget, AbstractBaseTarget> equalsMap = new HashMap();

    protected ConfigDiff(SystemInstance source, SystemInstance destination) {
        this.source = source;
        this.destination = destination;
    }

    public static ConfigDiff getInstance(SystemInstance source, SystemInstance destination, HashMap<Class<? extends AbstractBaseTarget>, List<Method>> mapAttributes) {
        return new ConfigDiffUtil(source, destination, mapAttributes);
    }

    public abstract boolean diff() throws ConfigDiffException;

    public ArrayList<AbstractBaseTarget> getSourceEntitiesNotFoundInDestination() {
        return this.sourceEntitiesNotFoundInDestination;
    }

    public ArrayList<AbstractBaseTarget> getDestinationEntitiesNotFoundInSource() {
        return this.destinationEntitiesNotFoundInSource;
    }

    public boolean isDifferent() {
        return this.isDifferent;
    }

    public HashMap<AbstractBaseTarget, AbstractBaseTarget> getEqualsMap() {
        return this.equalsMap;
    }

    public String getDiffResultString() {
        String str = "\n";
        if (!this.isDifferent) {
            str = str + "Both the System Instances are EQUAL. The equal entities are: \n" + this.getEqualsMap();
            str = str + "\n";
            return str;
        }
        str = str + "The System Instances are NOT equal.\n";
        str = str + "Items that are equal: " + this.getEqualsMap();
        str = str + "\n";
        str = str + "Source Items NOT found in destination: \n\t" + this.getSourceEntitiesNotFoundInDestination();
        str = str + "\n";
        str = str + "Destination Items NOT found in source: \n\t" + this.getDestinationEntitiesNotFoundInSource();
        str = str + "\n";
        System.out.println(str);
        return str;
    }
}

