/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.repository.patch;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.SessionResults;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;
import oracle.opatchauto.core.patchanalyzer.systempatch.SubpatchModel;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;

public class PatchInfoCollector {
    private ArrayList<String> allPatches = null;

    public List<String> collectPatchInfo(String patchLocation, boolean isDirectory) throws OPatchAutoException {
        if (this.allPatches != null && this.allPatches.size() > 0) {
            return this.allPatches;
        }
        SessionPatches patches = new SessionPatches();
        SessionResults addPatchResults = new SessionResults();
        addPatchResults = isDirectory ? patches.addParentLocn(patchLocation) : patches.addPatch(patchLocation);
        if (addPatchResults.getSuccessfulPatches().size() < 1) {
            if (isDirectory) {
                throw new OPatchAutoException(addPatchResults.collectSessionSummary(), new Object[0]);
            }
            throw new OPatchAutoException(addPatchResults.collectSessionSummary(), new Object[0]);
        }
        List patch_locations = patches.getAllRegisteredPatches();
        if (patch_locations.size() < 1) {
            OACLogger.severe((String)"INVALID : No patches have been registered for this session");
            throw new OPatchAutoException("Invalid patch location", new Object[0]);
        }
        this.allPatches = new ArrayList();
        for (String patch_locn : patch_locations) {
            SessionPatches.PatchType patch_type = SessionPatches.getPatchType((String)patch_locn);
            if (SessionPatches.PatchType.SYSTEM_PATCH == patch_type) {
                OACLogger.info((String)("This patch is detected to be a System Patch: " + patch_locn));
                List<String> allSubPatches = this.getSubPatchesInSystemPatch(patch_locn);
                this.allPatches.addAll(allSubPatches);
                continue;
            }
            if (SessionPatches.PatchType.ONE_OFF != patch_type && SessionPatches.PatchType.COMPOSITE != patch_type) continue;
            this.allPatches.add(patch_locn);
        }
        return this.allPatches;
    }

    private List<String> getSubPatchesInSystemPatch(String patch_locn) {
        List subPatchList;
        SystemPatchBundleXML systemPatchDetails;
        ArrayList<String> patch_locations = new ArrayList<String>();
        PatchAnalyzer patchAnalyzer = new PatchAnalyzer();
        if (patchAnalyzer.isPatchvalid(patch_locn) && (systemPatchDetails = patchAnalyzer.analyzePatch(patch_locn)) != null && (subPatchList = systemPatchDetails.getSubpatchList()) != null && subPatchList.size() > 0) {
            String bundlePatchLoc = this.removeFileSeperatorAtEnd(systemPatchDetails.getPatchLocation());
            for (SubpatchModel subPatch : subPatchList) {
                StringBuffer subPatchLocation = new StringBuffer(bundlePatchLoc);
                subPatchLocation.append(File.separator);
                subPatchLocation.append(subPatch.getLocation());
                patch_locations.add(subPatchLocation.toString());
            }
        }
        return patch_locations;
    }

    private String removeFileSeperatorAtEnd(String source) {
        String tmpS = source;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        source = tmpS;
        return source;
    }
}

