/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationFailureReason;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RHPOptionsValidator
implements RHPValidator {
    private final Logger _logger = Logger.getLogger(RHPOptionsValidator.class.getName());

    @Override
    public RHPValidationResult validate(OPatchAutoRHPOptions options) {
        RHPValidationResult result = null;
        try {
            String value;
            String oracleHome = options.getOption("home").getValue();
            OracleHomeInformationLoader.OracleHomeType oracleHomeType = OracleHomeInformationLoader.getInstance().getHomeType(oracleHome);
            HashSet<String> unSupportedOptions = new HashSet<String>();
            for (String unSupportedOptionKey : this.getUnsupportedOptions(oracleHomeType)) {
                OPatchAutoOption unSupportedOption = options.getOption(unSupportedOptionKey);
                Boolean hasValue = unSupportedOption.isSwitch() ? unSupportedOption.isSwitchEnabled() : unSupportedOption.hasValue();
                if (!hasValue.booleanValue()) continue;
                unSupportedOptions.add(unSupportedOption.getArg());
            }
            if (unSupportedOptions.size() > 0) {
                this._logger.fine("The options " + unSupportedOptions + " are not supported for " + (Object)((Object)oracleHomeType) + " of home " + oracleHome);
                result = new RHPValidationResult(RHPValidator.ValidatorID.OPTIONS_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.OPTIONS_FOR_HOME_NOT_VALID, new Object[]{unSupportedOptions, oracleHome, oracleHomeType});
            }
            if (options.getOption("batches").hasValue() && !StringUtil.isNullOrEmpty((String)(value = options.getOption("batches").getValue()))) {
                Matcher matcher = Pattern.compile("\\[(.*?)\\]").matcher(value);
                ArrayList<String> nodeList = new ArrayList<String>();
                while (matcher.find()) {
                    String nodes = matcher.group(1);
                    if (nodes.contains(",")) {
                        String[] nodeArray = nodes.split(",");
                        Collections.addAll(nodeList, nodeArray);
                        continue;
                    }
                    nodeList.add(nodes.trim());
                }
                List<String> hostList = OracleHomeInformationLoader.getInstance().getHostList();
                ArrayList<String> invalidHosts = new ArrayList<String>();
                for (String node : nodeList) {
                    if (hostList.contains(node)) continue;
                    invalidHosts.add(node);
                }
                if (invalidHosts.size() > 0) {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.OPTIONS_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.HOSTNAME_NOT_VALID, invalidHosts);
                }
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        if (result == null) {
            result = new RHPValidationResult(RHPValidator.ValidatorID.OPTIONS_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
        }
        return result;
    }

    private List<String> getUnsupportedOptions(OracleHomeInformationLoader.OracleHomeType oracleHomeType) {
        ArrayList<String> unSupportedOptions = new ArrayList<String>();
        switch (oracleHomeType) {
            case CRS: {
                unSupportedOptions.add("drain.timeout");
                unSupportedOptions.add("stopoption");
                break;
            }
            case RAC: 
            case SIDB: {
                unSupportedOptions.add("batches");
                unSupportedOptions.add("saf");
                break;
            }
        }
        return unSupportedOptions;
    }
}

