/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.common.nio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import oracle.glcm.common.nio.FileSystemHandler;
import oracle.glcm.common.nio.FileSystemType;
import oracle.glcm.common.nio.NioService;

public class NioServiceImpl
implements NioService {
    private FileSystemHandler _fileSystemHandler;

    NioServiceImpl(FileSystemType fileSystemType) {
        this.setFileSystemType(fileSystemType);
    }

    private void setFileSystemType(FileSystemType fileSystemType) {
        if (fileSystemType != null && fileSystemType != FileSystemType.File) {
            try {
                this._fileSystemHandler = (FileSystemHandler)NioServiceImpl.class.getClassLoader().loadClass(fileSystemType.getHandlerClassName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to load file system handler for " + (Object)((Object)fileSystemType), e);
            }
        } else {
            this._fileSystemHandler = null;
        }
    }

    @Override
    public void newFileSystem(Path fileSystemPath) throws IOException {
        if (this.hasFileSystemHandler()) {
            this.getFileSystemHandler().newFileSystem(fileSystemPath);
        }
    }

    @Override
    public void newFileSystem(Path fileSystemPath, Map<String, Object> env) throws IOException {
        if (this.hasFileSystemHandler()) {
            this.getFileSystemHandler().newFileSystem(fileSystemPath, env);
        }
    }

    @Override
    public FileSystemType getFileSystemType() {
        return this._fileSystemHandler != null ? this._fileSystemHandler.getType() : null;
    }

    @Override
    public FileSystemHandler getFileSystemHandler() {
        return this._fileSystemHandler;
    }

    @Override
    public boolean hasFileSystemHandler() {
        return this.getFileSystemHandler() != null;
    }

    @Override
    public URI getURI(String pathString) throws URISyntaxException {
        String scheme;
        if (pathString == null) {
            throw new NullPointerException("The path string provided was null.");
        }
        String string = scheme = this.hasFileSystemHandler() ? this.getFileSystemHandler().getScheme() : null;
        if (scheme == null) {
            scheme = "file";
        }
        return new URI(scheme, null, pathString.replace("\\", "/"), null);
    }

    @Override
    public Path getPath(File file) {
        return file != null ? this.getPath(file.getAbsolutePath(), new String[0]) : null;
    }

    @Override
    public Path getPath(String first, String ... more) {
        Path path = Paths.get(first, more);
        FileSystem fileSystem = this.getFileSystem(path);
        return fileSystem != null ? fileSystem.getPath(first, more) : path;
    }

    @Override
    public Path getPath(URI uri) {
        Path path = Paths.get(uri);
        FileSystem fileSystem = this.getFileSystem(path);
        return fileSystem != null ? fileSystem.provider().getPath(uri) : path;
    }

    @Override
    public FileSystem getFileSystem(Path path) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getFileSystemForPath(path) : null;
    }

    @Override
    public Path getInternalPath(Path path) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getInternalPath(path) : path;
    }

    @Override
    public URL getURL(final Path path) throws MalformedURLException {
        if (this.hasFileSystemHandler()) {
            return new URL("file", null, -1, path.toString(), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return Files.newInputStream(path, new OpenOption[0]);
                        }
                    };
                }
            });
        }
        return path.toUri().toURL();
    }

    @Override
    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().copy(in, target, options) : Files.copy(in, target, options);
    }

    @Override
    public CopyOption getChecksumCopyOption(String checksum) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getChecksumCopyOption(checksum) : null;
    }
}

