/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import oracle.glcm.opatch.common.api.PatchAutomation;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.automation.ActionType;
import oracle.glcm.opatch.common.impl.automation.AutomationVariables;
import oracle.glcm.opatch.common.impl.automation.Command;
import oracle.glcm.opatch.common.impl.automation.CommandAction;
import oracle.glcm.opatch.common.impl.automation.DeployAction;
import oracle.glcm.opatch.common.impl.automation.DeployArtifact;
import oracle.glcm.opatch.common.impl.automation.J2EELifecycleAction;
import oracle.glcm.opatch.common.impl.automation.LifecycleAction;
import oracle.glcm.opatch.common.impl.automation.OnErrorType;
import oracle.glcm.opatch.common.impl.automation.Readme;
import oracle.glcm.opatch.common.impl.automation.ServiceStatus;
import oracle.glcm.opatch.common.impl.automation.Stripe;
import oracle.glcm.opatch.common.impl.automation.UserMessage;
import oracle.glcm.opatch.common.impl.automation.Variable;
import oracle.glcm.opatch.common.impl.dao.PatchAutomationDAO;

public class PatchAutomationImpl
implements PatchAutomation {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private PatchAutomationDAO padao = null;

    public PatchAutomationImpl() {
    }

    public void saveToDir(String patchLoc) throws PatchMetadataWritingException {
        this.padao.savePatchAutomationObj(patchLoc + Constants.PATH + Constants.AUTOMATION_XML);
    }

    public PatchAutomationImpl(String patchAutomationFileLocation) throws PatchMetadataLoadingException {
        this.padao = new PatchAutomationDAO(patchAutomationFileLocation);
    }

    public List<PatchAutomation.Variable> getVariables() {
        ArrayList<PatchAutomation.Variable> result = new ArrayList<PatchAutomation.Variable>();
        AutomationVariables autovars = this.padao.getPatchAutomationObj().getAutomationVariables();
        if (autovars == null) {
            this.logger.info("automation-variables does not exist in automation.xml");
        } else {
            List vars = autovars.getVariable();
            for (Variable v : vars) {
                VariableImpl avi = new VariableImpl(v);
                result.add(avi);
            }
        }
        return result;
    }

    public List<PatchAutomation.J2EELifecycleAction> getJ2EELifeCycleActions(PatchAutomation.PatchingPhase phase) {
        ArrayList<PatchAutomation.J2EELifecycleAction> result = new ArrayList<PatchAutomation.J2EELifecycleAction>();
        List<JAXBElement<? extends ActionType>> actionTypes = this.getActions(phase);
        if (actionTypes != null) {
            for (JAXBElement<? extends ActionType> aoc : actionTypes) {
                if (!(aoc.getValue() instanceof J2EELifecycleAction)) continue;
                result.add(new J2EELifecycleActionImpl((J2EELifecycleAction)aoc.getValue()));
            }
        }
        return result;
    }

    public List<PatchAutomation.DeployAction> getDeployActions(PatchAutomation.PatchingPhase phase) {
        ArrayList<PatchAutomation.DeployAction> result = new ArrayList<PatchAutomation.DeployAction>();
        List<JAXBElement<? extends ActionType>> actionTypes = this.getActions(phase);
        if (actionTypes != null) {
            for (JAXBElement<? extends ActionType> aoc : actionTypes) {
                if (!(aoc.getValue() instanceof DeployAction)) continue;
                result.add(new DeployActionImpl((DeployAction)aoc.getValue()));
            }
        }
        return result;
    }

    private List<JAXBElement<? extends ActionType>> getActions(PatchAutomation.PatchingPhase phase) {
        List actionTypes = null;
        switch (phase) {
            case PRE_PATCH_APPLICATION: {
                if (this.padao.getPatchAutomationObj().getPrePatchApplication() == null) break;
                actionTypes = this.padao.getPatchAutomationObj().getPrePatchApplication().getAction();
                break;
            }
            case PATCH_APPLICATION: {
                if (this.padao.getPatchAutomationObj().getPatchApplication() == null) break;
                actionTypes = this.padao.getPatchAutomationObj().getPatchApplication().getAction();
                break;
            }
            case POST_PATCH_APPLICATION: {
                if (this.padao.getPatchAutomationObj().getPostPatchApplication() == null) break;
                actionTypes = this.padao.getPatchAutomationObj().getPostPatchApplication().getAction();
                break;
            }
            case POST_PATCH_GI_APPLICATION: {
                if (this.padao.getPatchAutomationObj().getPostPatchGiApplication() == null) break;
                actionTypes = this.padao.getPatchAutomationObj().getPostPatchGiApplication().getAction();
                break;
            }
            case POST_PATCH_RAC_APPLICATION: {
                if (this.padao.getPatchAutomationObj().getPostPatchRacApplication() == null) break;
                actionTypes = this.padao.getPatchAutomationObj().getPostPatchRacApplication().getAction();
                break;
            }
        }
        return actionTypes;
    }

    public List<PatchAutomation.CommandAction> getCommandActions(PatchAutomation.PatchingPhase phase) {
        ArrayList<PatchAutomation.CommandAction> result = new ArrayList<PatchAutomation.CommandAction>();
        List<JAXBElement<? extends ActionType>> actionTypes = this.getActions(phase);
        if (actionTypes != null) {
            for (JAXBElement<? extends ActionType> aoc : actionTypes) {
                if (!(aoc.getValue() instanceof CommandAction)) continue;
                result.add(new CommandActionImpl((CommandAction)aoc.getValue()));
            }
        }
        return result;
    }

    public class DeployArtifactImpl
    implements PatchAutomation.DeployArtifact {
        private String fileName = null;
        private String destinationPath = null;
        private String name = null;
        private String revision = null;
        private Boolean baseCompositeDeployment = false;

        public DeployArtifactImpl(DeployArtifact daf) {
            if (daf != null) {
                this.fileName = daf.getFileName();
                this.destinationPath = daf.getDestinationPath();
                this.name = daf.getName();
                this.revision = daf.getRevision();
                if (daf.isBaseCompositeDeployment() != null) {
                    this.baseCompositeDeployment = daf.isBaseCompositeDeployment();
                }
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getDestinationPath() {
            return this.destinationPath;
        }

        public String getName() {
            return this.name;
        }

        public String getRevision() {
            return this.revision;
        }

        public Boolean getBaseCompositeDeployment() {
            return this.baseCompositeDeployment;
        }
    }

    class CommandActionImpl
    extends ActionImpl
    implements PatchAutomation.CommandAction {
        List<PatchAutomation.Command> commandList;

        CommandActionImpl(CommandAction ca) {
            super((ActionType)ca);
            this.commandList = null;
            if (ca != null) {
                this.commandList = this.createCommandList(ca.getCommand());
            }
        }

        public List<PatchAutomation.Command> getCommand() {
            return this.commandList;
        }

        List<PatchAutomation.Command> createCommandList(List<Command> cmdList) {
            ArrayList<PatchAutomation.Command> result = new ArrayList<PatchAutomation.Command>();
            for (Command c : cmdList) {
                result.add(new CommandImpl(c));
            }
            return result;
        }
    }

    class CommandImpl
    implements PatchAutomation.Command {
        String currentWorkingDir = null;
        List<PatchAutomation.Command.EnvVar> envVars = null;
        List<String> params = null;
        PatchAutomation.Command.Source source = null;

        CommandImpl(Command c) {
            if (c != null) {
                this.currentWorkingDir = c.getCurrentWorkingDir();
                this.envVars = this.createEnvVarsList(c.getEnvVar());
                this.params = c.getParameter();
                this.source = new SourceImpl(c.getSource());
            }
        }

        public String getCurrentWorkingDir() {
            return this.currentWorkingDir;
        }

        public List<PatchAutomation.Command.EnvVar> getEnvVar() {
            return this.envVars;
        }

        public List<String> getParameter() {
            return this.params;
        }

        public PatchAutomation.Command.Source getSource() {
            return this.source;
        }

        public String toString() {
            StringBuffer sf = new StringBuffer();
            for (PatchAutomation.Command.EnvVar ev : this.envVars) {
                sf.append("EnvVar:" + ev + "\n");
            }
            for (String s : this.params) {
                sf.append("Param:" + s + "\n");
            }
            sf.append("Source:" + this.source + "\n");
            return sf.toString();
        }

        List<PatchAutomation.Command.EnvVar> createEnvVarsList(List<Command.EnvVar> evList) {
            ArrayList<PatchAutomation.Command.EnvVar> result = new ArrayList<PatchAutomation.Command.EnvVar>();
            for (Command.EnvVar ev : evList) {
                result.add(new EnvVarImpl(ev));
            }
            return result;
        }

        class SourceImpl
        implements PatchAutomation.Command.Source {
            String type = null;
            String value = null;

            SourceImpl(Command.Source s) {
                if (s != null) {
                    this.type = s.getType();
                    this.value = s.getValue();
                }
            }

            public String getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "Type:" + this.type + " value:" + this.value;
            }
        }

        class EnvVarImpl
        implements PatchAutomation.Command.EnvVar {
            String name = null;
            String value = null;

            EnvVarImpl(Command.EnvVar ev) {
                if (ev != null) {
                    this.name = ev.getName();
                    this.value = ev.getValue();
                }
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "Name:" + this.name + " value:" + this.value;
            }
        }
    }

    public class DeployActionImpl
    extends ActionImpl
    implements PatchAutomation.DeployAction {
        String domain;
        List<PatchAutomation.DeployArtifact> deployArtifacts;

        DeployActionImpl(DeployAction da) {
            super((ActionType)da);
            this.domain = null;
            this.deployArtifacts = null;
            if (da != null) {
                this.domain = da.getDomain();
                this.deployArtifacts = this.createDeployArtifactList(da.getDeployArtifact());
            }
        }

        List<PatchAutomation.DeployArtifact> createDeployArtifactList(List<DeployArtifact> list) {
            ArrayList<PatchAutomation.DeployArtifact> result = new ArrayList<PatchAutomation.DeployArtifact>();
            for (DeployArtifact da : list) {
                result.add(new DeployArtifactImpl(da));
            }
            return result;
        }

        public List<PatchAutomation.DeployArtifact> getDeployArtifacts() {
            return this.deployArtifacts;
        }

        public String getDomain() {
            return this.domain;
        }
    }

    public class J2EELifecycleActionImpl
    extends LifecycleActionImpl
    implements PatchAutomation.J2EELifecycleAction {
        String domain;
        List<String> appEntityName;

        J2EELifecycleActionImpl(J2EELifecycleAction j) {
            super((LifecycleAction)j);
            this.domain = null;
            this.appEntityName = null;
            if (j != null) {
                this.domain = j.getDomain();
                this.appEntityName = j.getApplicableEntityName();
            }
        }

        public String getDomain() {
            return this.domain;
        }

        public List<String> getApplicableEntityNames() {
            return this.appEntityName;
        }
    }

    class LifecycleActionImpl
    extends ActionImpl
    implements PatchAutomation.LifecycleAction {
        List<PatchAutomation.LifecycleAction.Dependency> listDependency;

        LifecycleActionImpl(LifecycleAction la) {
            super((ActionType)la);
            this.listDependency = null;
            if (la != null) {
                this.listDependency = this.getDependencyList(la.getDependency());
            }
        }

        public List<PatchAutomation.LifecycleAction.Dependency> getDependency() {
            return this.listDependency;
        }

        List<PatchAutomation.LifecycleAction.Dependency> getDependencyList(List<LifecycleAction.Dependency> list) {
            ArrayList<PatchAutomation.LifecycleAction.Dependency> result = new ArrayList<PatchAutomation.LifecycleAction.Dependency>();
            for (LifecycleAction.Dependency d : list) {
                result.add(new DependencyImpl(d));
            }
            return result;
        }

        class DependencyImpl
        implements PatchAutomation.LifecycleAction.Dependency {
            PatchAutomation.Readme readme = null;
            String type = null;

            DependencyImpl(LifecycleAction.Dependency d) {
                if (d != null) {
                    this.readme = new ReadmeImpl(d.getReadme());
                    this.type = d.getType();
                }
            }

            public PatchAutomation.Readme getReadme() {
                return this.readme;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    class ActionImpl
    implements PatchAutomation.Action {
        String actsOn = null;
        PatchAutomation.OnErrorType oet = null;
        PatchAutomation.Readme readme = null;
        String runAs = null;
        PatchAutomation.ServiceStatus ss = null;
        PatchAutomation.Stripe stripe = null;
        String tag = null;
        String type = null;
        String whilePatching = null;
        Boolean actsOnClone = false;
        Boolean cmdRequiredPassword = false;

        ActionImpl(ActionType at) {
            if (at != null) {
                this.actsOn = at.getActsOn();
                this.oet = this.createOnErrorType(at.getOnError());
                this.readme = new ReadmeImpl(at.getReadme());
                this.runAs = at.getRunAs();
                this.ss = this.createServiceStatus(at.getServiceStatus());
                this.stripe = new StripeImpl(at.getStripe());
                this.tag = at.getTag();
                this.type = at.getType();
                this.whilePatching = at.getWhilePatching();
                this.actsOnClone = at.isActsOnClone();
                this.cmdRequiredPassword = at.isCmdRequiresPassword();
            }
        }

        public String getActsOn() {
            return this.actsOn;
        }

        public PatchAutomation.OnErrorType getOnError() {
            return this.oet;
        }

        public PatchAutomation.Readme getReadme() {
            return this.readme;
        }

        public String getRunAs() {
            return this.runAs;
        }

        public PatchAutomation.ServiceStatus getServiceStatus() {
            return this.ss;
        }

        public PatchAutomation.Stripe getStripe() {
            return this.stripe;
        }

        public String getTag() {
            return this.tag;
        }

        public String getType() {
            return this.type;
        }

        public String getWhilePatching() {
            return this.whilePatching;
        }

        public Boolean getActsOnClone() {
            return this.actsOnClone;
        }

        public Boolean getCmdRequiredPassword() {
            return this.cmdRequiredPassword;
        }

        PatchAutomation.OnErrorType createOnErrorType(OnErrorType oet) {
            if (oet != null) {
                return PatchAutomation.OnErrorType.fromValue((String)oet.value());
            }
            return null;
        }

        PatchAutomation.ServiceStatus createServiceStatus(ServiceStatus ss) {
            if (ss != null) {
                return PatchAutomation.ServiceStatus.fromValue((String)ss.value());
            }
            return null;
        }
    }

    class StripeImpl
    implements PatchAutomation.Stripe {
        String homeType = null;
        String name = null;
        String targetHome = null;

        StripeImpl(Stripe s) {
            if (s != null) {
                this.homeType = s.getHomeType();
                this.name = s.getName();
                this.targetHome = s.getTargetHome();
            }
        }

        public String getHomeType() {
            return this.homeType;
        }

        public String getName() {
            return this.name;
        }

        public String getTargetHome() {
            return this.targetHome;
        }

        public String toString() {
            return "HomeType:" + this.homeType + " Name:" + this.name + " TargetHome:" + this.targetHome;
        }
    }

    class ReadmeImpl
    implements PatchAutomation.Readme {
        PatchAutomation.UserMessage userMessage = null;
        List<PatchAutomation.Readme.Parameter> listParams = null;
        PatchAutomation.UserMessage title = null;
        PatchAutomation.UserMessage troubleshoot = null;

        ReadmeImpl(Readme r) {
            if (r != null) {
                this.userMessage = new UserMessageImpl(r.getMessage());
                this.listParams = this.getListParams(r.getParameter());
                this.title = new UserMessageImpl(r.getTitle());
                this.troubleshoot = new UserMessageImpl(r.getTroubleshoot());
            }
        }

        public PatchAutomation.UserMessage getUserMessage() {
            return this.userMessage;
        }

        public List<PatchAutomation.Readme.Parameter> getParameter() {
            return this.listParams;
        }

        public PatchAutomation.UserMessage getTitle() {
            return this.title;
        }

        public PatchAutomation.UserMessage getTroubleshoot() {
            return this.troubleshoot;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("User Message:" + (this.userMessage == null ? null : this.userMessage.toString()) + "\n");
            result.append("Title:" + (this.title == null ? null : this.title.toString()) + "\n");
            if (this.listParams == null) {
                result.append("Parameter is null");
            } else {
                for (PatchAutomation.Readme.Parameter p : this.listParams) {
                    result.append("Parameter:" + p.toString());
                }
            }
            result.append("Troubleshoot:" + (this.troubleshoot == null ? null : this.troubleshoot.toString()) + "\n");
            return result.toString();
        }

        List<PatchAutomation.Readme.Parameter> getListParams(List<Readme.Parameter> list) {
            ArrayList<PatchAutomation.Readme.Parameter> result = new ArrayList<PatchAutomation.Readme.Parameter>();
            for (Readme.Parameter p : list) {
                result.add(new ParameterImpl(p));
            }
            return result;
        }

        class ParameterImpl
        implements PatchAutomation.Readme.Parameter {
            String name = null;
            String type = null;
            String value = null;

            ParameterImpl(Readme.Parameter p) {
                if (p != null) {
                    this.name = p.getName();
                    this.type = p.getType();
                    this.value = p.getValue();
                }
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "Name:" + this.name + " Type:" + this.type + " Value:" + this.value;
            }
        }
    }

    class UserMessageImpl
    implements PatchAutomation.UserMessage {
        String key = null;
        String value = null;

        public UserMessageImpl(UserMessage um) {
            if (um != null) {
                this.key = um.getPropertyKey();
                this.value = um.getValue();
            }
        }

        public String getPropertyKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Key:" + this.key + " Value:" + this.value;
        }
    }

    public class VariableImpl
    implements PatchAutomation.Variable {
        private String name = null;
        private Boolean required = null;
        private Boolean secured = null;
        private String defaultValue = null;
        private PatchAutomation.UserMessage promptUser = null;

        public VariableImpl(Variable v) {
            if (v != null) {
                this.name = v.getName();
                this.required = v.isRequired();
                this.secured = v.isSecured();
                this.defaultValue = v.getDefaultValue();
                this.promptUser = new UserMessageImpl(v.getPromptUser());
            }
        }

        public String getName() {
            return this.name;
        }

        public Boolean isSecured() {
            return this.secured;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public PatchAutomation.UserMessage getPromptUser() {
            return this.promptUser;
        }

        public Boolean isRequired() {
            return this.required;
        }
    }
}

