/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.glcm.opatch.common.api.InventoryEntryReferenceType;
import oracle.glcm.opatch.common.api.PatchConfigAction;
import oracle.glcm.opatch.common.api.PatchConfigActionParam;
import oracle.glcm.opatch.common.impl.InventoryEntryReferenceImpl;
import oracle.glcm.opatch.common.impl.PatchConfigActionParamImpl;
import oracle.glcm.opatch.common.impl.pad.ActionType;
import oracle.glcm.opatch.common.impl.pad.InventoryEntryReference;
import oracle.glcm.opatch.common.impl.pad.ParameterType;

public class PatchConfigActionImpl
implements PatchConfigAction {
    private ActionType action = null;

    public PatchConfigActionImpl(ActionType at) {
        this.action = at;
    }

    protected PatchConfigActionImpl() {
        this.action = new ActionType();
    }

    public List<String> getCategory() {
        return this.action.getCategory();
    }

    public List<String> getExecutionDirective() {
        return this.action.getExecutionDirective();
    }

    public String getId() {
        return this.action.getId();
    }

    public InventoryEntryReferenceType getInventoryEntryReference() {
        InventoryEntryReference ief = this.action.getInventoryEntryReference();
        if (ief != null) {
            return new InventoryEntryReferenceImpl(ief);
        }
        return null;
    }

    public List<String> getLifecycleHint() {
        return this.action.getLifecycleHint();
    }

    public List<PatchConfigActionParam> getParameters() {
        ArrayList<PatchConfigActionParam> list = new ArrayList<PatchConfigActionParam>();
        List pl = this.action.getParameter();
        for (ParameterType pt : pl) {
            list.add(new PatchConfigActionParamImpl(pt));
        }
        return list;
    }

    public String getType() {
        return this.action.getType();
    }

    public String getFailureMode() {
        return this.action.getFailureMode();
    }

    public void setFailureMode(String str) {
        this.action.setFailureMode(str);
    }

    public void setId(String str) {
        this.action.setId(str);
    }

    public void setLifecycleHint(List<String> strList) {
        this.action.getLifecycleHint().addAll(strList);
    }

    public void setParameters(List<PatchConfigActionParam> pcapList) {
        List paramList = this.action.getParameter();
        for (PatchConfigActionParam pcap : pcapList) {
            paramList.add(this.convertToParameterType(pcap));
        }
    }

    public void setType(String str) {
        this.action.setType(str);
    }

    public PatchConfigActionParam createPatchConfigActionParam() {
        return new PatchConfigActionParamImpl();
    }

    private ParameterType convertToParameterType(PatchConfigActionParam pcap) {
        ParameterType pt = new ParameterType();
        pt.setName(pcap.getName());
        pt.setValue(pcap.getValue());
        return pt;
    }

    public String getOrder() {
        return this.action.getOrder();
    }

    public String getName() {
        return this.action.getName();
    }

    public String getPatchUptimeOption() {
        return this.action.getPatchUptimeOption() == null ? null : this.action.getPatchUptimeOption().toUpperCase();
    }

    public void setCategory(List<String> listStr) {
        this.action.getCategory().addAll(listStr);
    }

    public void setExecutionDirective(List<String> strList) {
        this.action.getExecutionDirective().addAll(strList);
    }

    public void setInventoryEntryReference(InventoryEntryReferenceType ieft) {
        this.action.setInventoryEntryReference(InventoryEntryReferenceImpl.convertToInventoryEntryReference(ieft));
    }

    public void setOrder(String str) {
        this.action.setOrder(str);
    }

    public List<InventoryEntryReferenceType> getPrereqInventoryEntryReference() {
        ArrayList<InventoryEntryReferenceType> result = new ArrayList<InventoryEntryReferenceType>();
        for (InventoryEntryReference ief : this.action.getPrereqInventoryEntryReference()) {
            result.add(new InventoryEntryReferenceImpl(ief));
        }
        return result;
    }

    public static ActionType convertToActionType(PatchConfigAction pca) {
        ActionType at = new ActionType();
        at.setId(pca.getId());
        at.setType(pca.getType());
        at.setName(pca.getName());
        at.getCategory().addAll(pca.getCategory());
        at.setInventoryEntryReference(InventoryEntryReferenceImpl.convertToInventoryEntryReference(pca.getInventoryEntryReference()));
        for (InventoryEntryReferenceType ieft : pca.getPrereqInventoryEntryReference()) {
            at.getPrereqInventoryEntryReference().add(InventoryEntryReferenceImpl.convertToInventoryEntryReference(ieft));
        }
        at.getExecutionDirective().addAll(pca.getExecutionDirective());
        at.getLifecycleHint().addAll(pca.getLifecycleHint());
        at.setOrder(pca.getOrder());
        at.setFailureMode(pca.getFailureMode());
        List pcapList = pca.getParameters();
        for (PatchConfigActionParam pcap : pcapList) {
            at.getParameter().add(PatchConfigActionParamImpl.convertToParameterType(pcap));
        }
        return at;
    }

    public void setPrereqInventoryEntryReference(List<InventoryEntryReferenceType> iertList) {
        for (InventoryEntryReferenceType iert : iertList) {
            this.action.getPrereqInventoryEntryReference().add(InventoryEntryReferenceImpl.convertToInventoryEntryReference(iert));
        }
    }

    public InventoryEntryReferenceType createInventoryEntryReferenceType() {
        return new InventoryEntryReferenceImpl();
    }

    public void setName(String str) {
        this.action.setName(str);
    }

    public void setPatchUptimeOption(String str) {
        if (str != null && this.action != null) {
            this.action.setPatchUptimeOption(str);
        }
    }

    public String getComponentName() {
        return this.action.getComponentName();
    }

    public void setComponentName(String componentName) {
        if (componentName != null && this.action != null) {
            this.action.setComponentName(componentName);
        }
    }

    public String getComponentVersion() {
        return this.action.getComponentVersion();
    }

    public void setComponentVersion(String componentVersion) {
        if (componentVersion != null && this.action != null) {
            this.action.setComponentVersion(componentVersion);
        }
    }
}

