/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.ContentType;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchFastInstall;
import oracle.glcm.opatch.common.api.PatchInstallException;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.api.alias.action.MappingAction;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchBuilderFactory;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchRec;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasRec;
import oracle.glcm.opatch.common.api.alias.patch.PatchRec;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;
import oracle.glcm.opatch.common.impl.alias.patch.MaintenanceAliasPatchService;

public class PatchFastInstallImpl
implements PatchFastInstall {
    private static PatchFastInstallImpl instance = null;

    private PatchFastInstallImpl() {
    }

    public static PatchFastInstallImpl getInstance() {
        if (instance == null) {
            instance = new PatchFastInstallImpl();
        }
        return instance;
    }

    public void apply(String oracleHome, Patch patch) throws PatchInstallException {
        if (oracleHome == null || oracleHome.isEmpty()) {
            throw new PatchInstallException("The home directory provided was null or empty string.");
        }
        if (patch == null) {
            throw new PatchInstallException("The patch provided was null.");
        }
        StringBuilder destinationPatchLoc = new StringBuilder(oracleHome);
        destinationPatchLoc.append(Constants.PATH);
        destinationPatchLoc.append(Constants.OH_ONEOFFS_DIR);
        destinationPatchLoc.append(Constants.PATH);
        destinationPatchLoc.append(patch.getPatchId());
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc.toString(), new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchInstallException("Failed to create patch metadata patch directory: " + dir, (Throwable)e);
            }
        } else {
            throw new PatchInstallException("Patch " + patch.getPatchId() + " already exists in " + dir);
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchInstallException("Cannot create directory " + dir + " for metadata patch fast install");
        }
        try {
            patch.cloneMetadata(dir.toString());
            HomeOperationsExt homeOperations = HomeOperationsFactory.getInstance().getHomeOperations(oracleHome);
            PatchInfo patchInfo = this.getMetaDataPatchInfo(patch);
            homeOperations.processPatch(patchInfo);
            homeOperations.addPatchToInventory(patchInfo);
            homeOperations.saveInventory();
            this.updateMaintenanceAlias(oracleHome, patch);
        }
        catch (Exception e) {
            throw new PatchInstallException("Failed to apply metadata patch into home " + oracleHome, (Throwable)e);
        }
    }

    private PatchInfo getMetaDataPatchInfo(Patch patch) throws PatchInstallException {
        ContentType contentType;
        PatchInventory.PatchCharacteristics patchChara;
        boolean isMataDataPatch = false;
        List inventories = patch.getPatchInventories();
        PatchInventory patchInventory = null;
        if (inventories != null && !inventories.isEmpty() && (patchChara = (patchInventory = (PatchInventory)inventories.get(0)).getPatchChara()) != null && (contentType = patchChara.getContentType()) != null && contentType == ContentType.METADATA) {
            isMataDataPatch = true;
        }
        if (!isMataDataPatch) {
            throw new PatchInstallException("The patch provided was not a meta-data patch: " + patch);
        }
        ArrayList<String> bugList = new ArrayList<String>();
        List bugs = patchInventory.getBugs();
        for (PatchInventory.Bug bug : bugs) {
            bugList.add(bug.getNumber());
        }
        HomeOperationsFactory homeOpsFactory = HomeOperationsFactory.getInstance();
        PatchFactoryImpl patchFactory = new PatchFactoryImpl();
        HashMap<ComponentInfo, ComponentCheckResult> patchComponents = new HashMap<ComponentInfo, ComponentCheckResult>();
        for (PatchInventory.Component component : patch.getComponents()) {
            ComponentCheckResult result = patchFactory.createComponentCheckResult(component);
            result.setResult(Result.PROCESS_COMPONENT);
            patchComponents.put(homeOpsFactory.getComponentInfo(component.getName(), component.getVersion(), component.getPatchLevel()), result);
        }
        PatchInfo.Builder builder = HomeOperationsFactory.getInstance().getPatchInfoBuilder();
        builder.patchId(patch.getPatchId()).patchUpi(patch.getPatchUpi()).metaDataPatch(true).description(patch.getPatchDescription()).patchComponents(patchComponents).bugList(bugList);
        return builder.build();
    }

    private void updateMaintenanceAlias(String oracleHome, Patch patch) throws PatchInstallException {
        HashSet<String> maintenanceAliasKeys = new HashSet<String>();
        List MaintenanceAliasActionHolders = patch.getMaintenanceAliasActionHolders();
        for (MaintenanceAliasActionHolder maintenanceAliasActionHolder : MaintenanceAliasActionHolders) {
            Object maintenanceAliasAction2;
            Set maintenanceAliasActions = maintenanceAliasActionHolder.getMaintenanceAliasActions();
            for (Object maintenanceAliasAction2 : maintenanceAliasActions) {
                String maintenanceAliasKey = maintenanceAliasAction2.getMaintenanceAlias().getMaintenanceAliasKey();
                maintenanceAliasKeys.add(maintenanceAliasKey);
            }
            Set mappingActions = maintenanceAliasActionHolder.getMappingActions();
            maintenanceAliasAction2 = mappingActions.iterator();
            while (maintenanceAliasAction2.hasNext()) {
                MappingAction mappingAction = (MappingAction)maintenanceAliasAction2.next();
                String maintenanceAliasKey = mappingAction.getMaintenanceAliasKey();
                maintenanceAliasKeys.add(maintenanceAliasKey);
            }
        }
        if (maintenanceAliasKeys == null || maintenanceAliasKeys.isEmpty()) {
            return;
        }
        Path maintenanceAliasPatchXMLFile = null;
        try {
            StringBuilder maintenanceAliasPatchXMLFilePath = new StringBuilder(oracleHome);
            maintenanceAliasPatchXMLFilePath.append(Constants.PATH);
            maintenanceAliasPatchXMLFilePath.append(Constants.OH_ONEOFFS_DIR);
            maintenanceAliasPatchXMLFilePath.append(Constants.PATH);
            maintenanceAliasPatchXMLFilePath.append(Constants.PATCH_MAINTENANCEALIAS_XML);
            maintenanceAliasPatchXMLFile = NioServiceFactory.getNioService().getPath(maintenanceAliasPatchXMLFilePath.toString(), new String[0]);
            MaintenanceAliasPatchService mapService = MaintenanceAliasPatchService.getInstance();
            if (!Files.exists(maintenanceAliasPatchXMLFile, new LinkOption[0])) {
                Path maintenanceAliasPatchXMLDir = maintenanceAliasPatchXMLFile.getParent();
                if (!Files.exists(maintenanceAliasPatchXMLDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(maintenanceAliasPatchXMLDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to create new diretory at " + maintenanceAliasPatchXMLFile.getParent(), e);
                    }
                }
                Files.createFile(maintenanceAliasPatchXMLFile, new FileAttribute[0]);
                mapService.initMaintenanceAliasPatch(maintenanceAliasPatchXMLFile);
            }
            String patchUPI = patch.getPatchUpi();
            String patchID = patch.getPatchId();
            StringBuilder destinationPatchLoc = new StringBuilder(oracleHome);
            destinationPatchLoc.append(Constants.PATH);
            destinationPatchLoc.append(Constants.OH_ONEOFFS_DIR);
            destinationPatchLoc.append(Constants.PATH);
            destinationPatchLoc.append(patch.getPatchId());
            String patchLocation = destinationPatchLoc.toString();
            Date patchCreationTime = ((PatchInventory)patch.getPatchInventories().get(0)).getDateOfPatch().getTime();
            Date patchAppliactionTime = new Date();
            MaintenanceAliasPatchRec mapRec = mapService.loadMaintenanceAliasPatch(maintenanceAliasPatchXMLFile);
            MaintenanceAliasPatchBuilderFactory builderFactory = mapService.getMaintenanceAliasPatchBuilderFactory();
            PatchRec patchRec = mapService.retrievePatch(mapRec, patchUPI);
            if (patchRec == null) {
                patchRec = builderFactory.getPatchRecBuilder(patchUPI).setId(patchID).setPatchLocation(patchLocation).setCreationTime(patchCreationTime).setApplicationTime(patchAppliactionTime).build();
                mapRec.addPatchRec(patchRec);
            }
            Set<MaintenanceAliasRec> maintenanceAliasRecs = mapService.filterMaintenanceAlias(mapRec, maintenanceAliasKeys);
            if (!maintenanceAliasKeys.isEmpty()) {
                for (String maintenanceAliasKey : maintenanceAliasKeys) {
                    MaintenanceAliasRec maintenanceAliasRec = builderFactory.getMaintenanceAliasRecBuilder(maintenanceAliasKey).setPatchUpis(new HashSet()).build();
                    maintenanceAliasRecs.add(maintenanceAliasRec);
                    mapRec.addMaintenanceAliasRec(maintenanceAliasRec);
                }
            }
            for (MaintenanceAliasRec maintenanceAliasRec : maintenanceAliasRecs) {
                maintenanceAliasRec.addPatchUpi(patchUPI);
            }
            mapService.storeMaintenanceAliasPatch(mapRec, maintenanceAliasPatchXMLFile);
        }
        catch (MaintenanceAliasException e) {
            throw new PatchInstallException("Errors occured when applying maintenance aliases", (Throwable)e);
        }
        catch (IOException e) {
            throw new PatchInstallException("Failed to create new File at " + maintenanceAliasPatchXMLFile, (Throwable)e);
        }
    }
}

