/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasInfoDAO;

public class PatchMaintenanceAliasImpl {
    private MaintenanceAliasInfoDAO dao = null;

    public PatchMaintenanceAliasImpl() {
    }

    public PatchMaintenanceAliasImpl(String maintenanceAliasFileLoc) throws MaintenanceAliasException {
        this.dao = new MaintenanceAliasInfoDAO(maintenanceAliasFileLoc, true);
    }

    protected void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path maintenanceAliasFilePath = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.MAINTENANCEALIAS_XML, new String[0]);
        Path parentPath = maintenanceAliasFilePath.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + parentPath + " for cloning patch maintenance_alias.xml", (Throwable)e);
            }
        }
        if (!Files.exists(parentPath, new LinkOption[0]) || Files.isRegularFile(parentPath, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning patch maintenance_alias.xml");
        }
        try {
            this.dao.saveToFile(maintenanceAliasFilePath);
        }
        catch (MaintenanceAliasException e) {
            throw new PatchMetadataWritingException(e.getMessage(), (Throwable)e);
        }
    }
}

