/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.glcm.opatch.common.api.SystemPatchBundle;
import oracle.glcm.opatch.common.impl.bundle.Automation;
import oracle.glcm.opatch.common.impl.bundle.Fvalue;
import oracle.glcm.opatch.common.impl.bundle.Product;
import oracle.glcm.opatch.common.impl.bundle.Release;
import oracle.glcm.opatch.common.impl.bundle.Subpatch;
import oracle.glcm.opatch.common.impl.bundle.SystemTargetType;
import oracle.glcm.opatch.common.impl.bundle.TargetType;
import oracle.glcm.opatch.common.impl.dao.PatchBundleDAO;

public class SystemPatchBundleImpl
implements SystemPatchBundle {
    private PatchBundleDAO pbdao = null;

    public SystemPatchBundleImpl(PatchBundleDAO pbdao) {
        this.pbdao = pbdao;
    }

    public String getTypeVersion() {
        return this.pbdao.getBundleObj().getTypeVersion();
    }

    public SystemPatchBundle.PatchType getBundleType() {
        if (this.pbdao.getBundleObj().getBundleType() != null) {
            return SystemPatchBundle.PatchType.fromValue((String)this.pbdao.getBundleObj().getBundleType().value());
        }
        return null;
    }

    public String getPatchAbstract() {
        return this.pbdao.getBundleObj().getPatchAbstract();
    }

    public String getPatchId() {
        return this.pbdao.getBundleObj().getPatchId();
    }

    public String getPatchUpi() {
        return this.pbdao.getBundleObj().getUniquePatchId();
    }

    public String getIsDeployOrderRequired() {
        return this.pbdao.getBundleObj().getIsDeployOrderRequired();
    }

    public SystemPatchBundle.System getSystem() {
        return new SystemImpl(this.pbdao.getBundleObj().getSystem());
    }

    public List<SystemPatchBundle.SubPatch> getSubPatches() {
        ArrayList<SystemPatchBundle.SubPatch> result = new ArrayList<SystemPatchBundle.SubPatch>();
        if (this.pbdao.getBundleObj().getSubpatches() == null) {
            return result;
        }
        List spList = this.pbdao.getBundleObj().getSubpatches().getSubpatch();
        for (Subpatch sp : spList) {
            result.add(new SubPatchImpl(sp));
        }
        return result;
    }

    public SystemPatchBundle.Automation getAutomation() {
        return new AutomationImpl(this.pbdao.getBundleObj().getAutomation());
    }

    public SystemPatchBundle.Fvalue getFvalue() {
        return new FvalueImpl(this.pbdao.getBundleObj().getFvalue());
    }

    class FvalueImpl
    implements SystemPatchBundle.Fvalue {
        private String minOpatchVersion = null;
        private String value = null;
        private String function = null;

        public FvalueImpl(Fvalue fv) {
            this.minOpatchVersion = fv.getMinOpatchVersion();
            this.value = fv.getValue();
            this.function = fv.getFunction();
        }

        public String getMinOpatchVersion() {
            return this.minOpatchVersion;
        }

        public String getValue() {
            return this.value;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            return "MinOpatchVersion:" + this.getMinOpatchVersion() + " Value:" + this.getValue() + " Function:" + this.getFunction();
        }
    }

    class AutomationImpl
    implements SystemPatchBundle.Automation {
        private String hash = null;
        private String oplanVersion = null;

        public AutomationImpl(Automation a) {
            if (a != null) {
                this.hash = a.getHash();
                this.oplanVersion = a.getOplanVersion();
            }
        }

        public String getHash() {
            return this.hash;
        }

        public String getOplanVersion() {
            return this.oplanVersion;
        }

        public String toString() {
            return "Hash:" + this.getHash() + " OplanVersion:" + this.getOplanVersion();
        }
    }

    class SubPatchImpl
    implements SystemPatchBundle.SubPatch {
        private String patchUpi = null;
        private String patchId = null;
        private String platform = null;
        private String location = null;
        private SystemPatchBundle.PatchingTool patchingTool = null;
        private String toolVersion = null;
        private SystemPatchBundle.PatchType patchType = null;
        private String versionAfterPatching = null;
        private SystemPatchBundle.PayloadFormat payloadFormat = null;
        private Boolean areRpmFilesPackaged = null;
        private String destinationRepoLocation = null;
        private String rebootRequired = null;
        private SystemPatchBundle.TargetType.Release releaseAfterPatching = null;
        private List<SystemPatchBundle.TargetType> targetTypeList = new ArrayList<SystemPatchBundle.TargetType>();

        public SubPatchImpl(Subpatch sp) {
            this.patchUpi = sp.getUniquePatchId();
            this.patchId = sp.getPatchId();
            this.platform = sp.getPlatform();
            this.location = sp.getLocation();
            if (sp.getPatchingTool() != null) {
                this.patchingTool = SystemPatchBundle.PatchingTool.fromValue((String)sp.getPatchingTool().value());
            }
            this.toolVersion = sp.getToolVersion();
            this.patchType = SystemPatchBundle.PatchType.fromValue((String)sp.getPatchType().value());
            this.versionAfterPatching = sp.getVersionAfterPatching();
            if (sp.getPayloadFormat() != null) {
                this.payloadFormat = SystemPatchBundle.PayloadFormat.fromValue((String)sp.getPayloadFormat().value());
            }
            this.areRpmFilesPackaged = sp.isAreRpmFilesPackaged();
            this.destinationRepoLocation = sp.getDestinationRepoLocation();
            this.rebootRequired = sp.getRebootRequired();
            this.releaseAfterPatching = new TargetTypeImpl().new TargetTypeImpl.ReleaseImpl(sp.getReleaseAfterPatching());
            List ttList = sp.getTargetTypes().getTargetType();
            for (TargetType tt : ttList) {
                this.targetTypeList.add(new TargetTypeImpl(tt));
            }
        }

        public String getPatchUpi() {
            return this.patchUpi;
        }

        public String getPatchId() {
            return this.patchId;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getLocation() {
            return this.location;
        }

        public SystemPatchBundle.PatchingTool getPatchingTool() {
            return this.patchingTool;
        }

        public String getToolVersion() {
            return this.toolVersion;
        }

        public SystemPatchBundle.PatchType getPatchType() {
            return this.patchType;
        }

        public String getVersionAfterPatching() {
            return this.versionAfterPatching;
        }

        public SystemPatchBundle.PayloadFormat getPayloadFormat() {
            return this.payloadFormat;
        }

        public Boolean areRpmFilesPackaged() {
            return this.areRpmFilesPackaged;
        }

        public String getDestinationRepoLocation() {
            return this.destinationRepoLocation;
        }

        public String getRebootRequired() {
            return this.rebootRequired;
        }

        public SystemPatchBundle.TargetType.Release getReleaseAfterPatching() {
            return this.releaseAfterPatching;
        }

        public List<SystemPatchBundle.TargetType> getTargetTypes() {
            return this.targetTypeList;
        }
    }

    class SystemImpl
    extends TargetTypeImpl
    implements SystemPatchBundle.System {
        private String urmId;

        public SystemImpl(SystemTargetType stt) {
            super((TargetType)stt);
            this.urmId = null;
            this.urmId = stt.getUrmId();
        }

        public String getUrmId() {
            return this.urmId;
        }
    }

    class TargetTypeImpl
    implements SystemPatchBundle.TargetType {
        private String propertyName = null;
        private String propertyValue = null;
        private SystemPatchBundle.TargetType.EmTargetType type = null;
        private String version = null;
        private String versionAfterPatching = null;
        private SystemPatchBundle.TargetType.Product product = null;
        private SystemPatchBundle.TargetType.Release release = null;

        public TargetTypeImpl() {
        }

        public TargetTypeImpl(TargetType tt) {
            this.propertyName = tt.getPropertyName();
            this.propertyValue = tt.getPropertyValue();
            if (tt.getType() != null) {
                this.type = SystemPatchBundle.TargetType.EmTargetType.fromValue((String)tt.getType().value());
            }
            this.version = tt.getVersion();
            this.versionAfterPatching = tt.getVersionAfterPatching();
            this.product = new ProductImpl(tt.getProduct());
            this.release = new ReleaseImpl(tt.getRelease());
        }

        public SystemPatchBundle.TargetType.EmTargetType getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVersionAfterPatching() {
            return this.versionAfterPatching;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public SystemPatchBundle.TargetType.Product getProduct() {
            return this.product;
        }

        public SystemPatchBundle.TargetType.Release getRelease() {
            return this.release;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" PropertyName: " + this.getPropertyName());
            sb.append(" Property Value: " + this.getPropertyValue());
            sb.append(" Type: " + (this.getType() == null ? null : this.getType().value()));
            sb.append(" Version : " + this.getVersion());
            sb.append(" Version After Patching: " + this.getVersionAfterPatching());
            sb.append(" Product: " + this.getProduct().toString());
            sb.append(" Release: " + this.getRelease().toString());
            return sb.toString();
        }

        class ReleaseImpl
        implements SystemPatchBundle.TargetType.Release {
            private String urmId = null;
            private String aruId = null;
            private String value = null;

            public ReleaseImpl(Release r) {
                if (r != null) {
                    this.urmId = r.getUrmId();
                    this.aruId = r.getAruId();
                    this.value = r.getValue();
                }
            }

            public String getUrmId() {
                return this.urmId;
            }

            public String getAruId() {
                return this.aruId;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "UrmId:" + this.getUrmId() + " AruId:" + this.getAruId() + " Value:" + this.getValue();
            }
        }

        class ProductImpl
        implements SystemPatchBundle.TargetType.Product {
            private String qPartId = null;
            private String aruId = null;
            private String value = null;

            public ProductImpl(Product p) {
                if (p != null) {
                    this.qPartId = p.getQpartId();
                    this.aruId = p.getAruId();
                    this.value = p.getValue();
                }
            }

            public String getQpartId() {
                return this.qPartId;
            }

            public String getAruId() {
                return this.aruId;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "QpartId:" + this.getQpartId() + " AruId:" + this.getAruId() + " Value:" + this.getValue();
            }
        }
    }
}

